#input: generate-program, test-program, instance theory
#THIS FILE should not be ran directly! 

generate=$1
test=$2
instance=$3

theory=$4

#gringo 3 binary
#For AALTO users: this should work if /share/logic/bin/ is in your path
#Others: make sure this refers to gringo 3. Gringo 4 will not work. 
gringo="gringo"

#lp2normal binary
#For AALTO users: this should work if /share/logic/bin/ is in your path
lp2normal="lp2normal2"

#combiner path: can be found in this directory
combine="python3 ./combine.py"

#so2grounder binary 
#For AALTO users: this should work if /share/logic/bin/ is in your path
so2grounder="so2grounder" 

#the sat-to-sat linker
#For AALTO users: this should work if /share/logic/bin/ is in your path
s2slinker="sat-to-sat-linker.sh"

#sat-to-sat
#For AALTO users: this should work if /share/logic/bin/ is in your path
s2s="sat-to-sat"

progG=`mktemp /tmp/generate.XXXXXXXXXX` || exit 1
progT=`mktemp /tmp/test.XXXXXXXXXX` || exit 1
progCR=`mktemp /tmp/Combined.Reified.XXXXXXXXXX` || exit 1
so2grounderOUTPUTdir=`mktemp /tmp/OutDir.XXXXXXXXXX -d` || exit 1

runScript="bash $so2grounderOUTPUTdir/run.sh"


cat $generate $instance | $gringo | $lp2normal > $progG
cat $test     $instance | $gringo | $lp2normal > $progT

#echo "-----------------------------"
#cat $progG
#echo "-----------------------------"
#cat $progT
#echo "-----------------------------"

$combine -g $progG -t $progT > $progCR

# FOR TESTING:
# cat $progCR

$so2grounder $theory $so2grounderOUTPUTdir


allfiles="$so2grounderOUTPUTdir/*.sh"
chmod +x $allfiles


$runScript $s2slinker $progCR | $s2s -verb=0



#cleanup
rm $progG
rm $progT
rm $progCR
#FOR TESTING:
#echo $so2grounderOUTPUTdir
rm $so2grounderOUTPUTdir -r

