#!/usr/bin/env python3
# encoding: utf-8

import os
from src import commandline_parser
from src.parse import *
from src.reified_print import *
from src.utils import *


def run(args):
    generate_file = os.path.normpath(os.path.join(os.getcwd(), args.generateProgram))
    generate_lp = parse(generate_file)
    print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")
    print("% generate program:")
    print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")
    print_as_atoms(generate_lp, "generate")

    if args.testProgram != "":
        test_file = os.path.normpath(os.path.join(os.getcwd(), args.testProgram))
        print("%", test_file)
        test_lp = parse(test_file)
        print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")
        print("% test program:")
        print("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")
        print_as_atoms(test_lp, "test")
    else:
        warning("No test program provided. The result will be regular stable semantics.")


def main(argv=None):
    parser = commandline_parser.get_parser()

    args = parser.parse_args(argv)
    run(args)


if __name__ == "__main__":
    sys.exit(main())
