// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi
#include <iostream.h>
#include <new.h>
#include <stdlib.h>
#include "stable.h"

void a_new_handler ()
{
  cerr << "operator new failed: out of memory" << endl;
  exit(1);
}

void usage ()
{
  cerr << "Usage: smodels [number] [-w] [-nolookahead] [-backjump]"
       << " [-sloppy_heuristic]" << endl
       << "               [-tries number] [-conflicts number]"
       << " [-seed number]" << endl;
  cerr << "       The number determines the number of stable models computed."
       << endl 
       << "       A zero indicates all." << endl
       << "       -nolookahead do not use lookahead."
       << endl
       << "       -backjump does not always backtrack chronologically."
       << endl
       << "       -sloppy_heuristic doesn't compute the full heuristic after"
       << " lookahead" << endl
       << "       -w displays the well-founded model" << endl
       << "       -tries tries to find a model stochastically a"
       << " number of times" << endl
       << "       -conflicts is the number of backtracks before"
       << " the try fails" << endl
       << "       -seed mixes the program" << endl;
}

int main (int argc, char *argv[])
{
  set_new_handler (&a_new_handler);
  bool wellfounded = false;
  bool lookahead = true;
  bool backjumping = false;
  bool sloppy_heuristic = false;
  long models = 0;
  int sm = 0;
  long max_tries = 1;
  long max_conflicts = 0;
  long seed = 1;
  char *endptr;
  bool error = false;
  for (int c = 1; c < argc && !error; c++)
    {
      if (argv[c][0] == '-')
	{
	  if (strcmp (&argv[c][1], "w") == 0)
	    wellfounded = true;
	  else if (strcmp (&argv[c][1], "nolookahead") == 0)
	    lookahead = false;
	  else if (strcmp (&argv[c][1], "backjump") == 0)
	    backjumping = true;
	  else if (strcmp (&argv[c][1], "sloppy_heuristic") == 0)
	    sloppy_heuristic = true;
	  else if (strcmp (&argv[c][1], "conflicts") == 0)
	    {
	      c++;
	      if (c < argc)
		max_conflicts = strtol (argv[c], &endptr, 0);
	      else
		error = true;
	      if (*endptr != '\0')
		error = true;
	    }
	  else if (strcmp (&argv[c][1], "tries") == 0)
	    {
	      c++;
	      if (c < argc)
		max_tries = strtol (argv[c], &endptr, 0);
	      else
		error = true;
	      if (*endptr != '\0')
		error = true;
	    }
	  else if (strcmp (&argv[c][1], "seed") == 0)
	    {
	      c++;
	      if (c < argc)
		seed = strtol (argv[c], &endptr, 0);
	      else
		error = true;
	      if (*endptr != '\0')
		error = true;
	    }
	  else
	    error = true;
	}
      else
	{
	  models = strtol (argv[c], &endptr, 0);
	  if (models < 0 || *endptr != '\0')
	    error = true;
	  sm = 1;
	}
    }
  if (error)
    {
      usage ();
      return 1;
    }
  Stable stable;
  cout << "smodels version 2.0. Reading...";
  int bad = stable.read(cin);
  cout << "done" << endl;
  if (bad)
    {
      cerr << "Error in input" << endl;
      return 1;
    }
  if (sm)
    stable.smodels.max_models = models;
  stable.calculate (wellfounded, lookahead, backjumping, sloppy_heuristic,
		    max_conflicts, max_tries, seed);
  return 0;
}
