// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   timer.cc
// Author: Patrik Simons
//
#include <strstream.h>
#include <iomanip.h>

#include "timer.h"

Timer::Timer ()
{
  sec = 0;
  msec = 0;
}

void
Timer::start ()
{
  timer = clock ();
}

void
Timer::stop ()
{
  clock_t ticks = clock () - timer;
  sec += ticks / CLOCKS_PER_SEC;
  msec += (ticks - sec*CLOCKS_PER_SEC)*1000/CLOCKS_PER_SEC;
  if (msec >= 1000)
    {
      msec -= 1000;
      sec++;
    }
}

void 
Timer::reset ()
{
  sec = 0;
  msec = 0;
}

char *
Timer::print ()
{
  static char s[15];
  ostrstream str (s, sizeof (s));
  str << sec << '.' << setw(3) << setfill('0') << msec << ends;
  return str.str ();
}
