// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   main.cc
// Author: Patrik Simons
//
#include <iostream.h>
#include <new.h>
#include <stdlib.h>

#include "dl.h"

void a_new_handler ()
{
  cerr << "operator new failed: out of memory" << endl;
  exit(1);
}

void usage ()
{
  cerr << "Usage: smodels [number] [-w] [-nolookahead] [-backjump]" << endl;
  cerr << "       The number determines the number of stable models computed."
       << endl 
       << "       A zero indicates all." << endl
       << "       -nolookahead do not use lookahead."
       << endl
       << "       -backjump does not always backtrack chronologically."
       << endl
       << "       -w displays the well-founded model" << endl; 
}

int main (int argc, char *argv[])
{
  set_new_handler (&a_new_handler);
  int wellfounded = 0, lookahead = 1, backjumping = 0;
  long models = 0;
  int sm = 0;
  for (int c = argc-1; c > 0; c--)
    {
      if (argv[c][0] == '-')
	{
	  if (strcmp (&argv[c][1], "w") == 0)
	    wellfounded = 1;
	  else if (strcmp (&argv[c][1], "nolookahead") == 0)
	    lookahead = 0;
	  else if (strcmp (&argv[c][1], "backjump") == 0)
	    backjumping = 1;
	  else
	    {
	      usage ();
	      return 1;
	    }
	}
      else
	{
	  for (int i = 0; argv[c][i] != '\0'; i++)
	    if (argv[c][i] >= '0' && argv[c][i] <= '9' && !sm)
	      models = models*10 + argv[c][i]-'0';
	    else 
	      {
		usage ();
		return 1;
	      }
	  sm = 1;
	}
    }
  Dl dl;
  cout << "smodels version 1.9. Reading...";
  int bad = dl.read(cin);
  cout << "done" << endl;
  if (bad)
    {
      cerr << "Error in input" << endl;
      return 1;
    }
  if (sm)
    dl.max_models = models;
  dl.Calculate (wellfounded, lookahead, backjumping);
  return 0;
}
