// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   dl.h
// Author: Patrik Simons
//
#ifndef DL_H
#define DL_H

#include "atomrule.h"
#include "dcl.h"
#include "stack.h"
#include "timer.h"


class Dl
{
public:
  Dl ();
  virtual ~Dl ();
  void Init ();
  void nantInit ();
  int read (istream &f);

  void Calculate (int w, int lookahead, int backjumping);

  int setToBTrue (Atom *a);
  int setToBFalse (Atom *a);
  void pick ();
  void expand ();
  void setup ();
  int conflict ();
  int covered ();
  Atom *unwind ();
  Atom *backtrack ();
  Atom *backjump ();
  int smodels (int lookahead, int backjumping);
  int wellfounded ();
  int testPos (Atom *);
  int testNeg (Atom *);
  void testScore (long pos, long neg, long i, long &hiscore1,
		 long &hiscore2, long &hii, int &positive);
  void lookahead ();
  void resetDependency ();
  void print ();
  void printAnswer ();
  void printProgram ();
  void printStack ();
  void printRule (Rule *);

  void removenant (long);
  void addnant (Atom *);

  Dcl dcl;
  Atom **nant;
  long nanttop;
  long score;
  Stack stack;
  long guesses;
  int fail;
  long notcovered;
  Atom *conflict_found;
  long max_models;
  long level;
  Atom *cnflct;
  long lasti;

  long number_of_atoms;
  long number_of_rules;
  long size_of_sigma;
  long nant_size;
  long answer_number;
  long number_of_choice_points;
  long number_of_wrong_choices;
  long number_of_backjumps;
  long number_of_picked_atoms;
  long number_of_forced_atoms;
  Timer timer;
};

#endif
