// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   atomrule.h
// Author: Patrik Simons
//
#ifndef ATOMRULE_H
#define ATOMRULE_H

class Rule;

class Atom 
{
public:
  Atom ();
  ~Atom ();

  Rule **endHead;     // Sentinel of the head array
  Rule **endPos;      // Sentinel of the pos array 
  Rule **endNeg;      // Sentinel of the neg array 
  Rule **endPos2;     // Sentinel of the pos2 array = pos array, used
		      // to localize and thereby speed up the upper
		      // closure computation
  long headof;        // The number of rules in head array whose
		      // inactive counter is zero
  Rule **head;        // The rules whose heads are atom
  Rule **pos;         // The rules in which atom appears positively
  Rule **neg;         // The rules in which atom appears negatively
  long posScore;      // Used in heuristic and improvement of upper
		      // closure
  long negScore;      // Used in heuristic and improvement of upper
		      // closure
  char *name;         // The name of the atom
  bool closure;       // True if the atom is in the upper closure
  bool Bpos;          // True if the atom is in B+
  bool Bneg;          // True if the atom is in B-
  bool visited;       // For use in backjumping and improvement of
		      // upper closure
  bool guess;         // True if the atom currently is a guess
  bool isnant;        // True if the atom is in NAnt(P)
  bool dependsonTrue; // Used by lookahead (and initialization)
  bool dependsonFalse;// Used by lookahead (and initialization)
  bool backtracked;   // For use in printStack
  bool forced;        // For use in printStack
};

class Rule 
{
public:
  Rule ();
  ~Rule () {};

  Atom *head;        // The head of the rule
  long neg;          // The number of negative literals in body
                     // that are not in B- 
  long pos;          // The number of positive literals in body
		     // that are not in B+
  long pos2;         // The number of positive literal in body that
		     // are in the upper closure
  Atom **endBody;     // Sentinel of the body array
  Atom **body;       // The literals in the body, negative literals first
  Atom **firstPos;    // The first positive literal in the body
  long inactive;     // The number of positive literalss in B- plus
		     // the number of negative literals in B+
  bool visited;      // For use in backjumping only
};

#endif
