// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   improve.cc
// Author: Patrik Simons
//
#include <iostream.h>
#include "stack.h"
#include "dcl.h"

#define lowlink posScore
#define dfnumber negScore
#define marked dependsonTrue

class Improve
{
public:
  Improve (long size);
  ~Improve () {};
  void strong (Atom *);
  void removeFrom (Atom *a, Rule **r);

  long count;
  Stack stack;
};

Improve::Improve (long size)
{
  stack.Init (size);
  count = 0;
}

inline void
Improve::removeFrom (Atom *a, Rule **r)
{
  a->endPos2--;
  Rule *t = *r;
  *r = *a->endPos2;
  *a->endPos2 = t;
}

void
Improve::strong (Atom *a)
{
  Atom *b;
  a->visited = true;
  a->dfnumber = count;
  a->lowlink = count;
  count++;
  stack.push (a);
  for (Rule **r = a->pos; r != a->endPos2;)
    {
      b = (*r)->head;
      if (!b->visited)
	{
	  strong (b);
	  if (a->lowlink > b->lowlink)
	    a->lowlink = b->lowlink;
	}
      else if (!b->marked && a->lowlink > b->dfnumber)
	a->lowlink = b->dfnumber;
      if (b->marked)
	removeFrom (a, r);
      else
	r++;
    }
  if (a->lowlink == a->dfnumber)
    do {
      b = stack.pop ();
      b->marked = true;
    } while (a != b);
}

void
Dcl::improve ()
{
  Atom *a;
  for (a = atoms; a != endAtom; a++)
    {
      a->visited = false;
      a->marked = false;
    }
  Improve i(atomsSize);
  for (a = atoms; a != endAtom; a++)
    if (!a->visited)
      i.strong(a);
}
