// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   read.cc
// Author: Patrik Simons
//
#include <iostream.h>

#include "dl.h"

int
Dl::read (istream &f)
{
  timer.start ();

  f >> number_of_atoms;
  f >> number_of_rules;
  f >> size_of_sigma;
  if (!f.good ())
    return 1;
  if (number_of_atoms < 0)
    {
      cerr << "number of atoms is less than zero" << endl;
      return 1;
    }
  if (number_of_rules < 0)
    {
      cerr << "number of rules is less than zero" << endl;
      return 1;
    }
  if (size_of_sigma < 0)
    {
      cerr << "size of sigma is less than zero" << endl;
      return 1;
    }
  if (size_of_sigma < number_of_rules)
    {
      cerr << "size of sigma is smaller than the number of rules" << endl;
      return 1;
    }
  if (size_of_sigma < number_of_atoms)
    {
      cerr << "size of sigma is smaller than the number of atoms" << endl;
      return 1;
    }
  
  Init ();

  // Read rules.
  long i, j, m, n;
  long flast = 0;
  long linenumber = 4;
  long sigma = size_of_sigma;
  long *posbody = new long[number_of_atoms];
  long *negbody = new long[number_of_atoms];
  for (i = 0; i < number_of_atoms; i++)
    {
      posbody[i] = 0;
      negbody[i] = 0;
    }
  for (i = 0; i < number_of_rules; i++, linenumber++)
    {
      // Rule head
      f >> m;
      if (!f.good ())
	return 1;
      sigma--;
      if (sigma < 0)
	{
	  cerr << "too many atoms read, line " << linenumber << endl;
	  return 1;
	}
      if (m < 1 || m > number_of_atoms) 
	{
	  cerr << "head atom out of bounds, line " << linenumber << endl;
	  return 1;
	}
      m--;
      dcl.atoms[m].headof++;
      dcl.rules[i].head = dcl.atoms+m;
      // Negative body
      f >> n;
      if (!f.good () || n < 0)
	return 1;
      sigma -= n;
      if (sigma < 0)
	{
	  cerr << "too many atoms read, line " << linenumber << endl;
	  return 1;
	}
      dcl.rules[i].body = dcl.atom_holder+flast;
      for (j = 0; j < n; j++)
	{
	  f >> m;
	  if (!f.good ())
	    return 1;
	  if (m < 1 || m > number_of_atoms)
	    {
	      cerr << "atom out of bounds, line " << linenumber << endl;
	      return 1;
	    }
	  m--;
	  negbody[m]++;
	  dcl.rules[i].body[j] = dcl.atoms+m;
	}
      dcl.rules[i].firstPos = dcl.rules[i].body+n;
      dcl.rules[i].endBody = dcl.rules[i].firstPos;
      flast += n;
      dcl.rules[i].neg = n;
      // Positive body
      f >> n;
      if (!f.good () || n < 0)
	return 1;
      sigma -= n;
      if (sigma < 0)
	{
	  cerr << "too many atoms read, line " << linenumber << endl;
	  return 1;
	}
      for (j = 0; j < n; j++)
	{
	  f >> m;
	  if (!f.good ())
	    return 1;
	  if (m < 1 || m > number_of_atoms)
	    {
	      cerr << "atom out of bounds, line " << linenumber << endl;
	      return 1;
	    }
	  m--;
	  posbody[m]++;
	  dcl.rules[i].body[dcl.rules[i].neg+j] = dcl.atoms+m;
	}
      flast += n;
      dcl.rules[i].pos = n;
      dcl.rules[i].pos2 = n;
      dcl.rules[i].endBody += n;
    }
  // Set up dcl.atoms
  long alast = 0;
  for (i = 0; i < number_of_atoms; i++)
    {
      dcl.atoms[i].head = dcl.rule_holder + alast;
      alast += dcl.atoms[i].headof;
      dcl.atoms[i].endHead = dcl.rule_holder + alast;
      dcl.atoms[i].pos = dcl.rule_holder + alast;
      alast += posbody[i];
      dcl.atoms[i].endPos = dcl.rule_holder + alast;
      dcl.atoms[i].endPos2 = dcl.rule_holder + alast;
      dcl.atoms[i].neg = dcl.rule_holder + alast;
      alast += negbody[i];
      dcl.atoms[i].endNeg = dcl.rule_holder + alast;
    }
  for (i = 0; i < number_of_rules; i++)
    {
      *dcl.rules[i].head->head = dcl.rules+i;
      dcl.rules[i].head->head++;
      Atom **a;
      for (a = dcl.rules[i].body; a != dcl.rules[i].firstPos; a++)
	{
	  *(*a)->neg = dcl.rules+i;
	  (*a)->neg++;
	}
      for (; a != dcl.rules[i].endBody; a++)
	{
	  *(*a)->pos = dcl.rules+i;
	  (*a)->pos++;
	}
    }
  for (i = 0; i < number_of_atoms; i++)
    {
      dcl.atoms[i].head -= dcl.atoms[i].headof;
      dcl.atoms[i].pos -= posbody[i];
      dcl.atoms[i].neg -= negbody[i];
    }
  delete[] posbody;
  delete[] negbody;
  if (!f.good ())
    return 1;
  
  // Read atom names.
  const int len = 1024;
  char s[len];
  f.getline (s, len);  // Get newline
  if (!f.good ())
    {
      cerr << "expected atom names to begin on new line, line " 
	<< linenumber << endl;
      return 1;
    }
  for (i = 0; i < number_of_atoms; i++, linenumber++)
    {
      f.getline (s, len);
      if (!f.good ())
	{
	  cerr << "atom name too long or end of file, line " 
	    << linenumber << endl;
	  return 1;
	}
      dcl.atoms[i].name = new char[strlen(s)+1];
      strcpy (dcl.atoms[i].name, s);
    }

  // Read compute-statement
  f.getline (s, len);
  if (!f.good () || strcmp (s, "B+"))
    {
      cerr << "B+ expected, line " << linenumber << endl;
      return 1;
    }
  linenumber++;
  long blen;
  f >> blen;
  if (!f.good () || blen < 0 || blen > number_of_atoms)
    {
      cerr << "number " << blen << " after B+ out of bounds, line " 
	<< linenumber << endl;
      return 1;
    }
  linenumber++;
  for (i = 0; i < blen; i++, linenumber++)
    {
      f >> n;
      if (!f.good () || n < 1 || n > number_of_atoms)
	return 1;
      n--;
      dcl.atoms[n].dependsonTrue = true;
    }
  f.getline (s, len);  // Get newline.
  f.getline (s, len);
  if (!f.good () || strcmp (s, "B-"))
    {
      cerr << "B- expected, line " << linenumber << endl;
      return 1;
    }
  linenumber++;
  f >> blen;
  if (!f.good () || blen < 0 || blen > number_of_atoms)
    {
      cerr << "number " << blen << " after B- out of bounds, line " 
	<< linenumber << endl;
      return 1;
    }
  linenumber++;
  for (i = 0; i < blen; i++, linenumber++)
    {
      f >> n;
      if (!f.good () || n < 1 || n > number_of_atoms)
	return 1;
      n--;
      dcl.atoms[n].dependsonFalse = true;
    }
  f >> max_models;  // zero means all
  if (f.fail ()) 
    {
      cerr << "number of models expected, line " << linenumber << endl;
      return 1;
    }
  
  // Init nant.
  nantInit ();
  return 0;
}
