// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   queue.h
// Author: Patrik Simons
//
#ifndef QUEUE_H
#define QUEUE_H

#include <assert.h>
#include "atomrule.h"

class Queue
{
public:
  Queue (long size = 0);
  ~Queue ();
  void Init (long size);

  void reset ();
  void push (Atom *n);
  Atom *pop ();
  int empty ();

  Atom **queue;
  long last;
  long top;
  long bottom;
};

inline int
Queue::empty ()
{
  return top == bottom;
}

inline void 
Queue::reset ()
{
  top = 0;
  bottom = 0;
}

inline void 
Queue::push (Atom *n)
{
  queue[bottom] = n;
  bottom++;
  if (bottom > last)
    bottom = 0;
}

inline Atom *
Queue::pop ()
{
  assert (top != bottom);
  Atom *n = queue[top];
  top++;
  if (top > last)
    top = 0;
  return n;
}

#endif
