// Copyright 1997 Patrik Simons
// This software is provided as is, no warranty of any kind is given.
//
// File:   dcl.h
// Author: Patrik Simons
//
#ifndef DCL_H
#define DCL_H

#include "queue.h"

class Dl;

class Dcl
{
public:
  Dcl (Dl &d);
  ~Dcl ();
  void Init (long numatoms, long numrules, long bodysize);

  void setup ();
  void dcl ();
  int propagateFalse ();
  void setTrue (Atom *a);
  void setBTrue (Atom *a);
  void setBFalse (Atom *a);
  void mightFireRule (Rule *r);
  void inactivate (Rule *f, Atom *a);
  void backtrackFromBFalse (Atom *a);
  void backtrackFromBTrue (Atom *a);
  void backchainTrue (Atom *a);
  void backchainFalse (Atom *a);
  void backchainRuleFalse (Rule *r);
  int path (Atom *a, Atom *b);
  void searchRule (Rule *r);
  void reduceStrongly ();
  void reduceWeakly ();
  void improve ();
  void print ();

  Queue truequeue;
  Queue etruequeue;
  Queue efalsequeue;
  Queue falsequeue;

  Atom *atoms;      // The atoms
  Rule *rules;      // The rules
  Rule *endRule;    // Sentinel
  Atom *endAtom;    // Sentinel
  long atomsSize;   // The size of atoms 
  long rulesSize;   // The size of rules
  Atom **atom_holder;
  Rule **rule_holder;

  Atom **tmpfalse;
  long tmpfalsetop;

  Dl &dl;
};

#include "dl.h"

#endif
