%{
#include "tokens.h"
long linenumber = 1;
%}

ATOM [a-zA-Z_-]([a-zA-Z0-9_-]*)
PARAMETER [a-zA-Z0-9_-]+
POSNUMBER "+"?[0-9]+
NEGNUMBER "-"[0-9]+
DOUBLE ("+"|"-")?[0-9]+("."[0-9]+)?((e|E)("-"|"+")?[0-9]+)?
NEGATION "not"
RULE_ARROW ":-"
DELIMITER ","
RULE_END "."
WHITE [ \t]+
NEWLINE "\n"
COMMENT "%"[^\n]*
LBRACE "{"
RBRACE "}"
LPAREN "("
RPAREN ")"
EQUAL "="
ATMOST "<="
ATLEAST ">="
LESS "<"
GREATER ">"
COMPUTE "compute"
MAXIMIZE "maximize"
MINIMIZE "minimize"
ALL "all"

%s computation

%%

{COMMENT}

{NEWLINE} { linenumber++; }

{WHITE} 

{NEGATION} return NEGATION;

<computation>{ALL} { BEGIN(INITIAL); return ALL; }

<computation>{POSNUMBER} { BEGIN(INITIAL); return POSNUMBER; }

{COMPUTE} { BEGIN(computation); return COMPUTE; }

{MAXIMIZE} return MAXIMIZE;
{MINIMIZE} return MINIMIZE;

{POSNUMBER} return POSNUMBER;
{NEGNUMBER} return NEGNUMBER;

{DOUBLE} return DOUBLE;

{ATOM} return ATOM;

{PARAMETER} return PARAMETER;

{LPAREN} return LPAREN;

{RPAREN} return RPAREN;

{LBRACE} { BEGIN(INITIAL); return LBRACE; }

{RBRACE} return RBRACE;

{RULE_ARROW} return RULE_ARROW;

{RULE_END} return RULE_END;

{DELIMITER} return DELIMITER;

{EQUAL} return EQUAL;
{ATMOST} return ATMOST;
{ATLEAST} return ATLEAST;
{LESS} return LESS;
{GREATER} return GREATER;

<<EOF>> return 0;

%%

int yywrap()
{
  return 1;
}




