// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi
#include <string.h>
#include <float.h>
#include "atomrule.h"

Atom::Atom (const char *s)
{
  if (s)
    name = strdup (s);
  else
    name = 0;
  weight = 0;
  positive_weight = true;
  id = 0;
}

Atom::~Atom ()
{
  delete[] name;
}

Array::Array()
{
  top = 0;
  end = 32;
  array = new Element[end];
}

void
Array::push (Atom *a)
{
  if (top >= end)
    grow ();
  array[top].atom = a;
  array[top].hasWeight = false;
  top++;
}

void
Array::push (Atom *a, Weight w, bool has_weight)
{
  if (top >= end)
    grow ();
  array[top].atom = a;
  array[top].weight = w;
  array[top].hasWeight = has_weight;
  top++;
}

void
Array::grow ()
{
  Element *e = new Element[end*2];
  for (int i = 0; i < end; i++)
    e[i] = array[i];
  delete[] array;
  end *= 2;
  array = e;
}

long
List::size ()
{
  long l = 0;
  for (Node *n = begin (); n; n = n->next)
    l++;
  return l;
}

Rule::Rule ()
{
  chooseHead = 0;
  chooseBody = 0;
  atmost = 0;
  atleast = 0;
  offset = 0;
  type = ENDRULE;
}

Rule::~Rule ()
{
}

Rule &
Rule::operator= (const Rule &r)
{
  clear ();
  type = r.type;
  chooseHead = r.chooseHead;
  chooseBody = r.chooseBody;
  atleast = r.atleast;
  atmost = r.atmost;
  for (int i = 0; i < r.head.top; i++)
    head.push (r.head.array[i].atom,
	       r.head.array[i].weight,
	       r.head.array[i].hasWeight);
  for (int i = 0; i < r.pbody.top; i++)
    pbody.push (r.pbody.array[i].atom,
		r.pbody.array[i].weight,
		r.pbody.array[i].hasWeight);
  for (int i = 0; i < r.nbody.top; i++)
    nbody.push (r.nbody.array[i].atom,
		r.nbody.array[i].weight,
		r.nbody.array[i].hasWeight);

  return *this;
}

void
Rule::clear ()
{
  chooseHead = 0;
  chooseBody = 0;
  type = ENDRULE;
  head.clear ();
  pbody.clear ();
  nbody.clear ();
}

void
Rule::swap_pos_neg ()
{
  Element *tarray = pbody.array;
  int ttop = pbody.top;
  int tend = pbody.end;
  pbody.array = nbody.array;
  pbody.top = nbody.top;
  pbody.end = nbody.end;
  nbody.array = tarray;
  nbody.top = ttop;
  nbody.end = tend;
}

void
Rule::print (ostream &o)
{
  if (type == NORULE)
    return;
  if (type == CONSTRAINTRULE)
    if (chooseBody > pbody.size () + nbody.size ())
      return;
  o << type;
  if (type == GENERATERULE)
    o << ' ' << head.size () << ' ' << chooseHead;
  if (type == CHOICERULE)
    o << ' ' << head.size ();
  if (type == OPTIMIZERULE)
    o << ' ' << 0;
  else
    for (int i = 0; i < head.top; i++)
      o << ' ' << head.array[i].atom->id;
  if (type == WEIGHTRULE)
    o << ' ' << atleast;
  long b = nbody.size ();
  long nb = b;
  b += pbody.size ();
  o << ' ' << b;
  if (type != GENERATERULE)
    o << ' ' << nb;
  if (type == CONSTRAINTRULE)
    o << ' ' << chooseBody;
  for (int i = 0; i < nbody.top; i++)
    o << ' ' << nbody.array[i].atom->id;
  for (int i = 0; i < pbody.top; i++)
    o << ' ' << pbody.array[i].atom->id;
  if (type == WEIGHTRULE || type == OPTIMIZERULE)
    {
#     ifdef USEDOUBLE
      o.precision (DBL_DIG);
#     endif
      for (int i = 0; i < nbody.top; i++)
	if (nbody.array[i].hasWeight)
	  o << ' ' << nbody.array[i].weight;
	else
	  o << ' ' << nbody.array[i].atom->weight;
      for (int i = 0; i < pbody.top; i++)
	if (pbody.array[i].hasWeight)
	  o << ' ' << pbody.array[i].weight;
	else
	  o << ' ' << pbody.array[i].atom->weight;
    }
  o << endl;
}
