// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi
#ifndef TREE_H
#define TREE_H

#include <stddef.h>
#include "atomrule.h"

const int black = 0;
const int red = 0;

class Tree;

class TreeNode
{
  friend class Tree;
public:
  TreeNode (Atom *a)
    { atom = a; left = 0; right = 0; parent = 0; color = black; };

  ~TreeNode () { delete atom; };

  Atom *atom;

private:
  int color;
  TreeNode *left;
  TreeNode *right;
  TreeNode *parent;
};

// Red-black tree.
class Tree
{
public:
  Tree ();
  ~Tree ();

  Atom *find (const char *key) const;
  Atom *insert (Atom *);
  long Size () { return size; };

protected:
  void flush (TreeNode *n);
  void slope (TreeNode *p, TreeNode *&pc, TreeNode *&ppc);
  void zigzag (TreeNode *c, TreeNode *p, TreeNode *&pc, TreeNode
	       *&cpc, TreeNode *&ppc, TreeNode *&);

  long size;
  TreeNode *root;
};
#endif
