// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi
#ifndef PARSER_H
#define PARSER_H

#include "atomrule.h"
#include "tree.h"

class Parser
{
public:
  Parser (ostream &);
  ~Parser ();

  int program ();
  int statement ();
  int choice ();
  int generate ();
  int rule (Atom *);
  int constraint (Rule *);
  int weight (Rule *);
  int braced (Rule *);
  int body (Rule *);
  int braced (Array *, bool pos);
  int array (Array *, bool pos);
  Atom *atom ();
  int getatom (bool parameter = false);
  Atom *newAtom (const char *);
  Atom *getFail ();
  
  int gettoken ();
  unsigned long getnumber ();
  bool isWeight (int);
  bool isParameter (int);
  void getWeight (Atom *);
  Weight getWeight ();
  int compute ();
  int optimize (bool);
  void print_line ();
  void error (char *);
  void print ();
  void remove_negative_weights (Rule *);
  void change_atmost_to_atleast (Rule *);
  void split_weight_rule (Rule *);

  bool havetoken;
  int token;

  char atomname[1024];
  Tree tree;
  Rule computeRule;
  Rule r;
  Rule tmp;
  unsigned long maxmodels;
  List atoms;
  long lastid;
  Atom *fail;
  ostream &out;
};

const int Error = 0;
const int Ok = 1;

#endif
