// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi
#ifndef ATOMRULE_H
#define ATOMRULE_H

#include <iostream.h>

#include "defines.h"

class Atom
{
public:
  Atom (const char *s = 0);
  ~Atom ();

  char *name;
  Weight weight;
  long id;
};

class Element
{
public:
  Element (Atom *a = 0) { atom = a; weight = 0; hasWeight = false; };
  Element (Atom *a, Weight w) { atom = a; weight = w; hasWeight = true; };
  ~Element () {};

  Atom *atom;
  Weight weight;
  bool hasWeight;
};

class Array
{
public:
  Array();
  ~Array () { delete[] array; };

  void push (Atom *);
  void push (Atom *, Weight, bool has_weight = true);
  int size () { return top; };
  void clear () { top = 0; };
  void grow ();

  Element *array;
  int top;
  int end;
};

class Node
{
public:
  Node (Atom *a = 0) { next = 0; atom = a; weight = 0;
                       hasWeight = false; };
  Node (Atom *a, Weight w) { next = 0; atom = a; weight = w;
                             hasWeight = true; };
  ~Node () { delete next; };

  Node *next;
  Atom *atom;
  Weight weight;
  bool hasWeight;
};

class List
{
public:
  List () { tail = &head; };
  ~List () {};

  void push (Atom *);
  void push (Atom *, Weight);
  Node *begin () { return head.next; };
  long size ();

protected:
  Node head;
  Node *tail;
};

inline void
List::push (Atom *a)
{
  Node *n = new Node (a);
  tail->next = n;
  tail = n;
}

inline void
List::push (Atom *a, Weight w)
{
  Node *n = new Node (a, w);
  tail->next = n;
  tail = n;
}

class Rule
{
public:
  Rule ();
  ~Rule ();
  Rule &operator= (const Rule &);

  void print (ostream &);
  void clear ();

  Array head;
  Array nbody;
  Array pbody;
  long chooseHead;
  long chooseBody;  // or maximize
  Weight atmost;
  Weight atleast;
  int type;
};

#endif
