// Copyright 1998 by Patrik Simons
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston,
// MA 02111-1307, USA.
//
// Patrik.Simons@hut.fi
#include <string.h>
#include <float.h>
#include "atomrule.h"

Atom::Atom (const char *s)
{
  if (s)
    name = strdup (s);
  else
    name = 0;
  weight = 0;
  id = 0;
}

Atom::~Atom ()
{
  delete[] name;
}

Array::Array()
{
  top = 0;
  end = 32;
  array = new Element[end];
}

void
Array::push (Atom *a)
{
  if (top >= end)
    grow ();
  array[top].atom = a;
  array[top].hasWeight = false;
  top++;
}

void
Array::push (Atom *a, Weight w)
{
  if (top >= end)
    grow ();
  array[top].atom = a;
  array[top].weight = w;
  array[top].hasWeight = true;
  top++;
}

void
Array::grow ()
{
  Element *e = new Element[end*2];
  for (int i = 0; i < end; i++)
    e[i] = array[i];
  delete[] array;
  end *= 2;
  array = e;
}

long
List::size ()
{
  long l = 0;
  for (Node *n = begin (); n; n = n->next)
    l++;
  return l;
}

Rule::Rule ()
{
  chooseHead = 0;
  choosePos = 0;
  chooseNeg = 0;
  type = ENDRULE;
}

Rule::~Rule ()
{
}

void
Rule::clear ()
{
  chooseHead = 0;
  choosePos = 0;
  chooseNeg = 0;
  type = ENDRULE;
  head.clear ();
  pbody.clear ();
  nbody.clear ();
}

void
Rule::print (ostream &o)
{
  if (type == CONSTRAINTRULE)
    if (choosePos > pbody.size () || chooseNeg > nbody.size ())
      return;
  o << type;
  if (type == GENERATERULE)
    o << ' ' << head.size () << ' ' << chooseHead;
  if (type == CHOICERULE)
    o << ' ' << head.size ();
  if (type == OPTIMIZERULE)
    o << ' ' << choosePos;
  else
    for (int i = 0; i < head.top; i++)
      o << ' ' << head.array[i].atom->id;
  if (type == WEIGHTRULE)
    o << ' ' << atleast << ' ' << atmost;
  long b = nbody.size ();
  long nb = b;
  b += pbody.size ();
  o << ' ' << b;
  if (type != GENERATERULE)
    o << ' ' << nb;
  if (type == CONSTRAINTRULE)
    o << ' ' << chooseNeg;
  for (int i = 0; i < nbody.top; i++)
    o << ' ' << nbody.array[i].atom->id;
  if (type == CONSTRAINTRULE)
    o << ' ' << choosePos;
  for (int i = 0; i < pbody.top; i++)
    o << ' ' << pbody.array[i].atom->id;
  if (type == WEIGHTRULE || type == OPTIMIZERULE)
    {
#     ifdef USEDOUBLE
      o.precision (DBL_DIG);
#     endif
      for (int i = 0; i < nbody.top; i++)
	if (nbody.array[i].hasWeight)
	  o << ' ' << nbody.array[i].weight;
	else
	  o << ' ' << nbody.array[i].atom->weight;
      for (int i = 0; i < pbody.top; i++)
	if (pbody.array[i].hasWeight)
	  o << ' ' << pbody.array[i].weight;
	else
	  o << ' ' << pbody.array[i].atom->weight;
    }
  o << endl;
}
