/*
** lex.l -- lexer for lparse
**
** Copyright (C) 1999 Tommi Syrjnen <Tommi.Syrjanen@hut.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

%{
#include "../config.h"
#include "parsetree.h"
#include "symbol.h"
#include "parse.h"
#include <string.h>

extern int lineno;
extern int return_symbol;
extern int return_funcsymbol;

int par_depth = 0;
int inside_definition = 0;

%}


%s PAREN
%s DEFINITION
%option noyywrap

IF		:-
NOT		[Nn][Oo][Tt]
WEIGHT		[Ww][Ee][Ii][Gg][Hh][Tt]
COMPUTE		[Cc][Oo][Mm][Pp][Uu][Tt][Ee]
MINIMIZE	[Mm][Ii][Nn][Ii][Mm][Ii][Zz][Ee]
MAXIMIZE	[Mm][Aa][Xx][Ii][Mm][Ii][Zz][Ee]
FUNCTION	[Ff][Uu][Nn][Cc][Tt][Ii][Oo][Nn]
CONST		[Cc][Oo][Nn][Ss][Tt]
FUNCSYMBOL	[a-z_][a-zA-Z0-9_]*
IDENTIFIER	[a-z_][a-zA-Z0-9_']*
VARIABLE	[A-Z][a-zA-Z0-9_]*
STRING		\"[^\"\n]*\"
NUMBER		[0-9][0-9]*
COMMENT		%.*\n
COMMENT2	%.*
WS		[\t\r ]*
NL		\n
/* operators */
EQ		== 
NEQ		!= 
LT		<
GT		>
LE		<=
GE		>=
ASSIGN		=
DOTS		\.\.
COMMAS		,,
MOD		[Mm][Oo][Dd]
HIDE		[Hh][Ii][Dd][Ee]

%%
{NL}		{ lineno++; }
{COMMENT}	{ /* do nothing */ lineno++;}
{WS}		{ /* do nothing */ }
{IF}		{ return IF; }
{COMPUTE}	{ return COMPUTE; }
{MINIMIZE}	{ return MINIMIZE; }
{MAXIMIZE}	{ return MAXIMIZE; }
{NOT}		{ return NOT; }
{FUNCTION}	{ inside_definition = 1; return FUNCTION; }
{STRING}	{ yylval.s = strdup(yytext+1);
                  yylval.s[strlen(yylval.s)-1] = '\0'; return STRING; }
{MOD}		{ return MOD; }
{CONST}		{ inside_definition = 1; return CONST; }
{HIDE}		{ return HIDE; }
{WEIGHT}		{ return WEIGHT;}
{FUNCSYMBOL}    { if (function_table->Lookup(yytext) >= 0) { 
			yylval.s = strdup(yytext);
			return FUNCSYMBOL;
		  } else REJECT; }
{IDENTIFIER}	{ yylval.s = strdup(yytext); return IDENTIFIER; }
{VARIABLE}	{ yylval.s = strdup(yytext);
				    return VARIABLE;} 
{NUMBER}	{ yylval.l = strtol(yytext,NULL,10);
		  return NUMBER;} 
{EQ}		{ return EQ; }
{NEQ}		{ return NEQ; }
{LT}		{ return LT; }
{GT}		{ return GT; }
{GE}		{ return GE; }
{LE}		{ return LE; }
{ASSIGN}	{ return ASSIGN; }
{DOTS}		{ return DOTS; }
{COMMAS}	{ return COMMAS; } 
{COMMENT}	{ return 0; }
{COMMENT2}	{ return 0; }
[(]		{ par_depth++; return '('; }
[)]		{ par_depth--; return ')';  }
. 		{ return *yytext; }
