/*
   parse.h -- definitions for parse tree structure for lparse

   Classes defined:
   	ParseNode -- parse tree node

   Enumerations defined:
   	ParseType -- types for different nodes
   
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: parse.h,v 1.1 1998/08/04 09:18:26 tssyrjan Exp $	 
*/

#ifndef PARSE_H
#define PARSE_H

#include "debug.h"
#include "global.h"
#include "term.h"
#include "literal.h"

enum ParseType { PT_PROGRAM, PT_DECLARATIONS, PT_DECLARATION,
		 PT_RULES, PT_RULE, PT_HEAD, PT_TAIL, PT_LITERAL,
		 PT_ATOM, PT_FUNCTION, PT_ARGLIST, PT_TERM,
		 PT_COMPUTE_STMT, PT_MODELS, PT_CLIST,
		 PT_LITERAL_LIST, PT_RANGE, PT_NEG_ATOM, PT_CONSTANT,
		 PT_EXPR, PT_VARIABLE, PT_NUMBER, PT_NOT_ATOM,
		 PT_DEFLIST, PT_UNKNOWN };   

/* ParseNode is a base class for all different node types.
   Attributes:
   	ParseType type	-- type of the node
	char *val	-- tokenval of the node, if any
	long lineno	-- line number of the token
	
   Methods:
   	int ProcessTree() -- virtual function that does the needed
			     processing. Return values are used for
			     varying purposes.
   
   ParseNode is used for all those node types that don't need any
   special processing.
   */
class ParseNode
{
public:
  ParseType type;
  char *sval;
  long lval, start, end;
  struct ParseNode *left, *right;
  union  {
    Function *fun;
    Literal *lit;
  } ext;
  long lineno;
#ifdef DEBUG
  void Print(int ind = 0);
#endif
  ParseNode(ParseType, char *, ParseNode *, ParseNode *, long );
  ParseNode(ParseType, char *, ParseNode *, ParseNode *, long, long );
  ParseNode(ParseType, char *, ParseNode *, ParseNode *, long, long, long );
  ParseNode();
  ~ParseNode() { delete sval; delete left; delete right; };
  int ProcessTree();

  // These are used to make ProcessTree little smaller.
  int ProcessTerm(int, int);
  int ProcessFunction(int, int);
  int ProcessCompute(int, int);
  int ProcessRule(int, int);
  int ProcessAtom(int, int);
};



#endif
