/* literal.h -- declarations for literals
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: literal.h,v 1.1 1998/08/04 09:18:29 tssyrjan Exp $	 
*/

#ifndef LITERAL_H
#define LITERAL_H

#include "term.h"
#include "list.h"
#include "instance.h"

class Literal
{
public:
  int ground : 1; 	// true if ground literal
  int negative : 1;	// true if negative literal
  int arity : TERM_ARITY_BITS;	// arity of the literal
  int numvars : TERM_ARITY_BITS;	// how many variables literal has
  int has_range : 1; // true if one of arguments is a range
  int has_function : 1; // ditto for functions
  long pred; 	// predicate symbol of the literal

  TermType *args;	// array of types of arguments
  // arrays for each possible argument type. vars, cons have index to
  // symbol table or -1, nums have the numbers or -1 and terms has
  // pointers to corresponding terms or NULL
  long *vars;
  Instance *cons;
  Term **terms;

  // returns pointer to statically allocated buffer which contains the
  // text representation of the literal. The buffer will be clobbered
  // by subsequent calls.
  char *GetPrintString();

  Literal(ParseNode *, long, int);
  Literal();
  Literal(Variable, long);
  Literal(Variable *, long, int);

  int GetPos();
  void CreateInstance();
  Instance EmitGround(); // return the atom value of emitted thingy
  Instance EmitComplement();
  void Restrict(int);
  int Test();
  void Print();
};

struct ComputeStmt
{
  long models;
  LongList neg, pos;
};

#endif
