/*
  lex.l -- lexer for lparse

  This program has no warranties of any kind. Use at own risk.
  
  Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)
  
  $Id: lex.l,v 1.1 1998/08/04 09:19:45 tssyrjan Exp $	 
  */

%{
#include "parse.h"
#include "symbol.h"
#include "parse.tab.cc.h"
#include <string.h>

extern int lineno;
extern int return_symbol;
extern int return_funcsymbol;
%}

%option noyywrap

IF		:-
NOT		[Nn][Oo][Tt]
COMPUTE		[Cc][Oo][Mm][Pp][Uu][Tt][Ee]
FUNCTION	[Ff][Uu][Nn][Cc][Tt][Ii][Oo][Nn]
DEFINE		[Dd][Ee][Ff][Ii][Nn][Ee]
FUNCSYMBOL	[a-z_][-a-zA-Z0-9_]*
IDENTIFIER	[a-z_][-a-zA-Z0-9_]*
VARIABLE	[A-Z][-a-zA-Z0-9_]*
NUMBER		[0-9][0-9]*
COMMENT		%.*\n
WS		[\t\r ]*
NL		\n
/* operators */
EQ		== 
NEQ		!= 
LT		<
GT		>
LE		<=
GE		>=
ASSIGN		=
DOTS		\.\.
MOD		[Mm][Oo][Dd]
SYMBOL		({EQ}|{NEQ}|{LT}|{GT}|{LE}|{GE}|[-+*/%]|{IDENTIFIER})

%%
{NL}		{ lineno++; }
{COMMENT}	{ /* do nothing */ lineno++;}
{WS}		{ /* do nothing */ }
{IF}		{ return IF; }
{COMPUTE}	{ return COMPUTE; }
{NOT}		{ return NOT; }
{FUNCTION}	{ return FUNCTION; }
{DEFINE}	{ return DEFINE; }
{MOD}		{ return MOD; }
{SYMBOL}	{ if (return_symbol) {
			yylval.s = strdup(yytext);
			return SYMBOL;
		  } else REJECT; }
{FUNCSYMBOL}	{ if (return_funcsymbol &&
		      function_table->Lookup(yytext) >= 0) { 
			yylval.s = strdup(yytext);
			return FUNCSYMBOL;
		  } else REJECT; }
{IDENTIFIER}	{ yylval.s = strdup(yytext);  return IDENTIFIER; }
{VARIABLE}	{ yylval.s = strdup(yytext); return VARIABLE;}
{NUMBER}	{ yylval.l = MAKE_NUMBER(strtol(yytext,NULL,10));
		  return NUMBER;} 
{EQ}		{ return EQ; }
{NEQ}		{ return NEQ; }
{LT}		{ return LT; }
{GT}		{ return GT; }
{GE}		{ return GE; }
{LE}		{ return LE; }
{ASSIGN}	{ return ASSIGN; }
{DOTS}		{ return DOTS; }
. 		{ return *yytext; }
