/* iterate.cc -- implementation of iterator classes

   This program has no warranties of any kind. Use at own risk.
   
   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)
   
   $Id: iterate.cc,v 1.1 1998/08/04 09:19:32 tssyrjan Exp $	 
*/

#include "global.h"
#include "iterate.h"


HashSetIterator::HashSetIterator(HashSet *hs)
  : current(0), returned(0), set(hs)
{
}

HashSetIterator::~HashSetIterator()
{
}

void HashSetIterator::Reset(HashSet *hs)
{
  current = 0;
  returned = 0;
  set = hs;
}

void HashSetIterator::Clear()
{
  current = 0;
  returned = 0;
}
    

Instance *HashSetIterator::Iterate(Instance )
{
  if (current == primes[set->max_size]) {
    current = 0;
    returned = 0;
    return NULL;
  }
  if (returned == set->size) {
    returned = current = 0;
    return NULL;
  }
  
  while (current < primes[set->max_size] && !set->valid[current])
    current++;

  if (current == primes[set->max_size]) {
    current = 0;
    returned = 0;
    return NULL;
  }
  returned++;
  return set->items[current++];
} 


RBTreeIterator::RBTreeIterator(RBTree *tr)
{
  tree = tr;
  current = tr->head;
}

RBTreeIterator::~RBTreeIterator()
{
}

void RBTreeIterator::Reset(RBTree *tr)
{
  tree = tr;
  current = tr->head;
}

void RBTreeIterator::Clear()
{
  current = tree->head;
}
  
Instance *RBTreeIterator::Iterate(Instance value)
{
  TreeNode *tmp = NULL;
  
  if (current == tree->z) {	
    current = tree->head->right;
    return NULL;
  }

  while (current != tree->z) {
    if (value < current->item[tree->index])
      current = current->left;
    else if (value > current->item[tree->index])
      current = current->right;
    else {
      tmp = current;
      current = current->next;	
      return tmp->item;
    }
  }
  current = tree->head->right;
  return NULL;
}

