/* graph.h -- definition of dependency graph for lparse
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: graph.h,v 1.1 1998/08/04 09:18:45 tssyrjan Exp $	 
*/

#ifndef GRAPH_H
#define GRAPH_H

#include "global.h"
#include "array.h"

// GraphNode implements nodes of the graph. Attributes are:
//     	- long size - how many children the node has
//	- long index - which node this is, no need actually, but can
//		       help debugging.
//	- ResizableArray *children  - array where children are kept
class GraphNode {
public:
  GraphNode(); 
  ~GraphNode() { delete children; }

  void AddChild(long chld);
  long size;
  long index;
  ResizableArray *children;
};


/* Graph implements the actual graph.
   Attributes:
   	GraphNodeArray *nodes	-- array of nodes
	long *visited		-- array used in cycle checking for
				   keeping information about visited
				   nodes. 
	DomainType *domain	-- array used in cycle checking for
	                           keeping information about domain
				   types of predicates.
        long size		-- size of the graph

   Methods:
   	void AddNode(long nd)	-- adds node 'nd' to graph. Does
        			   nothing if node is in graph
				   already. 
	void AddEdge(long a, long b) -- adds an edge (a,b) to the
				   graph. Doesn't remove duplicates. 
	
	void CheckCycles()	-- finds cycles in graph. Doesn't
			 	   return anything because Visit
				   updates all needed structures.
	int Visit(long nd)	-- Checks if there are any cycles in
				   paths starting from node 'nd' and
				   calculates domain of those
				   predicates that don't have
				   cycles. Also updates the predicates
				   array to correct domain status. 
	*/
class Graph {
public:
  Graph();
  ~Graph();

  void AddNode(long);
  void AddEdge(long, long);
  void CheckCycles();
  void PrintDomains();
private:
  int Visit(long node);

  GraphNodeArray *nodes;
  long *visited;
  DomainType *domain;
  long size;
};
#endif
