/* global.h -- global definitions
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: defines.h,v 1.1 1998/08/04 09:18:52 tssyrjan Exp $	 
*/

#ifndef DEFINE_H
#define DEFINE_H

// Configurable parameters

// System
#define UNIX

//initial size of symbol tables
#define SYMBOL_DEFAULT_SIZE	50


// Domain sizes
#define DOMAIN_DEFAULT_SIZE	100
#define DOMAIN_MIN_SIZE		20
#define DOMAIN_MAX_SIZE		9000000

// Maximum arity of functions and predicates. You also have to change
// the function call routines in term.cc. Grep for
// *** TERM_MAX_ARITY *** to find places. 
#define TERM_MAX_ARITY		6
#define TERM_ARITY_BITS		3

#define SYMBOL_MAX_LENGTH	( (BUFSIZ / 7) - 8 )


// Maximum number of ranges
#define RANGE_MAX_NUMBER	INT_MAX
// the length of string to hold the names of the ranges
#define RANGE_MAX_NAME		14


#define MAX_PROBE		50 // for debugging hash tables


// Unconfigurable constants. These shouldn't be modified without
// checking results beforehand
#define NUM_PRIMES		23
#define BASE_DEFAULT		809 // for HashSets
#define MAX_NUMBER		(1 << 30)

// System definitions. Don't mess with these unless you know what you
// are doing. 
typedef long Instance;
typedef long Variable;

// Since there are two types of instances, constants and numbers, the
// numbers all have the 30th bit set as 1. (Yes, this effectively
// restricts the range of possible numbers to 0- (2^30-1). However, I 
// don't think this limit is reached in practise very often...
#define NUMBER_BIT	(1 << 30)
#define IS_NUMBER(x)	( (x) & NUMBER_BIT )
#define IS_CONSTANT(x)	( !( (x) & NUMBER_BIT ))
#define MAKE_NUMBER(x)	( (x) | NUMBER_BIT )
#define GET_VALUE(x)	( (x) ^ NUMBER_BIT )
#define max(x, y) ( ( (x) < (y)) ? (y) : (x))
typedef Instance iFunc(int, ...);
typedef iFunc *InstFunc;

#define FALSE_NAME	"&false"

// possible exit values
#define E_OK	0
#define E_RANGE	1
#define E_ERROR	2

enum PrintDomain { PR_ALL, PR_HEADS, PR_NONE, PR_POSITIVE };
enum RestrictType { RT_NONE, RT_WEAK, RT_STRONG };
enum DomainType { DM_UNKNOWN, DM_FALSE, DM_TRUE, DM_DOMAIN, DM_INTERNAL };

#define R_NONE		-1
#define R_NEGATIVE	0
#define R_POSITIVE	1
#define R_DOMAIN	2

#include <stdio.h>

// system data structure
struct SysData
{
  FILE *output_file; 
  int emit_text; //is output plain text
  int abort_when_warn; // treat warnings as errors
  int warnings; // mask for warnings
  int num_errors; // how many errors are found
  int internal_functions; // are internal functions enabled
  PrintDomain print_domains; // which domains are printed
  long domain_size;
  long max_number; // biggest integer used in the program
  long ground_atoms; // how many different grounded atoms
  long ground_rules; // how many grounded rules
  long ground_sigma; // how many grounded atoms in total
  int num_ranges; // how many ranges are defined
  int num_functions; // how many functions are called
  int has_negs;
};
  

#endif
