/* debug.h -- debugging and error macros
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: debug.h,v 1.1 1998/08/04 09:18:54 tssyrjan Exp $	 
*/

#ifndef DEBUG_H
#define DEBUG_H

#include "global.h"

#define DBG_PARSE	(1 << 0)
#define DBG_SYMBOL	(1 << 1)
#define DBG_PARSETREE	(1 << 2)
#define DBG_MAIN	(1 << 3)
#define DBG_INSTANCE	(1 << 4)
#define DBG_TERM	(1 << 5)
#define DBG_GRAPH	(1 << 6)
#define DBG_LIST	(1 << 7)
#define DBG_GROUND	(1 << 8)
#define DBG_RESTRICT	(1 << 9)
#define DBG_NONE	(1 << 31)
#define DBG_ALL		~DBG_NONE

// Set DEBUG to bitwise or of wanted parts. And use parenthesis!!
#define DEBUG		DBG_NONE
//(DBG_SYMBOL | DBG_PARSETREE)

/* debug levels:
   1 -> most important notes (creating, destroying)
   2 -> 1st. level function calls
   3 -> 2nd. level function calls
   4 -> information internal to function
   5 -> minor and annoying data
   */
#define DEBUG_LEVEL 	5

// ERR_USR - error in user input, INT_ERR - internal error, bug in
// code, ERR_SYS - system error
#define USR_ERR		0
#define FATAL_ERR	1
#define SYS_ERR		2


// Warning levels
#define WARN_ALL	~0
#define WARN_ARG	(1 << 0) // check that function arguments are
				 // numeric
#define WARN_SIZE	(1 << 1) // issue warning with invalid domain
				 // size arguments
#define WARN_DECL	(1 << 2) // issue warnings with problems with
				 // function declarations

void error(int sc, char *, ...);
void debug(int type, int level,char *,  ... );
void warn(int cause, char *, ...);

// allows only one argument. There IS NOT and shouldn't be a comma
// before 'fmt'. 
#define int_error( fmt, a ) do { \
  error(FATAL_ERR, "Internal error at %s:%d: " fmt, __FILE__, \
	__LINE__, a); \
} while (0)


#ifdef DEBUG 
#define assert(x)   \
if (! (x)) {   \
  fprintf(stderr, "Assertion failed in %s at line %d.\n",\
	  __FILE__, __LINE__);\
  abort();\
}
#else
#define assert(x)
#endif

#endif
