/* term.h -- declarations for terms (Actually, only range and function
   	     terms since variables and constants are handled directly
	     as integers for efficiency reasons)



   Classes defined:
   	Term		-- base class for range and function
			   terms. Also used with function arguments
	Function	-- Call tree for functions
	Range		-- For ranges
	
   Enumerations:
	InternalFunction -- Lists all internal function types
	TermType	-- Lists possible terms
   
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: term.h,v 1.1 1998/08/04 09:18:15 tssyrjan Exp $	 
*/

#ifndef TERM_H
#define TERM_H

#include "global.h"

enum InternalFunction { FUN_ABS, FUN_EQ, FUN_LE, FUN_GE, FUN_LT,
			FUN_GT, FUN_NEQ, FUN_PLUS, FUN_MINUS,
			FUN_TIMES, FUN_DIV, FUN_MOD, FUN_ASSIGN,
			NUM_MAX_FUN};

enum TermType { T_FUNCTION, T_RANGE, T_VARIABLE, T_CONSTANT,
		T_UNKNOWN };

// finds the internal function name corresponding to an operator.
// eg. "+" -> "plus"
char *get_function_name(char *);

class ParseNode;

class Term
{
public:
  Term(TermType, long, long);
  Term() {type = T_UNKNOWN, val = -1; }
  static Term *ConstructArgument(ParseNode *);  

  long val;
  TermType type;
  int ground : 1;
  int has_range : 1;
  int has_function : 1;
  long lineno;
};


class Function : public Term
{
public:
  Function(InstFunc, char *, long);
  ~Function();
  int AddArgument(Term *);
  Instance Call();

  // returns the maximum of variable positions in function
  int GetPos();
  Instance Test(int);
  void AddVars(int);
  void Restrict(int);
  void Print();
  char *name;
  InstFunc fun;
  Term **args;
  int arity : TERM_ARITY_BITS;
  int assign :1;
  int accept_constants:1;
  int negative:1;
};

class Range : public Term
{
public:
  Range(long, long, long);
  long start;
  long end;
  long current;
};

#endif
