/* rule.h -- declarations for rules
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: rule.h,v 1.1 1998/08/04 09:18:20 tssyrjan Exp $	 
*/

#ifndef RULE_H
#define RULE_H

#include "global.h"
#include "list.h"
#include "literal.h"
#include "term.h"

class Rule
{
public:
  Rule(Literal *);
  
  void AddLiteral(Literal *lt, int neg);
  void AddFunction(Function *);

  // Writes the ranges and function calls  out by adding variables and
  // literals
  void SimplifyLiteral(Literal *lt);
  void RestrictFunction(Function *tm);
  void clear_pos(int pos);
  void GroundRule(int);
  int BindLiteral(Literal *, Instance *, int);
  void EmitGround(int, int);
  void PrintRule();
  RestrictType CheckRestrict();

  Literal *head;
  LiteralList positive, negative;
  FunctionList functions;
  RestrictType status;
  long line_start, line_end;
};


#endif
