/* predicate.h -- declarations for predicate data type 
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: predicate.h,v 1.1 1998/08/04 09:18:22 tssyrjan Exp $	 
*/

#ifndef PREDICATE_H
#define PREDICATE_H

#include "global.h"
#include "list.h"
#include "literal.h"
#include "rule.h"
#include "instance.h"
#include "graph.h"

class Predicate
{
public:
  Predicate();
  ~Predicate();

  void AddRule(Rule *);
  void AddInstance(Instance *inst);
  void CreateIndex(int index);
  void Emit();
  void PrintRules();
  
  int Arity() { return arity; }
  void SetArity(int ar);
  void SetPred(long p) { pred = p; }
  long Pred() { return pred; }
  char *Name() { return name; }
  void SetName(char *nm) { name = nm; }
  DomainType Status() { return status; }
  void SetStatus(DomainType r) { status = r; }
  long Size() { return atoms->Size(); }
  void CalculateDomain();

  
  RestrictType CheckRestrict();
  static RestrictType CheckAllRestricts();
  static void EmitAll();
  static void MakeComplement(long, char *, int);
  Index **indices;
  InstanceSet *atoms;
  InstanceSet *emitted;
  unsigned long existing_indexes;
  long complement;
  int arity : TERM_ARITY_BITS;
private:
  RuleList rules;

  InstanceIterator *it;
  char *name;
  long pred;

  DomainType status;
};
#endif
