/*
  library.cc -- internally defined functions.

  This file is combined magically with user library function
  definitions by a perl script to produce library functions. You
  shouldn't modify this without knowing what to do.

  All internal functions treat Instances as integers. 
  
  This program has no warranties of any kind. Use at own risk.
  
  Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)
  
  $Id: library.cc,v 1.1 1998/08/04 09:19:21 tssyrjan Exp $	 
*/

#include "symbol.h"
#include <stdarg.h>

// created automatically by register. Formatting is important
char *external_files[] = {
	NULL
};

// the format of the declarations is :
//   long foo(int nargs, ...); /* bar.cc */
/* *** INTERNAL LIBRARY FUNCTION DECLARATIONS  *** */
long int_plus(int nargs, ... );
long int_eq(int nargs, ...);
long int_assign(int nargs, ...);
long int_minus(int nargs, ...);
long int_abs(int nargs, ...);
long int_le(int nargs, ...);
long int_ge(int nargs, ...);
long int_gt(int nargs, ...);
long int_lt(int nargs, ...);
long int_neq(int nargs, ...);
long int_times(int nargs, ...);
long int_div(int nargs, ...);
long int_mod(int nargs, ...);
/* *** EXTERNAL LIBRARY FUNCTION DECLARATIONS START HERE *** */
/* *** EXTERNAL LIBRARY FUNCTION DECLARATIONS END HERE *** */


int register_functions()
{
  int i = sys_data.internal_functions;
  // Internal functions should be automatically be valid
  function_table->Register("plus", int_plus, i);
  function_table->Register("eq", int_eq, i);
  function_table->Register("assign", int_assign, i);
  function_table->Register("minus", int_minus, i);
  function_table->Register("abs", int_abs, i);
  function_table->Register("le", int_le, i);
  function_table->Register("lt", int_lt, i);
  function_table->Register("ge", int_ge, i);
  function_table->Register("gt", int_gt, i);
  function_table->Register("neq", int_neq, i);
  function_table->Register("times", int_times, i);
  function_table->Register("div", int_div, i);
  function_table->Register("mod", int_mod, i);
  /* EXTERNAL REGISTERATIONS START HERE */
  /* EXTERNAL REGISTERATIONS END HERE */
  return 1;
}


/* *** INTERNAL LIBRARY FUNCTIONS START HERE *** */
long int_plus(int nargs, ... )
{
  long result = 0;
  long tmp = 0;

  va_list(ap);
  va_start(ap, nargs);

  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    result += tmp;
  }
  va_end(ap);
  return result;
}
  
long int_eq(int nargs, ...)
{
  long result = 1;
  long tmp = 0, old = 0;
  
  va_list(ap);
  va_start(ap, nargs);

  nargs--;
  old = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp != old) {
      result = 0;
      break;
    }
  }
  va_end(ap);
  return result;
}

long int_assign(int, ...)
{
  // dummy function, won't be called
  return 1;
}

long int_minus(int nargs, ...)
{
  long result = 0;
  long tmp = 0;
  
  va_list(ap);
  va_start(ap, nargs);

  nargs--;
  result = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    result -= tmp;
  }
  va_end(ap);
  return result;
}
  
long int_abs(int nargs, ...)
{
  long result = 0;
  va_list(ap);
  va_start(ap, nargs);
  
  result = va_arg(ap, long);

  if (result < 0)
    result = -result;
  
  va_end(ap);
  return result;
}

long int_le(int nargs, ...)
{
  long result = 1;
  long tmp = 0, old = 0;
  
  va_list(ap);
  va_start(ap, nargs);

  nargs--;
  old = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp > old) {
      result = 0;
      break;
    }
    old = tmp;
  }
  va_end(ap);
  return result;
}

long int_ge(int nargs, ...)
{
  long result = 1;
  long tmp = 0, old = 0;
  
  va_list(ap);
  va_start(ap, nargs);
  
  nargs--;
  old = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp < old) {
      result = 0;
      break;
    }
    old = tmp;
  }
  va_end(ap);
  return result;
}
long int_gt(int nargs, ...)
{
  long result = 1;
  long tmp = 0, old = 0;
  
  va_list(ap);
  va_start(ap, nargs);

  nargs--;
  old = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp <= old) {
      result = 0;
      break;
    }
    old = tmp;
  }
  va_end(ap);
  return result;
}

long int_lt(int nargs, ...)
{
  long result = 1;
  long tmp = 0, old = 0;
  
  va_list(ap);
  va_start(ap, nargs);

  nargs--;
  old = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp <= old) {
      result = 0;
      break;
    }
    old = tmp;
  }
  va_end(ap);
  return result;
}

long int_neq(int nargs, ...)
{
  long result = 1;
  long tmp = 0, old = 0;
  
  va_list(ap);
  va_start(ap, nargs);
  
  nargs--;
  old = va_arg(ap, long);
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp == old) {
      result = 0;
      break;
    }
  }
  va_end(ap);
  return result;
}

long int_times(int nargs, ...)
{
  long result = 1;
  long tmp = 0;
  
  va_list(ap);
  va_start(ap, nargs);
  
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    result *= tmp;
  }
  va_end(ap);
  return result;
}

long int_div(int nargs, ...)
{
  long result = 0;
  long tmp = 0;

  va_list(ap);
  va_start(ap, nargs);
  
  result = va_arg(ap, long);
  nargs--;
  
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp != 0)
      result /= tmp;
    else {
      fprintf(stderr, "division by zero in int_div(int nargs, ...)\n");
      exit(2);
    }
  }
  va_end(ap);
  return result;
}

long int_mod(int nargs, ...)
{
  long result = 0;
  long tmp = 0;
  
  va_list(ap);
  va_start(ap, nargs);
  
  result = va_arg(ap, long);
  nargs--;
  
  while (nargs-- > 0) {
    tmp = va_arg(ap, long);
    if (tmp != 0)
      result %= tmp;
    else {
      fprintf(stderr, "division by zero in int_mod(int nargs, ...)\n");
      exit(2);
    }
  }
  va_end(ap);
  return result;
}
/* *** INTERNAL LIBRARY FUNCTIONS END HERE *** */
