/* iterate.h -- definitions of iterator classes

   This program has no warranties of any kind. Use at own risk.
   
   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)
   
   $Id: iterate.h,v 1.1 1998/08/04 09:18:39 tssyrjan Exp $	 
*/

#ifndef ITERATE_H
#define ITERATE_H

#include "global.h"
#include "instance.h"

class Iterator
{
public:
  virtual Instance *Iterate(Instance) = 0;
  virtual void Clear() = 0;
};
  

// HashSetIterator 
class HashSetIterator : public Iterator
{
public:
  HashSetIterator(HashSet *hs);
  virtual ~HashSetIterator() ;

  virtual void Reset(HashSet *);
  virtual void Clear();
  virtual Instance *Iterate(Instance it = -1);
private:
  long current, returned;
  HashSet *set;
};


// An iterator for RBTrees. Constructor takes as its only argument the
// tree to iterate. The Iterate(Instance value) returns all items with
// index value 'value' from tree one by one and NULL when they run
// out. 
class RBTreeIterator : public Iterator
{
public:
  RBTreeIterator(RBTree *);
  virtual ~RBTreeIterator();

  virtual void Reset(RBTree *);
  virtual  void Clear();
  virtual Instance *Iterate(Instance value);
private:
  TreeNode *current;
  RBTree *tree;
};



#endif
