/* debug.h -- debugging and error macros
      
   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: debug.cc,v 1.1 1998/08/04 09:19:40 tssyrjan Exp $	 
*/

#include "debug.h"
#include "global.h"
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

int errno;

void debug(int type, int level, char *fmt, ...)
{
#ifdef DEBUG 
  if ((DEBUG & type) &&
      (DEBUG_LEVEL >= level)) {
    va_list(ap);
    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n"); 
    va_end(ap);
  }
#endif
}
  
void error(int level, char *fmt, ...)  
{
  int pos = 0;
  static char buf[BUFSIZ] = { 0 };
  
  va_list(ap);
  va_start(ap, fmt);
  if (level >= SYS_ERR) {
    pos += vsprintf(buf, fmt, ap);
    if (pos >= BUFSIZ) {
      fprintf(stderr, "buffer owerflow -- core dumped\n");
      abort(); // buffer owerflow, don't do anything
    }
    buf[pos] = '\0';
    perror(buf);
  } else {
    vfprintf(stderr, fmt, ap);
    fprintf(stderr, "\n");
  }
  va_end(ap);
  if (level > USR_ERR)
    exit(E_ERROR);
  else
    sys_data.num_errors++;
}
      
void warn(int cause, char *fmt, ...)
{
  if (!(cause & sys_data.warnings))
    return;
  
  fprintf(stderr, "%s: ", (sys_data.abort_when_warn) ? "Error" :
	  "Warning"); 
  va_list(ap);
  va_start(ap, fmt);
  vfprintf(stderr, fmt, ap);
  fprintf(stderr, "\n"); 
  va_end(ap);
  if (sys_data.abort_when_warn)
    sys_data.num_errors++;
};

