/* array.h -- definitions of flexible arrays for lparse

   Provides classes for resizable arrays. Currently includes:
        - ResizableArray -- basic array, stores longs
	- PredicateArray -- stores predicates
	- GraphNodeArray -- for graphnodes
	
   Array of type T has following attributes:
   	T *arr    -- the actual array
	long size -- size of the beast

   And methods:
   	T(long sz) -- constructor for array with initial size 'sz'.
	T *operator[](long idx) -- indexing operator which does
		resizing on the fly if needed. Returns pointer instead
		of reference because g++ (or possibly checker) somehow
		garbled the references.
		
   The arrays should be implemented with templates but I have bad
   experiences with them. So currently they are all separate classes
   with nearly identical code. This should be changed later.

   This program has no warranties of any kind. Use at own risk.
   
   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)
   
   $Id: array.h,v 1.1 1998/08/04 09:18:56 tssyrjan Exp $	 

   */

#ifndef ARRAY_H
#define ARRAY_H

#include "global.h"

class ResizableArray
{
public:
  ResizableArray(long sz = 10);
  ~ResizableArray();

  long *operator[](long idx);
private:
  long *arr;
  long size;
};

class Predicate;

class PredicateArray 
{
public:
  PredicateArray(long sz = 10);
  ~PredicateArray();

  Predicate *operator[](long idx);
private:
  Predicate **arr;
  long size;
};



class GraphNode;


class GraphNodeArray 
{
public:
  GraphNodeArray();
  ~GraphNodeArray();

  GraphNode *operator[](long idx);
private:
  GraphNode **arr;
  long size;
};

#endif
