/* array.cc -- implementation of flexible arrays for lparse

   This program has no warranties of any kind. Use at own risk.

   Author: Tommi Syrjnen (tommi.syrjanen@hut.fi)

   $Id: array.cc,v 1.1 1998/08/04 09:19:43 tssyrjan Exp $	 

   */

#include "global.h"
#include "array.h"		
#include "debug.h"
#include "predicate.h"
#include <string.h>

ResizableArray::ResizableArray(long sz)
  : arr(NULL)
{
  size = sz;
  arr = new long[size];

  if (!arr)
    error(SYS_ERR,"malloc error");

  memset(arr, 0, sizeof(long) * size);
}

ResizableArray::~ResizableArray()
{
  delete arr;
}

long *ResizableArray::operator[](long idx)
{
  long *tmp = NULL, ns = size, i;

  if (idx < size) 
    return &arr[idx];

  // resize the array. 
  while (ns <= idx) 
    ns *= 2;

  tmp = new long[ns];
  if (!tmp)
    error(SYS_ERR,"malloc error");

  for (i= 0; i < size; i++) 
    tmp[i] = arr[i];

  while (i < ns) {
    tmp[i] = 0;
    i++;
  }

  size = ns;
  delete arr;
  arr = tmp;

  return &arr[idx];
}
  
PredicateArray::PredicateArray(long sz)
{
  long i = 0;
  size = sz;
  arr = new Predicate*[size];

  if (!arr)
    error(SYS_ERR,"malloc error");

  for (i = 0; i < sz; i++)
    arr[i] = new Predicate;
}

PredicateArray::~PredicateArray()
{
  delete arr;
}

Predicate *PredicateArray::operator[](long idx)
{
  long ns;
  long i;
  Predicate **tmp;

  ns = this->size;
  if (idx < this->size) 
    return this->arr[idx];

  while (ns <= idx) 
    ns *= 2;

  tmp = new Predicate*[ns];
  if (!tmp)
    error(SYS_ERR,"malloc error");

  for (i= 0; i < size; i++) 
    tmp[i] = arr[i];
  while (i < ns) {
    tmp[i] = new Predicate;
    i++;
  }
  
  size = ns;
  
  delete arr;
  arr = tmp;
  return this->arr[idx];
}




GraphNodeArray::GraphNodeArray()
{
  int i;
  size = 10;
  arr = new GraphNode*[size];

  if (!arr)
    error(SYS_ERR,"malloc error");

  for (i = 0; i < size; i++) 
    arr[i] = new GraphNode;
  
}

GraphNodeArray::~GraphNodeArray()
{
  delete arr;
}

GraphNode *GraphNodeArray::operator[](long idx)
{
  long ns;
  long i;
  GraphNode **tmp;

  ns = this->size;
  if (idx < this->size) 
    return this->arr[idx];
				
  while (ns <= idx) 
    ns *= 2;

  tmp = new GraphNode*[ns];
  if (!tmp)
    error(SYS_ERR,"malloc error");

  for (i= 0; i < size; i++) 
    tmp[i] = arr[i];
  while ( i < ns)
    tmp[i++] = new GraphNode;
  
  size = ns;

  delete arr;
  arr = tmp;

  
  return this->arr[idx];
}

PredicateArray predicates;
