#!/bin/bash

DIR=`pwd`
BIN=$DIR/bin
TMP=$DIR/tmp
DEF=$DIR/def

# Local Functions
#================
function cleanup()
{
  for f in $purge
  do
    rm -f $f
  done
}

function toclean()
{
  if [ $# -gt 0 ]
  then
    touch $*
    purge=$purge" "$*
    trap cleanup EXIT
  fi
}
#=================
model=$TMP/$$-model.txt
log=$TMP/cplex.log

#Declare temporary files for removal upon exit
toclean $model $log

#SOLVE
wd=`pwd`
cd $TMP
( echo "read" $*; \
  echo "set mip tolerances absmipgap 1e-09"; \  
  echo "optimize"; \
  echo "display solution member 1 variables -" ) \
| $BIN/cplex > $model 2>/dev/null
if test $? -ne 0
then
  echo "$0: cplex did not accept the input!"
  exit -1
fi
cd $wd

# PRINT
if egrep "^MIP - Integer infeasible.$" $model 1>/dev/null
then
  echo "UNSATISFIABLE"
else
  if egrep "^Solution pool: [1-9][0-9]* solution[s]* saved.$" $model 1>/dev/null
  then
    echo "SATISFIABLE"
    echo -n "Vars: "
    egrep '^[[:lower:]].*[[:digit:]]+\.[[:digit:]]+$' $model \
    | egrep -v "^var_" \
    | sed 's/ /=/;s/ //g' \
    | sed 's/.000000//g' \
    | sed 's/_l/(/g;s/_r/)/g' \
    | tr "\n" " "
    echo "(other values 0)"
  else
    echo "UNKNOWN"
  fi
fi

