#!/bin/bash

# This script solves ASP(LC) programs with real variables. The idea is
# described in an article "Introducing Real Variables and MIP Objective
# Functions to Answer Set Programming" authored by
# Guohua Liu, Tomi Janhunen, and Ilkka Niemela

MAINDIR=`pwd`
SCRIPTDIR=$MAINDIR/script
TMP=$MAINDIR/tmp

GROUND=$SCRIPTDIR/mingo.sh
DEQUOTE=$SCRIPTDIR/drop-quotes.sh
DESTRICT=$SCRIPTDIR/deStrict.sh
SOLVE=$SCRIPTDIR/cplex.sh

inst=$1
enc=$2
bound=0.000001 #bound of delta

if [ $# -ne 2 ]
then
  echo "Usage: `basename $0` instance encoding"
  exit 1
fi

$GROUND --ground-only $inst $enc > $TMP/$$-tmp1.lp
$DEQUOTE $TMP/$$-tmp1.lp > $TMP/$$-tmp2.lp
$DESTRICT $TMP/$$-tmp2.lp $bound > $TMP/$$-tmp3.lp
$SOLVE $TMP/$$-tmp3.lp

rm -f $TMP/$$-tmp1.lp 
rm -f $TMP/$$-tmp2.lp 
rm -f $TMP/$$-tmp3.lp
