#!/bin/bash

DIR=.

if ! test -x $DIR/clasp
then
  echo "You should install clasp first!"
  exit -1
fi

if ! test -x $DIR/gringo
then
  echo "You should install gringo first!"
  exit -1
fi

# Standard

for ds in heart econ
do
  for k in 0 1 2
  do
    for type in off bforig node part edge
    do
      echo "=== Running $ds (filter=$type, k=$k) ==="
      echo ""
      $DIR/run.sh -cdataset=${ds}_${type}_k$k \
        $DIR/peo.lp $DIR/data/$ds-$type-k=$k.lp
    done
  done
done

# Labeled

for ds in heart econ
do
  for k in 0 1 2
  do
    for type in off bforig node part edge
    do
      echo "=== Running $ds-lab (filter=$type, k=$k) ==="
      echo ""
      $DIR/run.sh -cdataset=${ds}_lab_${type}_k$k \
        $DIR/peo-lab.lp $DIR/data-lab/$ds-$type-k=$k.lp
    done
  done
done
