#!/bin/bash

DIR=.

if ! test -x $DIR/clasp
then
  echo "You should install clasp first!"
  exit -1
fi

if ! test -x $DIR/gringo
then
  echo "You should install gringo first!"
  exit -1
fi

# Standard

for k in 0 1 2
do
  for type in bforig node part edge off
  do
    $DIR/filter.sh -cn=$k $DIR/data/heart.lp $DIR/filter/$type.lp \
      > $DIR/data/heart-$type-k=$k.lp

    $DIR/filter.sh -cn=$k $DIR/data/econ.lp $DIR/filter/$type.lp \
      > $DIR/data/econ-$type-k=$k.lp
  done
done

# Labeled

for k in 0 1 2
do
  for type in bforig node part edge off
  do
    $DIR/filter.sh -cn=$k $DIR/data-lab/heart.lp $DIR/filter/$type-lab.lp \
      > $DIR/data-lab/heart-$type-k=$k.lp

    $DIR/filter.sh -cn=$k $DIR/data-lab/econ.lp $DIR/filter/$type-lab.lp \
      > $DIR/data-lab/econ-$type-k=$k.lp
  done
done
