function D=sim2dis2(p,S);
%function D=sim2dis2(p,S);
%
%PURPOSE 
%
%To transform elements (in [-1,1]) of a similarity matrix S into
%dissimilarities D by 
%
% D=sqrt(1-abs(S).^p); 
%
%INPUT
%
%p   (scalar) 
%S   (matrix) MxM similarity matrix whose elements must be in [-1,1]
%      for example, absolute values of linear correlation coefficients.
%
%OUTPUT 
%
% D  (matrix) MxM dissimilarity matrix
%
%SEE ALSO
%  sim2dis


%COPYRIGHT NOTICE
%This function is a part of Icasso software library
%Copyright (C) 2003-2005 Johan Himberg
%
%This program is free software; you can redistribute it and/or
%modify it under the terms of the GNU General Public License
%as published by the Free Software Foundation; either version 2
%of the License, or any later version.
%
%This program is distributed in the hope that it will be useful,
%but WITHOUT ANY WARRANTY; without even the implied warranty of
%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%GNU General Public License for more details.
%
%You should have received a copy of the GNU General Public License
%along with this program; if not, write to the Free Software
%Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

% ver 1.2 johan 100504

S=abs(S);
if any(S(:))>1,
  Error('Values must be in [-1,1]');
end

D=sqrt(1-S.^p);

% Just to make sure that no complex values occur
D=abs(D);
