from src.logic import *


def print_as_atoms(program, postfix):
    id = 0
    atoms_reprs = set()
    for r in program.rules:
        rule_name = "rule_" + postfix + "_" + str(id)
        print("in_" + "rule_" + postfix + "(" + rule_name + ").")
        id += 1

        head = r.head
        headnumber = head.atomnumber
        head_repr = str(get_atom_repr(headnumber, program.symbolTable))
        atoms_reprs.add(head_repr)

        print("in_" + "head_" + postfix + "(" + rule_name + ", " + head_repr + ").")

        body = r.body
        for lit in body.get_indir_subliterals():
            # We know that the body is a conjunction of literals
            atomnumber = lit.atomnumber
            atom_repr = str(get_atom_repr(atomnumber, program.symbolTable))
            atoms_reprs.add(atom_repr)
            prefix = "pos"
            if lit.negated:
                prefix = "neg"
            print("in_" + prefix + "_body_" + postfix + "(" + rule_name + ", " + atom_repr + ").")

    for lit in program.constraint.get_indir_subliterals():
        # We know that the constraint is a conjunction of literals:
        rule_name = "rule_" + postfix + "_" + str(id)
        print("in_" + "rule_" + postfix + "(" + rule_name + ").")
        id += 1

        atomnumber = lit.atomnumber
        atom_repr = str(get_atom_repr(atomnumber, program.symbolTable))
        atoms_reprs.add(atom_repr)

        # VICE VERSA BECAUSE RULE VS CONSTRAINT = ONE NEGATION DFF
        prefix = "neg"
        if lit.negated:
            prefix = "pos"
        print("in_" + prefix + "_body_" + postfix + "(" + rule_name + ", " + atom_repr + ").")
    for p in program.parameters:
        atomnumber = p.atomnumber
        atom_repr = str(get_atom_repr(atomnumber, program.symbolTable))
        atoms_reprs.add(atom_repr)
        print("in_" + "parameter_" + postfix + "(" + atom_repr + ").")
    for a in atoms_reprs:
        print("in_" + "atom_" + postfix + "(" + a + ").")

    return


def get_atom_repr(atom_number, symbol_table):
    return symbol_table.get(atom_number, atom_number)
