/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*-  */
/*
 * BDDPropagator.h
 * Copyright (C) 2015 Shahab Tasharrofi <>
 *
 * graphsat is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * graphsat is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _BDD_PROPAGATOR_H_
#define _BDD_PROPAGATOR_H_

#include "propagators/TriggerProtectedPropagator.h"
#include "includes/cudd/cuddObj.hh"

class BDDPropagator: public Propagator 
{
	private:
		Cudd bddManager;
		BDD satisfiabilityLowerbound;
		TriggerProtectedPropagator *internalPropagator;

		vec<Lit> explanation;

		bool isTriggered();
		void strengthenTriggers();
	protected:
		// Overridden protected methods from Propagator class
		virtual bool propagate(int start, int end) override;
		virtual bool propagate(Lit p) override;
		virtual void cancelUntil(int level) override;
	public:
		BDDPropagator(TriggerProtectedPropagator *P);

		// Overridden public methods from Propagator class
		virtual bool initialize(void) override;
		virtual const vec<Lit> &explain() override;
		virtual bool isTheoryVar(Var v) override;
};

#endif // _BDD_PROPAGATOR_H_

