
%skeleton "lalr1.cc"
%require  "3.0"
%debug 
%defines 
%define api.namespace {GG}
%define parser_class_name {GG_Parser}

%code requires{
#include <string>
#include "heading.h"
#include "compact-string.h"

namespace GG{
	class GG_Scanner;
}

using namespace std;

// The following definitions is missing when %locations isn't used
# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

}

%parse-param { GG_Scanner &scanner  }

%code{
#include <iostream>
#include <cstdlib>
#include <fstream>
#include "scanner.h"

#undef yylex
#define yylex scanner.yylex
}

%define api.value.type variant
%define parse.assert

%start init_symbol

%token <string> TOKEN_ID
%token <int64_t> TOKEN_INT
%token <string> TOKEN_STRING

%token KEYWORD_complete
%token KEYWORD_preferred
%token KEYWORD_stable
%token KEYWORD_semistable
%token KEYWORD_stage
%token KEYWORD_grounded
%token KEYWORD_ideal
%token KEYWORD_brave
%token KEYWORD_skeptical
%token KEYWORD_search
%token KEYWORD_apx
%token KEYWORD_tgf
%token SYM_SHARP
%token KEYWORD_arg
%token SYM_OP_PARAN
%token SYM_CL_PARAN
%token SYM_DOT
%token KEYWORD_att
%token SYM_COMMA
%type <gg_datatype_Spec_base *> NT_Spec
%type <gg_datatype_Output_base *> NT_Output
%type <gg_datatype_Reasoning_base *> NT_Reasoning
%type <gg_datatype_Input_base *> NT_Input
%type <gg_datatype_APXArgument_base *> NT_APXArgument
%type <gg_datatype_APXAttack_base *> NT_APXAttack
%type <gg_datatype_TGFArgument_base *> NT_TGFArgument
%type <gg_datatype_TGFAttack_base *> NT_TGFAttack
%type <gg_datatype_ArgName_base *> NT_ArgName
%type <vector<gg_datatype_APXArgument_base *>*> List_APXArgument
%type <vector<gg_datatype_APXAttack_base *>*> List_APXAttack
%type <vector<gg_datatype_TGFArgument_base *>*> List_TGFArgument
%type <vector<gg_datatype_TGFAttack_base *>*> List_TGFAttack


%locations

%%

init_symbol : NT_Spec { while ($1->fixpoint_semantics()) { } ; while ($1->fixpoint_postsem()) { } ; $1->output_grounder(cout); }
NT_Spec :
		  NT_Input[inp] NT_Reasoning[r] KEYWORD_complete NT_Output[out]
		  { $$ = new gg_datatype_Spec_type1($inp, $r, $out); }
		| NT_Input[inp] NT_Reasoning[r] KEYWORD_preferred NT_Output[out]
		  { $$ = new gg_datatype_Spec_type2($inp, $r, $out); }
		| NT_Input[inp] NT_Reasoning[r] KEYWORD_stable NT_Output[out]
		  { $$ = new gg_datatype_Spec_type3($inp, $r, $out); }
		| NT_Input[inp] NT_Reasoning[r] KEYWORD_semistable NT_Output[out]
		  { $$ = new gg_datatype_Spec_type4($inp, $r, $out); }
		| NT_Input[inp] NT_Reasoning[r] KEYWORD_stage NT_Output[out]
		  { $$ = new gg_datatype_Spec_type5($inp, $r, $out); }
		| NT_Input[inp] NT_Reasoning[r] KEYWORD_grounded NT_Output[out]
		  { $$ = new gg_datatype_Spec_type6($inp, $r, $out); }
		| NT_Input[inp] NT_Reasoning[r] KEYWORD_ideal NT_Output[out]
		  { $$ = new gg_datatype_Spec_type7($inp, $r, $out); }
		;
NT_Output :
		  /* empty */
		  { $$ = new gg_datatype_Output_type1(); }
		;
NT_Reasoning :
		  KEYWORD_brave NT_ArgName[argument]
		  { $$ = new gg_datatype_Reasoning_type1($argument); }
		| KEYWORD_skeptical NT_ArgName[argument]
		  { $$ = new gg_datatype_Reasoning_type2($argument); }
		| KEYWORD_search
		  { $$ = new gg_datatype_Reasoning_type3(); }
		;
NT_Input :
		  KEYWORD_apx List_APXArgument[args] List_APXAttack[atts]
		  { $$ = new gg_datatype_Input_type1(*$args, *$atts); delete $args; delete $atts; }
		| KEYWORD_tgf List_TGFArgument[args] SYM_SHARP List_TGFAttack[atts]
		  { $$ = new gg_datatype_Input_type2(*$args, *$atts); delete $args; delete $atts; }
		;
NT_APXArgument :
		  KEYWORD_arg SYM_OP_PARAN NT_ArgName[argument] SYM_CL_PARAN SYM_DOT
		  { $$ = new gg_datatype_APXArgument_type1($argument); }
		;
NT_APXAttack :
		  KEYWORD_att SYM_OP_PARAN NT_ArgName[attacker] SYM_COMMA NT_ArgName[attacked] SYM_CL_PARAN SYM_DOT
		  { $$ = new gg_datatype_APXAttack_type1($attacker, $attacked); }
		;
NT_TGFArgument :
		  NT_ArgName[argument]
		  { $$ = new gg_datatype_TGFArgument_type1($argument); }
		;
NT_TGFAttack :
		  NT_ArgName[attacker] NT_ArgName[attacked]
		  { $$ = new gg_datatype_TGFAttack_type1($attacker, $attacked); }
		;
NT_ArgName :
		  TOKEN_ID[argId]
		  { $$ = new gg_datatype_ArgName_type1(compact_string::make_from($argId.c_str())); }
		| TOKEN_INT[argNo]
		  { $$ = new gg_datatype_ArgName_type2($argNo); }
		;

List_APXArgument :
		  /* empty */
		  { $$ = new vector<gg_datatype_APXArgument_base *>(); }
		| List_APXArgument[List] NT_APXArgument[Item]
		  { $List->push_back($Item); $$ = $List; }
		;

List_APXAttack :
		  /* empty */
		  { $$ = new vector<gg_datatype_APXAttack_base *>(); }
		| List_APXAttack[List] NT_APXAttack[Item]
		  { $List->push_back($Item); $$ = $List; }
		;

List_TGFArgument :
		  /* empty */
		  { $$ = new vector<gg_datatype_TGFArgument_base *>(); }
		| List_TGFArgument[List] NT_TGFArgument[Item]
		  { $List->push_back($Item); $$ = $List; }
		;

List_TGFAttack :
		  /* empty */
		  { $$ = new vector<gg_datatype_TGFAttack_base *>(); }
		| List_TGFAttack[List] NT_TGFAttack[Item]
		  { $List->push_back($Item); $$ = $List; }
		;

%%

void GG::GG_Parser::error(const location_type &l, const std::string &err_message)
{
	std::cerr << "Error: " << err_message << " at " << l << "\n";
}

