
%{
/* C++ string header, for string ops below */
#include <string>

/* Implementation of yyFlexScanner */
#include "scanner.h"

#undef  YY_DECL
#define YY_DECL int GG::GG_Scanner::yylex(GG::GG_Parser::semantic_type *const lval, GG::GG_Parser::location_type *loc)

/* typedef to make the returns for the tokens shorter */
using token = GG::GG_Parser::token;

/* update location on matching */
#define YY_USER_ACTION loc->step(); loc->columns(yyleng);

%}

%option debug
%option nodefault
%option yyclass="GG::GG_Scanner"
%option noyywrap
%option c++

alphabet [a-zA-Z]
digit		[0-9]
int_const	{digit}+
identifier [a-zA-Z_][a-zA-Z0-9_]*


%%
%{          /** Code executed at the beginning of yylex **/
            yylval = lval;
%}

"tgf" { return token::KEYWORD_tgf; }
"stage" { return token::KEYWORD_stage; }
"stable" { return token::KEYWORD_stable; }
"skeptical" { return token::KEYWORD_skeptical; }
"semistable" { return token::KEYWORD_semistable; }
"search" { return token::KEYWORD_search; }
"preferred" { return token::KEYWORD_preferred; }
"ideal" { return token::KEYWORD_ideal; }
"grounded" { return token::KEYWORD_grounded; }
"complete" { return token::KEYWORD_complete; }
"brave" { return token::KEYWORD_brave; }
"att" { return token::KEYWORD_att; }
"arg" { return token::KEYWORD_arg; }
"apx" { return token::KEYWORD_apx; }
"." { return token::SYM_DOT; }
"," { return token::SYM_COMMA; }
")" { return token::SYM_CL_PARAN; }
"(" { return token::SYM_OP_PARAN; }
"#" { return token::SYM_SHARP; }

{int_const}	{ yylval->build<int64_t>(atoi(yytext)); return token::TOKEN_INT; }
{identifier}	{ yylval->build<std::string>(yytext); return token::TOKEN_ID; }
\"(\\.|[^\\\"])*\"	{ yylval->build<std::string>(yytext); return token::TOKEN_STRING; }

[ \t]*		{}
[\n]		{ loc->lines();	}

.		{ std::cerr << "SCANNER "; YY_FATAL_ERROR(""); exit(1);	}

