
/* heading.h */

#ifndef _HEADING_H
#define _HEADING_H

#define YY_NO_UNPUT

using namespace std;

#include <iostream>
#include <stdio.h>
#include <stdint.h>
#include <string>

#include "compact-string.h"
#include "relalgebra.h"

class gg_node
{
	private:
		int64_t uniqueId;
	public:
		inline int64_t getUniqueId() const { return uniqueId; }

		virtual string toString() const = 0;

		gg_node();
};

// Forward definition of base datatype classes
class gg_datatype_Spec_base;
class gg_datatype_Output_base;
class gg_datatype_Reasoning_base;
class gg_datatype_Input_base;
class gg_datatype_APXArgument_base;
class gg_datatype_APXAttack_base;
class gg_datatype_TGFArgument_base;
class gg_datatype_TGFAttack_base;
class gg_datatype_ArgName_base;

class gg_datatype_Spec_base : public gg_node
{
	public:
		int64_t local_totalVarCount;
		rel_algebra_node local_attacks01;
		rel_algebra_node local_attacks21;
		rel_algebra_node local_attacks10;
		rel_algebra_node local_eDicTU;
		virtual void output_grounder(ostream &os) const = 0;
		virtual bool fixpoint_semantics() = 0;
		virtual bool fixpoint_postsem() = 0;
		gg_datatype_Spec_base() : gg_node() { }
};

class gg_datatype_Spec_type1 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_dTupleUCount;
		int64_t local_eTupleUCount;
		int64_t local_eTupleTCount;
		rel_algebra_node local_args02;
		rel_algebra_node local_dDicU;
		rel_algebra_node local_eDic0to2;
		rel_algebra_node local_eDic1to3;
		rel_algebra_node local_dDic0to2;
		rel_algebra_node local_dDic1to3;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type1(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Spec_type2 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_afterEDicU;
		int64_t local_afterEDicTU;
		int64_t local_dTupleUCount;
		int64_t local_eTupleUCount;
		int64_t local_eTupleTCount;
		rel_algebra_node local_args02;
		rel_algebra_node local_eDicU;
		rel_algebra_node local_eDicT;
		rel_algebra_node local_dDicU;
		rel_algebra_node local_eDic0to2;
		rel_algebra_node local_eDic1to3;
		rel_algebra_node local_dDic0to2;
		rel_algebra_node local_dDic1to3;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type2(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Spec_type3 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_dTupleUCount;
		int64_t local_eTupleUCount;
		int64_t local_eTupleTCount;
		rel_algebra_node local_args02;
		rel_algebra_node local_dDicU;
		rel_algebra_node local_eDic0to2;
		rel_algebra_node local_eDic1to3;
		rel_algebra_node local_eDic0to3;
		rel_algebra_node local_dDic0to2;
		rel_algebra_node local_dDic1to3;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type3(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Spec_type4 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_afterEVar;
		int64_t local_afterDVar;
		int64_t local_dTupleUCount;
		int64_t local_eTupleUCount;
		int64_t local_eTupleTCount;
		int64_t local_pNewTupleCount;
		int64_t local_pTotalTupleCount;
		rel_algebra_node local_args02;
		rel_algebra_node local_dDicU;
		rel_algebra_node local_pDicNew;
		rel_algebra_node local_eDic0to2;
		rel_algebra_node local_eDic1to3;
		rel_algebra_node local_dDic0to2;
		rel_algebra_node local_dDic0to4;
		rel_algebra_node local_dDic1to3;
		rel_algebra_node local_eDicU0to2;
		rel_algebra_node local_eDicU0to3;
		rel_algebra_node local_pDic0to2;
		rel_algebra_node local_pDic0to1;
		rel_algebra_node local_pTranslator;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type4(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Spec_type5 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_eTupleTUCount;
		int64_t local_pTupleUCount;
		rel_algebra_node local_ctp;
		rel_algebra_node local_cfp;
		rel_algebra_node local_cup;
		rel_algebra_node local_pDicU;
		rel_algebra_node local_eDicTU0to2;
		rel_algebra_node local_eDicTU1to3;
		rel_algebra_node local_pDicU0to2;
		rel_algebra_node local_pDicU0to3;
		rel_algebra_node local_pDicU1to3;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type5(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Spec_type6 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_afterEDicU;
		int64_t local_afterEDicTU;
		int64_t local_dTupleUCount;
		int64_t local_eTupleUCount;
		int64_t local_eTupleTCount;
		rel_algebra_node local_args02;
		rel_algebra_node local_eDicU;
		rel_algebra_node local_eDicT;
		rel_algebra_node local_dDicU;
		rel_algebra_node local_eDic0to2;
		rel_algebra_node local_eDic1to3;
		rel_algebra_node local_dDic0to2;
		rel_algebra_node local_dDic1to3;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type6(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Spec_type7 : public gg_datatype_Spec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_Input_base* subtree_inp;
		gg_datatype_Reasoning_base* subtree_r;
		gg_datatype_Output_base* subtree_out;

		// local variables
		int64_t local_afterEDicU;
		int64_t local_afterEDicTU;
		int64_t local_dTupleUCount;
		int64_t local_eTupleUCount;
		int64_t local_eTupleTCount;
		int64_t local_eTupleTUCount;
		rel_algebra_node local_args02;
		rel_algebra_node local_eDicU;
		rel_algebra_node local_eDicT;
		rel_algebra_node local_dDicU;
		rel_algebra_node local_eDic0to2;
		rel_algebra_node local_eDic1to3;
		rel_algebra_node local_dDic0to2;
		rel_algebra_node local_dDic1to3;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Spec_base
		virtual void output_grounder(ostream &os) const;
		virtual bool fixpoint_semantics();
		virtual bool fixpoint_postsem();

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Spec_base

		// internal operations
		// constructor
		gg_datatype_Spec_type7(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out);
};

class gg_datatype_Output_base : public gg_node
{
	public:
		virtual void output_completion_semantics(ostream &os, rel_algebra_node local_arguments, rel_algebra_node local_attacks01, rel_algebra_node local_attacks10, rel_algebra_node local_cfe, rel_algebra_node local_cte, rel_algebra_node local_cfd, rel_algebra_node local_ctd, rel_algebra_node local_eDic0to2, rel_algebra_node local_eDic1to3, rel_algebra_node local_dDic0to2, rel_algebra_node local_dDic1to3) const = 0;
		virtual void output_range_clauses(ostream &os, rel_algebra_node local_pDic0to2, rel_algebra_node local_eDicU0to3, rel_algebra_node local_dDic0to4, rel_algebra_node local_cfd, rel_algebra_node local_cfe) const = 0;
		virtual void output_unary_proper_subset_clauses(ostream &os, rel_algebra_node local_dictionary) const = 0;
		virtual void output_stage_semantics(ostream &os, rel_algebra_node local_attacks01, rel_algebra_node local_eDicTU0to2, rel_algebra_node local_eDicTU1to3, rel_algebra_node local_pDicU0to2, rel_algebra_node local_pDicU0to3, rel_algebra_node local_pDicU1to3, rel_algebra_node local_cte) const = 0;
		virtual void output_admissibility_clauses(ostream &os, rel_algebra_node local_attacks01, rel_algebra_node local_eDic0to2, rel_algebra_node local_eDic1to3, rel_algebra_node local_cte) const = 0;
		gg_datatype_Output_base() : gg_node() { }
};

class gg_datatype_Output_type1 : public gg_datatype_Output_base
{
	public:
		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Output_base
		virtual void output_completion_semantics(ostream &os, rel_algebra_node local_arguments, rel_algebra_node local_attacks01, rel_algebra_node local_attacks10, rel_algebra_node local_cfe, rel_algebra_node local_cte, rel_algebra_node local_cfd, rel_algebra_node local_ctd, rel_algebra_node local_eDic0to2, rel_algebra_node local_eDic1to3, rel_algebra_node local_dDic0to2, rel_algebra_node local_dDic1to3) const;
		virtual void output_range_clauses(ostream &os, rel_algebra_node local_pDic0to2, rel_algebra_node local_eDicU0to3, rel_algebra_node local_dDic0to4, rel_algebra_node local_cfd, rel_algebra_node local_cfe) const;
		virtual void output_unary_proper_subset_clauses(ostream &os, rel_algebra_node local_dictionary) const;
		virtual void output_stage_semantics(ostream &os, rel_algebra_node local_attacks01, rel_algebra_node local_eDicTU0to2, rel_algebra_node local_eDicTU1to3, rel_algebra_node local_pDicU0to2, rel_algebra_node local_pDicU0to3, rel_algebra_node local_pDicU1to3, rel_algebra_node local_cte) const;
		virtual void output_admissibility_clauses(ostream &os, rel_algebra_node local_attacks01, rel_algebra_node local_eDic0to2, rel_algebra_node local_eDic1to3, rel_algebra_node local_cte) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Output_base

		// internal operations
		// constructor
		gg_datatype_Output_type1();
};

class gg_datatype_Reasoning_base : public gg_node
{
	public:
		rel_algebra_node local_ct;
		rel_algebra_node local_cf;
		gg_datatype_Reasoning_base() : gg_node() { }
};

class gg_datatype_Reasoning_type1 : public gg_datatype_Reasoning_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_ArgName_base* subtree_argument;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Reasoning_base

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Reasoning_base

		// internal operations
		// constructor
		gg_datatype_Reasoning_type1(gg_datatype_ArgName_base* const &argument);
};

class gg_datatype_Reasoning_type2 : public gg_datatype_Reasoning_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_ArgName_base* subtree_argument;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Reasoning_base

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Reasoning_base

		// internal operations
		// constructor
		gg_datatype_Reasoning_type2(gg_datatype_ArgName_base* const &argument);
};

class gg_datatype_Reasoning_type3 : public gg_datatype_Reasoning_base
{
	public:
		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Reasoning_base

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Reasoning_base

		// internal operations
		// constructor
		gg_datatype_Reasoning_type3();
};

class gg_datatype_Input_base : public gg_node
{
	public:
		int64_t local_argCount;
		virtual void output_symbolTable(ostream &os) const = 0;
		gg_datatype_Input_base() : gg_node() { }
};

class gg_datatype_Input_type1 : public gg_datatype_Input_base
{
	public:
		// abstract syntax tree representation
		vector<gg_datatype_APXArgument_base*> subtree_args;
		vector<gg_datatype_APXAttack_base*> subtree_atts;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Input_base
		virtual void output_symbolTable(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Input_base

		// internal operations
		// constructor
		gg_datatype_Input_type1(vector<gg_datatype_APXArgument_base*> const &args, vector<gg_datatype_APXAttack_base*> const &atts);
};

class gg_datatype_Input_type2 : public gg_datatype_Input_base
{
	public:
		// abstract syntax tree representation
		vector<gg_datatype_TGFArgument_base*> subtree_args;
		vector<gg_datatype_TGFAttack_base*> subtree_atts;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Input_base
		virtual void output_symbolTable(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Input_base

		// internal operations
		// constructor
		gg_datatype_Input_type2(vector<gg_datatype_TGFArgument_base*> const &args, vector<gg_datatype_TGFAttack_base*> const &atts);
};

class gg_datatype_APXArgument_base : public gg_node
{
	public:
		virtual void output_symbolTableLine(ostream &os) const = 0;
		gg_datatype_APXArgument_base() : gg_node() { }
};

class gg_datatype_APXArgument_type1 : public gg_datatype_APXArgument_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_ArgName_base* subtree_argument;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_APXArgument_base
		virtual void output_symbolTableLine(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_APXArgument_base

		// internal operations
		// constructor
		gg_datatype_APXArgument_type1(gg_datatype_ArgName_base* const &argument);
};

class gg_datatype_APXAttack_base : public gg_node
{
	public:
		int64_t local_source;
		int64_t local_target;
		gg_datatype_APXAttack_base() : gg_node() { }
};

class gg_datatype_APXAttack_type1 : public gg_datatype_APXAttack_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_ArgName_base* subtree_attacker;
		gg_datatype_ArgName_base* subtree_attacked;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_APXAttack_base

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_APXAttack_base

		// internal operations
		// constructor
		gg_datatype_APXAttack_type1(gg_datatype_ArgName_base* const &attacker, gg_datatype_ArgName_base* const &attacked);
};

class gg_datatype_TGFArgument_base : public gg_node
{
	public:
		virtual void output_symbolTableLine(ostream &os) const = 0;
		gg_datatype_TGFArgument_base() : gg_node() { }
};

class gg_datatype_TGFArgument_type1 : public gg_datatype_TGFArgument_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_ArgName_base* subtree_argument;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_TGFArgument_base
		virtual void output_symbolTableLine(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_TGFArgument_base

		// internal operations
		// constructor
		gg_datatype_TGFArgument_type1(gg_datatype_ArgName_base* const &argument);
};

class gg_datatype_TGFAttack_base : public gg_node
{
	public:
		int64_t local_source;
		int64_t local_target;
		gg_datatype_TGFAttack_base() : gg_node() { }
};

class gg_datatype_TGFAttack_type1 : public gg_datatype_TGFAttack_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_ArgName_base* subtree_attacker;
		gg_datatype_ArgName_base* subtree_attacked;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_TGFAttack_base

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_TGFAttack_base

		// internal operations
		// constructor
		gg_datatype_TGFAttack_type1(gg_datatype_ArgName_base* const &attacker, gg_datatype_ArgName_base* const &attacked);
};

class gg_datatype_ArgName_base : public gg_node
{
	public:
		int64_t local_arg;
		virtual void output_name(ostream &os) const = 0;
		gg_datatype_ArgName_base() : gg_node() { }
};

class gg_datatype_ArgName_type1 : public gg_datatype_ArgName_base
{
	public:
		// abstract syntax tree representation
		compact_string subtree_argId;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_ArgName_base
		virtual void output_name(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_ArgName_base

		// internal operations
		// constructor
		gg_datatype_ArgName_type1(compact_string const &argId);
};

class gg_datatype_ArgName_type2 : public gg_datatype_ArgName_base
{
	public:
		// abstract syntax tree representation
		int64_t subtree_argNo;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_ArgName_base
		virtual void output_name(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_ArgName_base

		// internal operations
		// constructor
		gg_datatype_ArgName_type2(int64_t const &argNo);
};


#endif

