
#include <algorithm>

#include "heading.h"
#include "generalized-filters.h"
#include "macros.h"
#include "assignment-manager.h"

static int64_t lastAvailableUniqueId = 1;

static unordered_map<compact_string, unordered_map<compact_string, int64_t, compact_string_hash>, compact_string_hash> nameToIntegerMap;
static unordered_map<compact_string, vector<compact_string>, compact_string_hash> integerToNameMap;

int64_t mapToInt(compact_string category, compact_string name)
{
	auto categoryIt = nameToIntegerMap.find(category);
	if (categoryIt == nameToIntegerMap.end())
	{
		nameToIntegerMap[category] = unordered_map<compact_string, int64_t, compact_string_hash>();
		integerToNameMap[category] = vector<compact_string>();
		categoryIt = nameToIntegerMap.find(category);
	}

	auto nameIt = categoryIt->second.find(name);
	if (nameIt != categoryIt->second.end())
		return nameIt->second;

	int64_t result = categoryIt->second.size() + 1;
	categoryIt->second[name] = result;
	integerToNameMap[category].push_back(name);
	return result;
}

compact_string mapFromInt(compact_string category, int64_t nameId)
{
	auto categoryIt = integerToNameMap.find(category);

	assert(categoryIt != integerToNameMap.end());
	assert(nameId >= 1);
	assert(size_t(nameId) <= categoryIt->second.size());

	return categoryIt->second[nameId - 1];
}

gg_node::gg_node()
{
	uniqueId = lastAvailableUniqueId;
	lastAvailableUniqueId++;
}


bool gg_datatype_Spec_type1::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_74 = compact_string::make_from("cfe");
	rel_algebra_node temp_90 = rel_algebra::trueTable();
	compact_string temp_76 = compact_string::make_from("arguments");
	rel_algebra_node temp_77 = database[temp_76];
	temp_90 = rel_algebra::join(temp_90, temp_77);
	rel_algebra_node temp_89 = rel_algebra::trueTable();
	compact_string temp_78 = compact_string::make_from("cfe");
	rel_algebra_node temp_79 = database[temp_78];
	temp_89 = rel_algebra::join(temp_89, rel_algebra::complement(temp_79));
	rel_algebra_node temp_80 = local_attacks01;
	rel_algebra_node temp_81 = local_attacks10;
	compact_string temp_82 = compact_string::make_from("cte");
	rel_algebra_node temp_83 = database[temp_82];
	compact_string temp_84 = compact_string::make_from("cfd");
	rel_algebra_node temp_85 = database[temp_84];
	rel_algebra_node temp_88 = macro_completion_cfe_bound(temp_80, temp_81, temp_83, temp_85);
	temp_89 = rel_algebra::join(temp_89, rel_algebra::complement(temp_88));
	temp_89 = rel_algebra::complement(temp_89);
	temp_90 = rel_algebra::join(temp_90, temp_89);
	result = result || (database[temp_74] != temp_90);
	set_database_atom(temp_74, temp_90);

	compact_string temp_92 = compact_string::make_from("cte");
	rel_algebra_node temp_111 = rel_algebra::trueTable();
	compact_string temp_94 = compact_string::make_from("arguments");
	rel_algebra_node temp_95 = database[temp_94];
	temp_111 = rel_algebra::join(temp_111, temp_95);
	rel_algebra_node temp_110 = rel_algebra::trueTable();
	compact_string temp_96 = compact_string::make_from("cte");
	rel_algebra_node temp_97 = database[temp_96];
	temp_110 = rel_algebra::join(temp_110, rel_algebra::complement(temp_97));
	compact_string temp_98 = compact_string::make_from("arguments");
	rel_algebra_node temp_99 = database[temp_98];
	rel_algebra_node temp_100 = local_args02;
	rel_algebra_node temp_101 = local_attacks10;
	rel_algebra_node temp_102 = local_attacks21;
	compact_string temp_103 = compact_string::make_from("cfe");
	rel_algebra_node temp_104 = database[temp_103];
	compact_string temp_105 = compact_string::make_from("ctd");
	rel_algebra_node temp_106 = database[temp_105];
	rel_algebra_node temp_109 = macro_completion_cte_bound(temp_99, temp_100, temp_101, temp_102, temp_104, temp_106);
	temp_110 = rel_algebra::join(temp_110, rel_algebra::complement(temp_109));
	temp_110 = rel_algebra::complement(temp_110);
	temp_111 = rel_algebra::join(temp_111, temp_110);
	result = result || (database[temp_92] != temp_111);
	set_database_atom(temp_92, temp_111);

	compact_string temp_113 = compact_string::make_from("cfd");
	rel_algebra_node temp_132 = rel_algebra::trueTable();
	compact_string temp_115 = compact_string::make_from("arguments");
	rel_algebra_node temp_116 = database[temp_115];
	temp_132 = rel_algebra::join(temp_132, temp_116);
	rel_algebra_node temp_131 = rel_algebra::trueTable();
	compact_string temp_117 = compact_string::make_from("cfd");
	rel_algebra_node temp_118 = database[temp_117];
	temp_131 = rel_algebra::join(temp_131, rel_algebra::complement(temp_118));
	compact_string temp_119 = compact_string::make_from("arguments");
	rel_algebra_node temp_120 = database[temp_119];
	rel_algebra_node temp_121 = local_args02;
	rel_algebra_node temp_122 = local_attacks10;
	rel_algebra_node temp_123 = local_attacks21;
	compact_string temp_124 = compact_string::make_from("cfe");
	rel_algebra_node temp_125 = database[temp_124];
	compact_string temp_126 = compact_string::make_from("ctd");
	rel_algebra_node temp_127 = database[temp_126];
	rel_algebra_node temp_130 = macro_completion_cfd_bound(temp_120, temp_121, temp_122, temp_123, temp_125, temp_127);
	temp_131 = rel_algebra::join(temp_131, rel_algebra::complement(temp_130));
	temp_131 = rel_algebra::complement(temp_131);
	temp_132 = rel_algebra::join(temp_132, temp_131);
	result = result || (database[temp_113] != temp_132);
	set_database_atom(temp_113, temp_132);

	compact_string temp_134 = compact_string::make_from("ctd");
	rel_algebra_node temp_148 = rel_algebra::trueTable();
	compact_string temp_136 = compact_string::make_from("arguments");
	rel_algebra_node temp_137 = database[temp_136];
	temp_148 = rel_algebra::join(temp_148, temp_137);
	rel_algebra_node temp_147 = rel_algebra::trueTable();
	compact_string temp_138 = compact_string::make_from("ctd");
	rel_algebra_node temp_139 = database[temp_138];
	temp_147 = rel_algebra::join(temp_147, rel_algebra::complement(temp_139));
	rel_algebra_node temp_140 = local_attacks01;
	rel_algebra_node temp_141 = local_attacks10;
	compact_string temp_142 = compact_string::make_from("cte");
	rel_algebra_node temp_143 = database[temp_142];
	rel_algebra_node temp_146 = macro_completion_ctd_bound(temp_140, temp_141, temp_143);
	temp_147 = rel_algebra::join(temp_147, rel_algebra::complement(temp_146));
	temp_147 = rel_algebra::complement(temp_147);
	temp_148 = rel_algebra::join(temp_148, temp_147);
	result = result || (database[temp_134] != temp_148);
	set_database_atom(temp_134, temp_148);

	return result;
}

bool gg_datatype_Spec_type1::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_156 = rel_algebra::trueTable();
	compact_string temp_151 = compact_string::make_from("arguments");
	rel_algebra_node temp_152 = database[temp_151];
	temp_156 = rel_algebra::join(temp_156, temp_152);
	compact_string temp_153 = compact_string::make_from("cfe");
	rel_algebra_node temp_154 = database[temp_153];
	rel_algebra_node temp_155 = rel_algebra::complement(temp_154);
	temp_156 = rel_algebra::join(temp_156, temp_155);
	int64_t temp_157 = 1;
	rel_algebra_node temp_161 = macro_unaryTranslator(temp_156, temp_157);
	local_eDicTU = temp_161;

	rel_algebra_node temp_171 = rel_algebra::trueTable();
	compact_string temp_163 = compact_string::make_from("arguments");
	rel_algebra_node temp_164 = database[temp_163];
	temp_171 = rel_algebra::join(temp_171, temp_164);
	compact_string temp_165 = compact_string::make_from("cfd");
	rel_algebra_node temp_166 = database[temp_165];
	rel_algebra_node temp_167 = rel_algebra::complement(temp_166);
	temp_171 = rel_algebra::join(temp_171, temp_167);
	compact_string temp_168 = compact_string::make_from("ctd");
	rel_algebra_node temp_169 = database[temp_168];
	rel_algebra_node temp_170 = rel_algebra::complement(temp_169);
	temp_171 = rel_algebra::join(temp_171, temp_170);
	int64_t temp_192 = std::numeric_limits<ValueType>::min();
	int64_t temp_172 = 1;
	temp_192 = std::max(temp_192, temp_172);
	rel_algebra_node temp_179 = rel_algebra::trueTable();
	int64_t temp_177 = 0;
	int64_t temp_178 = 0;
	rel_algebra_node temp_183 = rel_algebra::filterLessThanOrEqualTo(temp_177, temp_178, temp_179);
	rel_algebra_node temp_184 = local_eDicTU;
	rel_algebra_node temp_187 = rel_algebra::complement(rel_algebra::divide(temp_183, rel_algebra::complement(temp_184)));
	int64_t temp_190 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_187); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_174 = 0;
		int64_t temp_176 = local_X[temp_174];
		temp_190 = std::max(temp_190, temp_176);
	}
	temp_192 = std::max(temp_192, temp_190);
	rel_algebra_node temp_196 = macro_unaryTranslator(temp_171, temp_192);
	local_dDicU = temp_196;

	int64_t temp_198 = 1;
	int64_t temp_200 = 0;
	rel_algebra_node temp_204 = rel_algebra::trueTable();
	int64_t temp_202 = 0;
	int64_t temp_203 = 0;
	rel_algebra_node temp_208 = rel_algebra::filterGreaterThan(temp_202, temp_203, temp_204);
	rel_algebra_node temp_209 = local_eDicTU;
	rel_algebra_node temp_212 = rel_algebra::complement(rel_algebra::divide(temp_208, rel_algebra::complement(temp_209)));
	rel_algebra_node temp_217 = generalized_filter_rename(temp_198, temp_200)(temp_212);
	local_eDic0to2 = temp_217;

	int64_t temp_219 = 2;
	int64_t temp_221 = 3;
	rel_algebra_node temp_225 = rel_algebra::trueTable();
	int64_t temp_223 = 0;
	int64_t temp_224 = 0;
	rel_algebra_node temp_229 = rel_algebra::filterGreaterThan(temp_223, temp_224, temp_225);
	rel_algebra_node temp_230 = local_eDicTU;
	rel_algebra_node temp_233 = rel_algebra::complement(rel_algebra::divide(temp_229, rel_algebra::complement(temp_230)));
	rel_algebra_node temp_238 = generalized_filter_rename(temp_219, temp_221)(temp_233);
	local_eDic1to3 = temp_238;

	int64_t temp_240 = 1;
	int64_t temp_242 = 0;
	rel_algebra_node temp_246 = rel_algebra::trueTable();
	int64_t temp_244 = 0;
	int64_t temp_245 = 0;
	rel_algebra_node temp_250 = rel_algebra::filterGreaterThan(temp_244, temp_245, temp_246);
	rel_algebra_node temp_251 = local_dDicU;
	rel_algebra_node temp_254 = rel_algebra::complement(rel_algebra::divide(temp_250, rel_algebra::complement(temp_251)));
	rel_algebra_node temp_259 = generalized_filter_rename(temp_240, temp_242)(temp_254);
	local_dDic0to2 = temp_259;

	int64_t temp_261 = 2;
	int64_t temp_263 = 3;
	rel_algebra_node temp_267 = rel_algebra::trueTable();
	int64_t temp_265 = 0;
	int64_t temp_266 = 0;
	rel_algebra_node temp_271 = rel_algebra::filterGreaterThan(temp_265, temp_266, temp_267);
	rel_algebra_node temp_272 = local_dDicU;
	rel_algebra_node temp_275 = rel_algebra::complement(rel_algebra::divide(temp_271, rel_algebra::complement(temp_272)));
	rel_algebra_node temp_280 = generalized_filter_rename(temp_261, temp_263)(temp_275);
	local_dDic1to3 = temp_280;

	auto temp_299 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_282 = 1;
			int64_t temp_283 = param_1;
			int64_t temp_284 = temp_282 + temp_283;
			return temp_284;
		};
	int64_t temp_285 = 0;
	int64_t temp_300 = temp_285;
	rel_algebra_node temp_295 = rel_algebra::trueTable();
	compact_string temp_287 = compact_string::make_from("arguments");
	rel_algebra_node temp_288 = database[temp_287];
	temp_295 = rel_algebra::join(temp_295, temp_288);
	compact_string temp_289 = compact_string::make_from("ctd");
	rel_algebra_node temp_290 = database[temp_289];
	rel_algebra_node temp_291 = rel_algebra::complement(temp_290);
	temp_295 = rel_algebra::join(temp_295, temp_291);
	compact_string temp_292 = compact_string::make_from("cfd");
	rel_algebra_node temp_293 = database[temp_292];
	rel_algebra_node temp_294 = rel_algebra::complement(temp_293);
	temp_295 = rel_algebra::join(temp_295, temp_294);
	for (auto local_X = rel_algebra::getUnitIterator(temp_295); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_286 = 0;
		temp_300 = temp_299(temp_300, temp_286);
	}
	local_dTupleUCount = temp_300;

	auto temp_319 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_302 = 1;
			int64_t temp_303 = param_1;
			int64_t temp_304 = temp_302 + temp_303;
			return temp_304;
		};
	int64_t temp_305 = 0;
	int64_t temp_320 = temp_305;
	rel_algebra_node temp_315 = rel_algebra::trueTable();
	compact_string temp_307 = compact_string::make_from("arguments");
	rel_algebra_node temp_308 = database[temp_307];
	temp_315 = rel_algebra::join(temp_315, temp_308);
	compact_string temp_309 = compact_string::make_from("cte");
	rel_algebra_node temp_310 = database[temp_309];
	rel_algebra_node temp_311 = rel_algebra::complement(temp_310);
	temp_315 = rel_algebra::join(temp_315, temp_311);
	compact_string temp_312 = compact_string::make_from("cfe");
	rel_algebra_node temp_313 = database[temp_312];
	rel_algebra_node temp_314 = rel_algebra::complement(temp_313);
	temp_315 = rel_algebra::join(temp_315, temp_314);
	for (auto local_X = rel_algebra::getUnitIterator(temp_315); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_306 = 0;
		temp_320 = temp_319(temp_320, temp_306);
	}
	local_eTupleUCount = temp_320;

	auto temp_332 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_322 = 1;
			int64_t temp_323 = param_1;
			int64_t temp_324 = temp_322 + temp_323;
			return temp_324;
		};
	int64_t temp_325 = 0;
	int64_t temp_333 = temp_325;
	compact_string temp_327 = compact_string::make_from("cte");
	rel_algebra_node temp_328 = database[temp_327];
	for (auto local_X = rel_algebra::getUnitIterator(temp_328); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_326 = 0;
		temp_333 = temp_332(temp_333, temp_326);
	}
	local_eTupleTCount = temp_333;

	int64_t temp_335 = local_dTupleUCount;
	int64_t temp_336 = local_eTupleUCount;
	int64_t temp_337 = temp_335 + temp_336;
	int64_t temp_338 = local_eTupleTCount;
	int64_t temp_339 = temp_337 + temp_338;
	local_totalVarCount = temp_339;

	return result;
}

void gg_datatype_Spec_type1::output_grounder(ostream &os) const
{
	rel_algebra_node temp_354 = rel_algebra::trueTable();
	rel_algebra_node temp_348 = rel_algebra::trueTable();
	compact_string temp_344 = compact_string::make_from("cte");
	rel_algebra_node temp_345 = database[temp_344];
	temp_348 = rel_algebra::join(temp_348, temp_345);
	compact_string temp_346 = compact_string::make_from("cfe");
	rel_algebra_node temp_347 = database[temp_346];
	temp_348 = rel_algebra::join(temp_348, temp_347);
	temp_354 = rel_algebra::join(temp_354, rel_algebra::complement(temp_348));
	rel_algebra_node temp_353 = rel_algebra::trueTable();
	compact_string temp_349 = compact_string::make_from("ctd");
	rel_algebra_node temp_350 = database[temp_349];
	temp_353 = rel_algebra::join(temp_353, temp_350);
	compact_string temp_351 = compact_string::make_from("cfd");
	rel_algebra_node temp_352 = database[temp_351];
	temp_353 = rel_algebra::join(temp_353, temp_352);
	temp_354 = rel_algebra::join(temp_354, rel_algebra::complement(temp_353));
	temp_354 = rel_algebra::complement(temp_354);
	if ((!rel_algebra::isEmpty(temp_354)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_361 = local_totalVarCount;
		os << temp_361;
		os << " 10\n";
		rel_algebra_node temp_384 = local_eDic0to2;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_384); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_367 = 2;
			int64_t temp_369 = local_tuple[temp_367];
			os << temp_369;
			os << " ";
			compact_string temp_374 = compact_string::make_from("arguments");
			int64_t temp_375 = 0;
			int64_t temp_377 = local_tuple[temp_375];
			os << mapFromInt(temp_374, temp_377);
			os << "\n";
		}
		compact_string temp_389 = compact_string::make_from("arguments");
		rel_algebra_node temp_390 = database[temp_389];
		rel_algebra_node temp_391 = local_attacks01;
		rel_algebra_node temp_392 = local_attacks10;
		compact_string temp_393 = compact_string::make_from("cfe");
		rel_algebra_node temp_394 = database[temp_393];
		compact_string temp_395 = compact_string::make_from("cte");
		rel_algebra_node temp_396 = database[temp_395];
		compact_string temp_397 = compact_string::make_from("cfd");
		rel_algebra_node temp_398 = database[temp_397];
		compact_string temp_399 = compact_string::make_from("ctd");
		rel_algebra_node temp_400 = database[temp_399];
		rel_algebra_node temp_401 = local_eDic0to2;
		rel_algebra_node temp_402 = local_eDic1to3;
		rel_algebra_node temp_403 = local_dDic0to2;
		rel_algebra_node temp_404 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_390, temp_391, temp_392, temp_394, temp_396, temp_398, temp_400, temp_401, temp_402, temp_403, temp_404);
	}
}

string gg_datatype_Spec_type1::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "complete";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type1::gg_datatype_Spec_type1(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_10 = compact_string::make_from("cfe");
	rel_algebra_node temp_13 = subtree_r->local_cf;
	set_database_atom(temp_10, temp_13);

	compact_string temp_15 = compact_string::make_from("cte");
	rel_algebra_node temp_18 = subtree_r->local_ct;
	set_database_atom(temp_15, temp_18);

	compact_string temp_20 = compact_string::make_from("cfd");
	rel_algebra_node temp_22 = rel_algebra::trueTable();
	temp_22 = rel_algebra::complement(temp_22);
	set_database_atom(temp_20, temp_22);

	compact_string temp_24 = compact_string::make_from("ctd");
	rel_algebra_node temp_26 = rel_algebra::trueTable();
	temp_26 = rel_algebra::complement(temp_26);
	set_database_atom(temp_24, temp_26);

	compact_string temp_28 = compact_string::make_from("attacks");
	rel_algebra_node temp_29 = database[temp_28];
	local_attacks01 = temp_29;

	int64_t temp_31 = 0;
	int64_t temp_33 = 2;
	rel_algebra_node temp_35 = local_attacks01;
	rel_algebra_node temp_40 = generalized_filter_rename(temp_31, temp_33)(temp_35);
	local_attacks21 = temp_40;

	int64_t temp_42 = 2;
	int64_t temp_44 = 1;
	int64_t temp_46 = 1;
	int64_t temp_48 = 0;
	rel_algebra_node temp_50 = local_attacks21;
	rel_algebra_node temp_55 = generalized_filter_rename(temp_46, temp_48)(temp_50);
	rel_algebra_node temp_60 = generalized_filter_rename(temp_42, temp_44)(temp_55);
	local_attacks10 = temp_60;

	int64_t temp_62 = 0;
	int64_t temp_64 = 2;
	compact_string temp_66 = compact_string::make_from("arguments");
	rel_algebra_node temp_67 = database[temp_66];
	rel_algebra_node temp_72 = generalized_filter_equals(temp_62, temp_64)(temp_67);
	local_args02 = temp_72;
}

bool gg_datatype_Spec_type2::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_491 = compact_string::make_from("cfe");
	rel_algebra_node temp_507 = rel_algebra::trueTable();
	compact_string temp_493 = compact_string::make_from("arguments");
	rel_algebra_node temp_494 = database[temp_493];
	temp_507 = rel_algebra::join(temp_507, temp_494);
	rel_algebra_node temp_506 = rel_algebra::trueTable();
	compact_string temp_495 = compact_string::make_from("cfe");
	rel_algebra_node temp_496 = database[temp_495];
	temp_506 = rel_algebra::join(temp_506, rel_algebra::complement(temp_496));
	rel_algebra_node temp_497 = local_attacks01;
	rel_algebra_node temp_498 = local_attacks10;
	compact_string temp_499 = compact_string::make_from("cte");
	rel_algebra_node temp_500 = database[temp_499];
	compact_string temp_501 = compact_string::make_from("cfd");
	rel_algebra_node temp_502 = database[temp_501];
	rel_algebra_node temp_505 = macro_completion_cfe_bound(temp_497, temp_498, temp_500, temp_502);
	temp_506 = rel_algebra::join(temp_506, rel_algebra::complement(temp_505));
	temp_506 = rel_algebra::complement(temp_506);
	temp_507 = rel_algebra::join(temp_507, temp_506);
	result = result || (database[temp_491] != temp_507);
	set_database_atom(temp_491, temp_507);

	compact_string temp_509 = compact_string::make_from("cte");
	rel_algebra_node temp_528 = rel_algebra::trueTable();
	compact_string temp_511 = compact_string::make_from("arguments");
	rel_algebra_node temp_512 = database[temp_511];
	temp_528 = rel_algebra::join(temp_528, temp_512);
	rel_algebra_node temp_527 = rel_algebra::trueTable();
	compact_string temp_513 = compact_string::make_from("cte");
	rel_algebra_node temp_514 = database[temp_513];
	temp_527 = rel_algebra::join(temp_527, rel_algebra::complement(temp_514));
	compact_string temp_515 = compact_string::make_from("arguments");
	rel_algebra_node temp_516 = database[temp_515];
	rel_algebra_node temp_517 = local_args02;
	rel_algebra_node temp_518 = local_attacks10;
	rel_algebra_node temp_519 = local_attacks21;
	compact_string temp_520 = compact_string::make_from("cfe");
	rel_algebra_node temp_521 = database[temp_520];
	compact_string temp_522 = compact_string::make_from("ctd");
	rel_algebra_node temp_523 = database[temp_522];
	rel_algebra_node temp_526 = macro_completion_cte_bound(temp_516, temp_517, temp_518, temp_519, temp_521, temp_523);
	temp_527 = rel_algebra::join(temp_527, rel_algebra::complement(temp_526));
	temp_527 = rel_algebra::complement(temp_527);
	temp_528 = rel_algebra::join(temp_528, temp_527);
	result = result || (database[temp_509] != temp_528);
	set_database_atom(temp_509, temp_528);

	compact_string temp_530 = compact_string::make_from("cfd");
	rel_algebra_node temp_549 = rel_algebra::trueTable();
	compact_string temp_532 = compact_string::make_from("arguments");
	rel_algebra_node temp_533 = database[temp_532];
	temp_549 = rel_algebra::join(temp_549, temp_533);
	rel_algebra_node temp_548 = rel_algebra::trueTable();
	compact_string temp_534 = compact_string::make_from("cfd");
	rel_algebra_node temp_535 = database[temp_534];
	temp_548 = rel_algebra::join(temp_548, rel_algebra::complement(temp_535));
	compact_string temp_536 = compact_string::make_from("arguments");
	rel_algebra_node temp_537 = database[temp_536];
	rel_algebra_node temp_538 = local_args02;
	rel_algebra_node temp_539 = local_attacks10;
	rel_algebra_node temp_540 = local_attacks21;
	compact_string temp_541 = compact_string::make_from("cfe");
	rel_algebra_node temp_542 = database[temp_541];
	compact_string temp_543 = compact_string::make_from("ctd");
	rel_algebra_node temp_544 = database[temp_543];
	rel_algebra_node temp_547 = macro_completion_cfd_bound(temp_537, temp_538, temp_539, temp_540, temp_542, temp_544);
	temp_548 = rel_algebra::join(temp_548, rel_algebra::complement(temp_547));
	temp_548 = rel_algebra::complement(temp_548);
	temp_549 = rel_algebra::join(temp_549, temp_548);
	result = result || (database[temp_530] != temp_549);
	set_database_atom(temp_530, temp_549);

	compact_string temp_551 = compact_string::make_from("ctd");
	rel_algebra_node temp_565 = rel_algebra::trueTable();
	compact_string temp_553 = compact_string::make_from("arguments");
	rel_algebra_node temp_554 = database[temp_553];
	temp_565 = rel_algebra::join(temp_565, temp_554);
	rel_algebra_node temp_564 = rel_algebra::trueTable();
	compact_string temp_555 = compact_string::make_from("ctd");
	rel_algebra_node temp_556 = database[temp_555];
	temp_564 = rel_algebra::join(temp_564, rel_algebra::complement(temp_556));
	rel_algebra_node temp_557 = local_attacks01;
	rel_algebra_node temp_558 = local_attacks10;
	compact_string temp_559 = compact_string::make_from("cte");
	rel_algebra_node temp_560 = database[temp_559];
	rel_algebra_node temp_563 = macro_completion_ctd_bound(temp_557, temp_558, temp_560);
	temp_564 = rel_algebra::join(temp_564, rel_algebra::complement(temp_563));
	temp_564 = rel_algebra::complement(temp_564);
	temp_565 = rel_algebra::join(temp_565, temp_564);
	result = result || (database[temp_551] != temp_565);
	set_database_atom(temp_551, temp_565);

	return result;
}

bool gg_datatype_Spec_type2::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_576 = rel_algebra::trueTable();
	compact_string temp_568 = compact_string::make_from("arguments");
	rel_algebra_node temp_569 = database[temp_568];
	temp_576 = rel_algebra::join(temp_576, temp_569);
	compact_string temp_570 = compact_string::make_from("cfe");
	rel_algebra_node temp_571 = database[temp_570];
	rel_algebra_node temp_572 = rel_algebra::complement(temp_571);
	temp_576 = rel_algebra::join(temp_576, temp_572);
	compact_string temp_573 = compact_string::make_from("cte");
	rel_algebra_node temp_574 = database[temp_573];
	rel_algebra_node temp_575 = rel_algebra::complement(temp_574);
	temp_576 = rel_algebra::join(temp_576, temp_575);
	int64_t temp_577 = 1;
	rel_algebra_node temp_581 = macro_unaryTranslator(temp_576, temp_577);
	local_eDicU = temp_581;

	int64_t temp_603 = std::numeric_limits<ValueType>::min();
	int64_t temp_583 = 1;
	temp_603 = std::max(temp_603, temp_583);
	rel_algebra_node temp_590 = rel_algebra::trueTable();
	int64_t temp_588 = 0;
	int64_t temp_589 = 0;
	rel_algebra_node temp_594 = rel_algebra::filterLessThanOrEqualTo(temp_588, temp_589, temp_590);
	rel_algebra_node temp_595 = local_eDicU;
	rel_algebra_node temp_598 = rel_algebra::complement(rel_algebra::divide(temp_594, rel_algebra::complement(temp_595)));
	int64_t temp_601 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_598); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_585 = 0;
		int64_t temp_587 = local_X[temp_585];
		temp_601 = std::max(temp_601, temp_587);
	}
	temp_603 = std::max(temp_603, temp_601);
	local_afterEDicU = temp_603;

	compact_string temp_605 = compact_string::make_from("cte");
	rel_algebra_node temp_606 = database[temp_605];
	int64_t temp_607 = local_afterEDicU;
	rel_algebra_node temp_611 = macro_unaryTranslator(temp_606, temp_607);
	local_eDicT = temp_611;

	rel_algebra_node temp_615 = rel_algebra::trueTable();
	rel_algebra_node temp_613 = local_eDicU;
	temp_615 = rel_algebra::join(temp_615, rel_algebra::complement(temp_613));
	rel_algebra_node temp_614 = local_eDicT;
	temp_615 = rel_algebra::join(temp_615, rel_algebra::complement(temp_614));
	temp_615 = rel_algebra::complement(temp_615);
	local_eDicTU = temp_615;

	int64_t temp_637 = std::numeric_limits<ValueType>::min();
	int64_t temp_617 = local_afterEDicU;
	temp_637 = std::max(temp_637, temp_617);
	rel_algebra_node temp_624 = rel_algebra::trueTable();
	int64_t temp_622 = 0;
	int64_t temp_623 = 0;
	rel_algebra_node temp_628 = rel_algebra::filterLessThanOrEqualTo(temp_622, temp_623, temp_624);
	rel_algebra_node temp_629 = local_eDicTU;
	rel_algebra_node temp_632 = rel_algebra::complement(rel_algebra::divide(temp_628, rel_algebra::complement(temp_629)));
	int64_t temp_635 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_632); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_619 = 0;
		int64_t temp_621 = local_X[temp_619];
		temp_635 = std::max(temp_635, temp_621);
	}
	temp_637 = std::max(temp_637, temp_635);
	local_afterEDicTU = temp_637;

	rel_algebra_node temp_647 = rel_algebra::trueTable();
	compact_string temp_639 = compact_string::make_from("arguments");
	rel_algebra_node temp_640 = database[temp_639];
	temp_647 = rel_algebra::join(temp_647, temp_640);
	compact_string temp_641 = compact_string::make_from("cfd");
	rel_algebra_node temp_642 = database[temp_641];
	rel_algebra_node temp_643 = rel_algebra::complement(temp_642);
	temp_647 = rel_algebra::join(temp_647, temp_643);
	compact_string temp_644 = compact_string::make_from("ctd");
	rel_algebra_node temp_645 = database[temp_644];
	rel_algebra_node temp_646 = rel_algebra::complement(temp_645);
	temp_647 = rel_algebra::join(temp_647, temp_646);
	int64_t temp_648 = local_afterEDicTU;
	rel_algebra_node temp_652 = macro_unaryTranslator(temp_647, temp_648);
	local_dDicU = temp_652;

	int64_t temp_654 = 1;
	int64_t temp_656 = 0;
	rel_algebra_node temp_660 = rel_algebra::trueTable();
	int64_t temp_658 = 0;
	int64_t temp_659 = 0;
	rel_algebra_node temp_664 = rel_algebra::filterGreaterThan(temp_658, temp_659, temp_660);
	rel_algebra_node temp_665 = local_eDicTU;
	rel_algebra_node temp_668 = rel_algebra::complement(rel_algebra::divide(temp_664, rel_algebra::complement(temp_665)));
	rel_algebra_node temp_673 = generalized_filter_rename(temp_654, temp_656)(temp_668);
	local_eDic0to2 = temp_673;

	int64_t temp_675 = 2;
	int64_t temp_677 = 3;
	rel_algebra_node temp_681 = rel_algebra::trueTable();
	int64_t temp_679 = 0;
	int64_t temp_680 = 0;
	rel_algebra_node temp_685 = rel_algebra::filterGreaterThan(temp_679, temp_680, temp_681);
	rel_algebra_node temp_686 = local_eDicTU;
	rel_algebra_node temp_689 = rel_algebra::complement(rel_algebra::divide(temp_685, rel_algebra::complement(temp_686)));
	rel_algebra_node temp_694 = generalized_filter_rename(temp_675, temp_677)(temp_689);
	local_eDic1to3 = temp_694;

	int64_t temp_696 = 1;
	int64_t temp_698 = 0;
	rel_algebra_node temp_702 = rel_algebra::trueTable();
	int64_t temp_700 = 0;
	int64_t temp_701 = 0;
	rel_algebra_node temp_706 = rel_algebra::filterGreaterThan(temp_700, temp_701, temp_702);
	rel_algebra_node temp_707 = local_dDicU;
	rel_algebra_node temp_710 = rel_algebra::complement(rel_algebra::divide(temp_706, rel_algebra::complement(temp_707)));
	rel_algebra_node temp_715 = generalized_filter_rename(temp_696, temp_698)(temp_710);
	local_dDic0to2 = temp_715;

	int64_t temp_717 = 2;
	int64_t temp_719 = 3;
	rel_algebra_node temp_723 = rel_algebra::trueTable();
	int64_t temp_721 = 0;
	int64_t temp_722 = 0;
	rel_algebra_node temp_727 = rel_algebra::filterGreaterThan(temp_721, temp_722, temp_723);
	rel_algebra_node temp_728 = local_dDicU;
	rel_algebra_node temp_731 = rel_algebra::complement(rel_algebra::divide(temp_727, rel_algebra::complement(temp_728)));
	rel_algebra_node temp_736 = generalized_filter_rename(temp_717, temp_719)(temp_731);
	local_dDic1to3 = temp_736;

	auto temp_747 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_738 = 1;
			int64_t temp_739 = param_1;
			int64_t temp_740 = temp_738 + temp_739;
			return temp_740;
		};
	int64_t temp_741 = 0;
	int64_t temp_748 = temp_741;
	rel_algebra_node temp_743 = local_dDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_743); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_742 = 0;
		temp_748 = temp_747(temp_748, temp_742);
	}
	local_dTupleUCount = temp_748;

	auto temp_759 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_750 = 1;
			int64_t temp_751 = param_1;
			int64_t temp_752 = temp_750 + temp_751;
			return temp_752;
		};
	int64_t temp_753 = 0;
	int64_t temp_760 = temp_753;
	rel_algebra_node temp_755 = local_eDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_755); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_754 = 0;
		temp_760 = temp_759(temp_760, temp_754);
	}
	local_eTupleUCount = temp_760;

	auto temp_772 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_762 = 1;
			int64_t temp_763 = param_1;
			int64_t temp_764 = temp_762 + temp_763;
			return temp_764;
		};
	int64_t temp_765 = 0;
	int64_t temp_773 = temp_765;
	compact_string temp_767 = compact_string::make_from("cte");
	rel_algebra_node temp_768 = database[temp_767];
	for (auto local_X = rel_algebra::getUnitIterator(temp_768); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_766 = 0;
		temp_773 = temp_772(temp_773, temp_766);
	}
	local_eTupleTCount = temp_773;

	int64_t temp_775 = local_dTupleUCount;
	int64_t temp_776 = local_eTupleUCount;
	int64_t temp_777 = temp_775 + temp_776;
	int64_t temp_778 = local_eTupleTCount;
	int64_t temp_779 = temp_777 + temp_778;
	local_totalVarCount = temp_779;

	return result;
}

void gg_datatype_Spec_type2::output_grounder(ostream &os) const
{
	rel_algebra_node temp_794 = rel_algebra::trueTable();
	rel_algebra_node temp_788 = rel_algebra::trueTable();
	compact_string temp_784 = compact_string::make_from("cte");
	rel_algebra_node temp_785 = database[temp_784];
	temp_788 = rel_algebra::join(temp_788, temp_785);
	compact_string temp_786 = compact_string::make_from("cfe");
	rel_algebra_node temp_787 = database[temp_786];
	temp_788 = rel_algebra::join(temp_788, temp_787);
	temp_794 = rel_algebra::join(temp_794, rel_algebra::complement(temp_788));
	rel_algebra_node temp_793 = rel_algebra::trueTable();
	compact_string temp_789 = compact_string::make_from("ctd");
	rel_algebra_node temp_790 = database[temp_789];
	temp_793 = rel_algebra::join(temp_793, temp_790);
	compact_string temp_791 = compact_string::make_from("cfd");
	rel_algebra_node temp_792 = database[temp_791];
	temp_793 = rel_algebra::join(temp_793, temp_792);
	temp_794 = rel_algebra::join(temp_794, rel_algebra::complement(temp_793));
	temp_794 = rel_algebra::complement(temp_794);
	if ((!rel_algebra::isEmpty(temp_794)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_801 = local_totalVarCount;
		os << temp_801;
		os << " 10\n";
		rel_algebra_node temp_824 = local_eDic0to2;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_824); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_807 = 2;
			int64_t temp_809 = local_tuple[temp_807];
			os << temp_809;
			os << " ";
			compact_string temp_814 = compact_string::make_from("arguments");
			int64_t temp_815 = 0;
			int64_t temp_817 = local_tuple[temp_815];
			os << mapFromInt(temp_814, temp_817);
			os << "\n";
		}
		compact_string temp_829 = compact_string::make_from("arguments");
		rel_algebra_node temp_830 = database[temp_829];
		rel_algebra_node temp_831 = local_attacks01;
		rel_algebra_node temp_832 = local_attacks10;
		compact_string temp_833 = compact_string::make_from("cfe");
		rel_algebra_node temp_834 = database[temp_833];
		compact_string temp_835 = compact_string::make_from("cte");
		rel_algebra_node temp_836 = database[temp_835];
		compact_string temp_837 = compact_string::make_from("cfd");
		rel_algebra_node temp_838 = database[temp_837];
		compact_string temp_839 = compact_string::make_from("ctd");
		rel_algebra_node temp_840 = database[temp_839];
		rel_algebra_node temp_841 = local_eDic0to2;
		rel_algebra_node temp_842 = local_eDic1to3;
		rel_algebra_node temp_843 = local_dDic0to2;
		rel_algebra_node temp_844 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_830, temp_831, temp_832, temp_834, temp_836, temp_838, temp_840, temp_841, temp_842, temp_843, temp_844);
		os << "module ";
		int64_t temp_851 = 2;
		int64_t temp_852 = local_eTupleUCount;
		int64_t temp_853 = temp_851 * temp_852;
		int64_t temp_854 = local_totalVarCount;
		int64_t temp_855 = temp_853 + temp_854;
		os << temp_855;
		os << " ";
		int64_t temp_860 = local_eTupleUCount;
		os << temp_860;
		rel_algebra_node temp_871 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_871); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_864 = local_totalVarCount;
			int64_t temp_865 = 2;
			int64_t temp_867 = local_tuple[temp_865];
			int64_t temp_868 = temp_864 + temp_867;
			os << temp_868;
		}
		os << "\n";
		compact_string temp_878 = compact_string::make_from("arguments");
		rel_algebra_node temp_879 = database[temp_878];
		rel_algebra_node temp_880 = local_attacks01;
		rel_algebra_node temp_881 = local_attacks10;
		compact_string temp_882 = compact_string::make_from("cfe");
		rel_algebra_node temp_883 = database[temp_882];
		compact_string temp_884 = compact_string::make_from("cte");
		rel_algebra_node temp_885 = database[temp_884];
		compact_string temp_886 = compact_string::make_from("cfd");
		rel_algebra_node temp_887 = database[temp_886];
		compact_string temp_888 = compact_string::make_from("ctd");
		rel_algebra_node temp_889 = database[temp_888];
		rel_algebra_node temp_890 = local_eDic0to2;
		rel_algebra_node temp_891 = local_eDic1to3;
		rel_algebra_node temp_892 = local_dDic0to2;
		rel_algebra_node temp_893 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_879, temp_880, temp_881, temp_883, temp_885, temp_887, temp_889, temp_890, temp_891, temp_892, temp_893);
		auto temp_950 = [=](rel_algebra_node param_1, rel_algebra_node param_2) -> rel_algebra_node
			{
				rel_algebra_node temp_900 = rel_algebra::trueTable();
				rel_algebra_node temp_898 = param_1;
				temp_900 = rel_algebra::join(temp_900, rel_algebra::complement(temp_898));
				rel_algebra_node temp_899 = param_2;
				temp_900 = rel_algebra::join(temp_900, rel_algebra::complement(temp_899));
				temp_900 = rel_algebra::complement(temp_900);
				return temp_900;
			};
		rel_algebra_node temp_901 = rel_algebra::trueTable();
		temp_901 = rel_algebra::complement(temp_901);
		rel_algebra_node temp_951 = temp_901;
		rel_algebra_node temp_946 = local_eDicU;
		for (auto local_X = rel_algebra::getUnitIterator(temp_946); !local_X.atEnd(); ++local_X)
		{
			rel_algebra_node temp_945 = rel_algebra::trueTable();
			rel_algebra_node temp_910 = rel_algebra::trueTable();
			int64_t temp_902 = 3;
			int64_t temp_903 = local_totalVarCount;
			int64_t temp_904 = local_eTupleUCount;
			int64_t temp_905 = temp_903 + temp_904;
			int64_t temp_906 = 2;
			int64_t temp_908 = local_X[temp_906];
			int64_t temp_909 = temp_905 + temp_908;
			rel_algebra_node temp_914 = rel_algebra::filterEqualTo(temp_902, temp_909, temp_910);
			temp_945 = rel_algebra::join(temp_945, temp_914);
			rel_algebra_node temp_919 = rel_algebra::trueTable();
			int64_t temp_915 = 2;
			int64_t temp_916 = 2;
			int64_t temp_918 = local_X[temp_916];
			rel_algebra_node temp_923 = rel_algebra::filterEqualTo(temp_915, temp_918, temp_919);
			temp_945 = rel_algebra::join(temp_945, temp_923);
			rel_algebra_node temp_930 = rel_algebra::trueTable();
			int64_t temp_924 = 1;
			int64_t temp_925 = local_totalVarCount;
			int64_t temp_926 = 2;
			int64_t temp_928 = local_X[temp_926];
			int64_t temp_929 = temp_925 + temp_928;
			rel_algebra_node temp_934 = rel_algebra::filterEqualTo(temp_924, temp_929, temp_930);
			temp_945 = rel_algebra::join(temp_945, temp_934);
			rel_algebra_node temp_940 = rel_algebra::trueTable();
			int64_t temp_935 = 0;
			int64_t temp_936 = 1;
			int64_t temp_938 = local_X[temp_936];
			int64_t temp_939 = -temp_938;
			rel_algebra_node temp_944 = rel_algebra::filterEqualTo(temp_935, temp_939, temp_940);
			temp_945 = rel_algebra::join(temp_945, temp_944);
			temp_951 = temp_950(temp_951, temp_945);
		}
		subtree_out->output_unary_proper_subset_clauses(os, temp_951);
		os << "endmodule\n";
		os << "falsify 0";
		rel_algebra_node temp_966 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_966); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_961 = 2;
			int64_t temp_963 = local_tuple[temp_961];
			os << temp_963;
		}
		os << "\n";
	}
}

string gg_datatype_Spec_type2::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "preferred";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type2::gg_datatype_Spec_type2(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_427 = compact_string::make_from("cfe");
	rel_algebra_node temp_430 = subtree_r->local_cf;
	set_database_atom(temp_427, temp_430);

	compact_string temp_432 = compact_string::make_from("cte");
	rel_algebra_node temp_435 = subtree_r->local_ct;
	set_database_atom(temp_432, temp_435);

	compact_string temp_437 = compact_string::make_from("cfd");
	rel_algebra_node temp_439 = rel_algebra::trueTable();
	temp_439 = rel_algebra::complement(temp_439);
	set_database_atom(temp_437, temp_439);

	compact_string temp_441 = compact_string::make_from("ctd");
	rel_algebra_node temp_443 = rel_algebra::trueTable();
	temp_443 = rel_algebra::complement(temp_443);
	set_database_atom(temp_441, temp_443);

	compact_string temp_445 = compact_string::make_from("attacks");
	rel_algebra_node temp_446 = database[temp_445];
	local_attacks01 = temp_446;

	int64_t temp_448 = 0;
	int64_t temp_450 = 2;
	rel_algebra_node temp_452 = local_attacks01;
	rel_algebra_node temp_457 = generalized_filter_rename(temp_448, temp_450)(temp_452);
	local_attacks21 = temp_457;

	int64_t temp_459 = 2;
	int64_t temp_461 = 1;
	int64_t temp_463 = 1;
	int64_t temp_465 = 0;
	rel_algebra_node temp_467 = local_attacks21;
	rel_algebra_node temp_472 = generalized_filter_rename(temp_463, temp_465)(temp_467);
	rel_algebra_node temp_477 = generalized_filter_rename(temp_459, temp_461)(temp_472);
	local_attacks10 = temp_477;

	int64_t temp_479 = 0;
	int64_t temp_481 = 2;
	compact_string temp_483 = compact_string::make_from("arguments");
	rel_algebra_node temp_484 = database[temp_483];
	rel_algebra_node temp_489 = generalized_filter_equals(temp_479, temp_481)(temp_484);
	local_args02 = temp_489;
}

bool gg_datatype_Spec_type3::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_1055 = compact_string::make_from("cfe");
	rel_algebra_node temp_1071 = rel_algebra::trueTable();
	compact_string temp_1057 = compact_string::make_from("arguments");
	rel_algebra_node temp_1058 = database[temp_1057];
	temp_1071 = rel_algebra::join(temp_1071, temp_1058);
	rel_algebra_node temp_1070 = rel_algebra::trueTable();
	compact_string temp_1059 = compact_string::make_from("cfe");
	rel_algebra_node temp_1060 = database[temp_1059];
	temp_1070 = rel_algebra::join(temp_1070, rel_algebra::complement(temp_1060));
	rel_algebra_node temp_1061 = local_attacks01;
	rel_algebra_node temp_1062 = local_attacks10;
	compact_string temp_1063 = compact_string::make_from("cte");
	rel_algebra_node temp_1064 = database[temp_1063];
	compact_string temp_1065 = compact_string::make_from("cfd");
	rel_algebra_node temp_1066 = database[temp_1065];
	rel_algebra_node temp_1069 = macro_completion_cfe_bound(temp_1061, temp_1062, temp_1064, temp_1066);
	temp_1070 = rel_algebra::join(temp_1070, rel_algebra::complement(temp_1069));
	temp_1070 = rel_algebra::complement(temp_1070);
	temp_1071 = rel_algebra::join(temp_1071, temp_1070);
	result = result || (database[temp_1055] != temp_1071);
	set_database_atom(temp_1055, temp_1071);

	compact_string temp_1073 = compact_string::make_from("cte");
	rel_algebra_node temp_1094 = rel_algebra::trueTable();
	compact_string temp_1075 = compact_string::make_from("arguments");
	rel_algebra_node temp_1076 = database[temp_1075];
	temp_1094 = rel_algebra::join(temp_1094, temp_1076);
	rel_algebra_node temp_1093 = rel_algebra::trueTable();
	compact_string temp_1077 = compact_string::make_from("cte");
	rel_algebra_node temp_1078 = database[temp_1077];
	temp_1093 = rel_algebra::join(temp_1093, rel_algebra::complement(temp_1078));
	compact_string temp_1079 = compact_string::make_from("cfd");
	rel_algebra_node temp_1080 = database[temp_1079];
	temp_1093 = rel_algebra::join(temp_1093, rel_algebra::complement(temp_1080));
	compact_string temp_1081 = compact_string::make_from("arguments");
	rel_algebra_node temp_1082 = database[temp_1081];
	rel_algebra_node temp_1083 = local_args02;
	rel_algebra_node temp_1084 = local_attacks10;
	rel_algebra_node temp_1085 = local_attacks21;
	compact_string temp_1086 = compact_string::make_from("cfe");
	rel_algebra_node temp_1087 = database[temp_1086];
	compact_string temp_1088 = compact_string::make_from("ctd");
	rel_algebra_node temp_1089 = database[temp_1088];
	rel_algebra_node temp_1092 = macro_completion_cte_bound(temp_1082, temp_1083, temp_1084, temp_1085, temp_1087, temp_1089);
	temp_1093 = rel_algebra::join(temp_1093, rel_algebra::complement(temp_1092));
	temp_1093 = rel_algebra::complement(temp_1093);
	temp_1094 = rel_algebra::join(temp_1094, temp_1093);
	result = result || (database[temp_1073] != temp_1094);
	set_database_atom(temp_1073, temp_1094);

	compact_string temp_1096 = compact_string::make_from("cfd");
	rel_algebra_node temp_1115 = rel_algebra::trueTable();
	compact_string temp_1098 = compact_string::make_from("arguments");
	rel_algebra_node temp_1099 = database[temp_1098];
	temp_1115 = rel_algebra::join(temp_1115, temp_1099);
	rel_algebra_node temp_1114 = rel_algebra::trueTable();
	compact_string temp_1100 = compact_string::make_from("cfd");
	rel_algebra_node temp_1101 = database[temp_1100];
	temp_1114 = rel_algebra::join(temp_1114, rel_algebra::complement(temp_1101));
	compact_string temp_1102 = compact_string::make_from("arguments");
	rel_algebra_node temp_1103 = database[temp_1102];
	rel_algebra_node temp_1104 = local_args02;
	rel_algebra_node temp_1105 = local_attacks10;
	rel_algebra_node temp_1106 = local_attacks21;
	compact_string temp_1107 = compact_string::make_from("cfe");
	rel_algebra_node temp_1108 = database[temp_1107];
	compact_string temp_1109 = compact_string::make_from("ctd");
	rel_algebra_node temp_1110 = database[temp_1109];
	rel_algebra_node temp_1113 = macro_completion_cfd_bound(temp_1103, temp_1104, temp_1105, temp_1106, temp_1108, temp_1110);
	temp_1114 = rel_algebra::join(temp_1114, rel_algebra::complement(temp_1113));
	temp_1114 = rel_algebra::complement(temp_1114);
	temp_1115 = rel_algebra::join(temp_1115, temp_1114);
	result = result || (database[temp_1096] != temp_1115);
	set_database_atom(temp_1096, temp_1115);

	compact_string temp_1117 = compact_string::make_from("ctd");
	rel_algebra_node temp_1133 = rel_algebra::trueTable();
	compact_string temp_1119 = compact_string::make_from("arguments");
	rel_algebra_node temp_1120 = database[temp_1119];
	temp_1133 = rel_algebra::join(temp_1133, temp_1120);
	rel_algebra_node temp_1132 = rel_algebra::trueTable();
	compact_string temp_1121 = compact_string::make_from("ctd");
	rel_algebra_node temp_1122 = database[temp_1121];
	temp_1132 = rel_algebra::join(temp_1132, rel_algebra::complement(temp_1122));
	compact_string temp_1123 = compact_string::make_from("cfe");
	rel_algebra_node temp_1124 = database[temp_1123];
	temp_1132 = rel_algebra::join(temp_1132, rel_algebra::complement(temp_1124));
	rel_algebra_node temp_1125 = local_attacks01;
	rel_algebra_node temp_1126 = local_attacks10;
	compact_string temp_1127 = compact_string::make_from("cte");
	rel_algebra_node temp_1128 = database[temp_1127];
	rel_algebra_node temp_1131 = macro_completion_ctd_bound(temp_1125, temp_1126, temp_1128);
	temp_1132 = rel_algebra::join(temp_1132, rel_algebra::complement(temp_1131));
	temp_1132 = rel_algebra::complement(temp_1132);
	temp_1133 = rel_algebra::join(temp_1133, temp_1132);
	result = result || (database[temp_1117] != temp_1133);
	set_database_atom(temp_1117, temp_1133);

	return result;
}

bool gg_datatype_Spec_type3::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_1141 = rel_algebra::trueTable();
	compact_string temp_1136 = compact_string::make_from("arguments");
	rel_algebra_node temp_1137 = database[temp_1136];
	temp_1141 = rel_algebra::join(temp_1141, temp_1137);
	compact_string temp_1138 = compact_string::make_from("cfe");
	rel_algebra_node temp_1139 = database[temp_1138];
	rel_algebra_node temp_1140 = rel_algebra::complement(temp_1139);
	temp_1141 = rel_algebra::join(temp_1141, temp_1140);
	int64_t temp_1142 = 1;
	rel_algebra_node temp_1146 = macro_unaryTranslator(temp_1141, temp_1142);
	local_eDicTU = temp_1146;

	rel_algebra_node temp_1156 = rel_algebra::trueTable();
	compact_string temp_1148 = compact_string::make_from("arguments");
	rel_algebra_node temp_1149 = database[temp_1148];
	temp_1156 = rel_algebra::join(temp_1156, temp_1149);
	compact_string temp_1150 = compact_string::make_from("cfd");
	rel_algebra_node temp_1151 = database[temp_1150];
	rel_algebra_node temp_1152 = rel_algebra::complement(temp_1151);
	temp_1156 = rel_algebra::join(temp_1156, temp_1152);
	compact_string temp_1153 = compact_string::make_from("ctd");
	rel_algebra_node temp_1154 = database[temp_1153];
	rel_algebra_node temp_1155 = rel_algebra::complement(temp_1154);
	temp_1156 = rel_algebra::join(temp_1156, temp_1155);
	int64_t temp_1177 = std::numeric_limits<ValueType>::min();
	int64_t temp_1157 = 1;
	temp_1177 = std::max(temp_1177, temp_1157);
	rel_algebra_node temp_1164 = rel_algebra::trueTable();
	int64_t temp_1162 = 0;
	int64_t temp_1163 = 0;
	rel_algebra_node temp_1168 = rel_algebra::filterLessThanOrEqualTo(temp_1162, temp_1163, temp_1164);
	rel_algebra_node temp_1169 = local_eDicTU;
	rel_algebra_node temp_1172 = rel_algebra::complement(rel_algebra::divide(temp_1168, rel_algebra::complement(temp_1169)));
	int64_t temp_1175 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_1172); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1159 = 0;
		int64_t temp_1161 = local_X[temp_1159];
		temp_1175 = std::max(temp_1175, temp_1161);
	}
	temp_1177 = std::max(temp_1177, temp_1175);
	rel_algebra_node temp_1181 = macro_unaryTranslator(temp_1156, temp_1177);
	local_dDicU = temp_1181;

	int64_t temp_1183 = 1;
	int64_t temp_1185 = 0;
	rel_algebra_node temp_1189 = rel_algebra::trueTable();
	int64_t temp_1187 = 0;
	int64_t temp_1188 = 0;
	rel_algebra_node temp_1193 = rel_algebra::filterGreaterThan(temp_1187, temp_1188, temp_1189);
	rel_algebra_node temp_1194 = local_eDicTU;
	rel_algebra_node temp_1197 = rel_algebra::complement(rel_algebra::divide(temp_1193, rel_algebra::complement(temp_1194)));
	rel_algebra_node temp_1202 = generalized_filter_rename(temp_1183, temp_1185)(temp_1197);
	local_eDic0to2 = temp_1202;

	int64_t temp_1204 = 2;
	int64_t temp_1206 = 3;
	rel_algebra_node temp_1210 = rel_algebra::trueTable();
	int64_t temp_1208 = 0;
	int64_t temp_1209 = 0;
	rel_algebra_node temp_1214 = rel_algebra::filterGreaterThan(temp_1208, temp_1209, temp_1210);
	rel_algebra_node temp_1215 = local_eDicTU;
	rel_algebra_node temp_1218 = rel_algebra::complement(rel_algebra::divide(temp_1214, rel_algebra::complement(temp_1215)));
	rel_algebra_node temp_1223 = generalized_filter_rename(temp_1204, temp_1206)(temp_1218);
	local_eDic1to3 = temp_1223;

	int64_t temp_1225 = 1;
	int64_t temp_1227 = 0;
	rel_algebra_node temp_1229 = local_eDic1to3;
	rel_algebra_node temp_1234 = generalized_filter_rename(temp_1225, temp_1227)(temp_1229);
	local_eDic0to3 = temp_1234;

	int64_t temp_1236 = 1;
	int64_t temp_1238 = 0;
	rel_algebra_node temp_1242 = rel_algebra::trueTable();
	int64_t temp_1240 = 0;
	int64_t temp_1241 = 0;
	rel_algebra_node temp_1246 = rel_algebra::filterGreaterThan(temp_1240, temp_1241, temp_1242);
	rel_algebra_node temp_1247 = local_dDicU;
	rel_algebra_node temp_1250 = rel_algebra::complement(rel_algebra::divide(temp_1246, rel_algebra::complement(temp_1247)));
	rel_algebra_node temp_1255 = generalized_filter_rename(temp_1236, temp_1238)(temp_1250);
	local_dDic0to2 = temp_1255;

	int64_t temp_1257 = 2;
	int64_t temp_1259 = 3;
	rel_algebra_node temp_1263 = rel_algebra::trueTable();
	int64_t temp_1261 = 0;
	int64_t temp_1262 = 0;
	rel_algebra_node temp_1267 = rel_algebra::filterGreaterThan(temp_1261, temp_1262, temp_1263);
	rel_algebra_node temp_1268 = local_dDicU;
	rel_algebra_node temp_1271 = rel_algebra::complement(rel_algebra::divide(temp_1267, rel_algebra::complement(temp_1268)));
	rel_algebra_node temp_1276 = generalized_filter_rename(temp_1257, temp_1259)(temp_1271);
	local_dDic1to3 = temp_1276;

	auto temp_1295 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1278 = 1;
			int64_t temp_1279 = param_1;
			int64_t temp_1280 = temp_1278 + temp_1279;
			return temp_1280;
		};
	int64_t temp_1281 = 0;
	int64_t temp_1296 = temp_1281;
	rel_algebra_node temp_1291 = rel_algebra::trueTable();
	compact_string temp_1283 = compact_string::make_from("arguments");
	rel_algebra_node temp_1284 = database[temp_1283];
	temp_1291 = rel_algebra::join(temp_1291, temp_1284);
	compact_string temp_1285 = compact_string::make_from("ctd");
	rel_algebra_node temp_1286 = database[temp_1285];
	rel_algebra_node temp_1287 = rel_algebra::complement(temp_1286);
	temp_1291 = rel_algebra::join(temp_1291, temp_1287);
	compact_string temp_1288 = compact_string::make_from("cfd");
	rel_algebra_node temp_1289 = database[temp_1288];
	rel_algebra_node temp_1290 = rel_algebra::complement(temp_1289);
	temp_1291 = rel_algebra::join(temp_1291, temp_1290);
	for (auto local_X = rel_algebra::getUnitIterator(temp_1291); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1282 = 0;
		temp_1296 = temp_1295(temp_1296, temp_1282);
	}
	local_dTupleUCount = temp_1296;

	auto temp_1315 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1298 = 1;
			int64_t temp_1299 = param_1;
			int64_t temp_1300 = temp_1298 + temp_1299;
			return temp_1300;
		};
	int64_t temp_1301 = 0;
	int64_t temp_1316 = temp_1301;
	rel_algebra_node temp_1311 = rel_algebra::trueTable();
	compact_string temp_1303 = compact_string::make_from("arguments");
	rel_algebra_node temp_1304 = database[temp_1303];
	temp_1311 = rel_algebra::join(temp_1311, temp_1304);
	compact_string temp_1305 = compact_string::make_from("cte");
	rel_algebra_node temp_1306 = database[temp_1305];
	rel_algebra_node temp_1307 = rel_algebra::complement(temp_1306);
	temp_1311 = rel_algebra::join(temp_1311, temp_1307);
	compact_string temp_1308 = compact_string::make_from("cfe");
	rel_algebra_node temp_1309 = database[temp_1308];
	rel_algebra_node temp_1310 = rel_algebra::complement(temp_1309);
	temp_1311 = rel_algebra::join(temp_1311, temp_1310);
	for (auto local_X = rel_algebra::getUnitIterator(temp_1311); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1302 = 0;
		temp_1316 = temp_1315(temp_1316, temp_1302);
	}
	local_eTupleUCount = temp_1316;

	auto temp_1328 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1318 = 1;
			int64_t temp_1319 = param_1;
			int64_t temp_1320 = temp_1318 + temp_1319;
			return temp_1320;
		};
	int64_t temp_1321 = 0;
	int64_t temp_1329 = temp_1321;
	compact_string temp_1323 = compact_string::make_from("cte");
	rel_algebra_node temp_1324 = database[temp_1323];
	for (auto local_X = rel_algebra::getUnitIterator(temp_1324); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1322 = 0;
		temp_1329 = temp_1328(temp_1329, temp_1322);
	}
	local_eTupleTCount = temp_1329;

	int64_t temp_1331 = local_dTupleUCount;
	int64_t temp_1332 = local_eTupleUCount;
	int64_t temp_1333 = temp_1331 + temp_1332;
	int64_t temp_1334 = local_eTupleTCount;
	int64_t temp_1335 = temp_1333 + temp_1334;
	local_totalVarCount = temp_1335;

	return result;
}

void gg_datatype_Spec_type3::output_grounder(ostream &os) const
{
	rel_algebra_node temp_1350 = rel_algebra::trueTable();
	rel_algebra_node temp_1344 = rel_algebra::trueTable();
	compact_string temp_1340 = compact_string::make_from("cte");
	rel_algebra_node temp_1341 = database[temp_1340];
	temp_1344 = rel_algebra::join(temp_1344, temp_1341);
	compact_string temp_1342 = compact_string::make_from("cfe");
	rel_algebra_node temp_1343 = database[temp_1342];
	temp_1344 = rel_algebra::join(temp_1344, temp_1343);
	temp_1350 = rel_algebra::join(temp_1350, rel_algebra::complement(temp_1344));
	rel_algebra_node temp_1349 = rel_algebra::trueTable();
	compact_string temp_1345 = compact_string::make_from("ctd");
	rel_algebra_node temp_1346 = database[temp_1345];
	temp_1349 = rel_algebra::join(temp_1349, temp_1346);
	compact_string temp_1347 = compact_string::make_from("cfd");
	rel_algebra_node temp_1348 = database[temp_1347];
	temp_1349 = rel_algebra::join(temp_1349, temp_1348);
	temp_1350 = rel_algebra::join(temp_1350, rel_algebra::complement(temp_1349));
	temp_1350 = rel_algebra::complement(temp_1350);
	if ((!rel_algebra::isEmpty(temp_1350)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_1357 = local_totalVarCount;
		os << temp_1357;
		os << " 10\n";
		rel_algebra_node temp_1380 = local_eDic0to2;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_1380); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_1363 = 2;
			int64_t temp_1365 = local_tuple[temp_1363];
			os << temp_1365;
			os << " ";
			compact_string temp_1370 = compact_string::make_from("arguments");
			int64_t temp_1371 = 0;
			int64_t temp_1373 = local_tuple[temp_1371];
			os << mapFromInt(temp_1370, temp_1373);
			os << "\n";
		}
		compact_string temp_1385 = compact_string::make_from("arguments");
		rel_algebra_node temp_1386 = database[temp_1385];
		rel_algebra_node temp_1387 = local_attacks01;
		rel_algebra_node temp_1388 = local_attacks10;
		compact_string temp_1389 = compact_string::make_from("cfe");
		rel_algebra_node temp_1390 = database[temp_1389];
		compact_string temp_1391 = compact_string::make_from("cte");
		rel_algebra_node temp_1392 = database[temp_1391];
		compact_string temp_1393 = compact_string::make_from("cfd");
		rel_algebra_node temp_1394 = database[temp_1393];
		compact_string temp_1395 = compact_string::make_from("ctd");
		rel_algebra_node temp_1396 = database[temp_1395];
		rel_algebra_node temp_1397 = local_eDic0to2;
		rel_algebra_node temp_1398 = local_eDic1to3;
		rel_algebra_node temp_1399 = local_dDic0to2;
		rel_algebra_node temp_1400 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_1386, temp_1387, temp_1388, temp_1390, temp_1392, temp_1394, temp_1396, temp_1397, temp_1398, temp_1399, temp_1400);
		os << "c e(v0) | d(v0) for all arguments v0\n";
		rel_algebra_node temp_1425 = rel_algebra::trueTable();
		rel_algebra_node temp_1420 = local_dDic0to2;
		temp_1425 = rel_algebra::join(temp_1425, temp_1420);
		rel_algebra_node temp_1421 = local_eDic0to3;
		temp_1425 = rel_algebra::join(temp_1425, temp_1421);
		compact_string temp_1422 = compact_string::make_from("cte");
		rel_algebra_node temp_1423 = database[temp_1422];
		rel_algebra_node temp_1424 = rel_algebra::complement(temp_1423);
		temp_1425 = rel_algebra::join(temp_1425, temp_1424);
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_1425); !local_tuple.atEnd(); ++local_tuple)
		{
			int64_t temp_1407 = 2;
			int64_t temp_1409 = local_tuple[temp_1407];
			os << temp_1409;
			os << " ";
			int64_t temp_1413 = 3;
			int64_t temp_1415 = local_tuple[temp_1413];
			os << temp_1415;
			os << " 0\n";
		}
	}
}

string gg_datatype_Spec_type3::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "stable";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type3::gg_datatype_Spec_type3(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_991 = compact_string::make_from("cfe");
	rel_algebra_node temp_994 = subtree_r->local_cf;
	set_database_atom(temp_991, temp_994);

	compact_string temp_996 = compact_string::make_from("cte");
	rel_algebra_node temp_999 = subtree_r->local_ct;
	set_database_atom(temp_996, temp_999);

	compact_string temp_1001 = compact_string::make_from("cfd");
	rel_algebra_node temp_1003 = rel_algebra::trueTable();
	temp_1003 = rel_algebra::complement(temp_1003);
	set_database_atom(temp_1001, temp_1003);

	compact_string temp_1005 = compact_string::make_from("ctd");
	rel_algebra_node temp_1007 = rel_algebra::trueTable();
	temp_1007 = rel_algebra::complement(temp_1007);
	set_database_atom(temp_1005, temp_1007);

	compact_string temp_1009 = compact_string::make_from("attacks");
	rel_algebra_node temp_1010 = database[temp_1009];
	local_attacks01 = temp_1010;

	int64_t temp_1012 = 0;
	int64_t temp_1014 = 2;
	rel_algebra_node temp_1016 = local_attacks01;
	rel_algebra_node temp_1021 = generalized_filter_rename(temp_1012, temp_1014)(temp_1016);
	local_attacks21 = temp_1021;

	int64_t temp_1023 = 2;
	int64_t temp_1025 = 1;
	int64_t temp_1027 = 1;
	int64_t temp_1029 = 0;
	rel_algebra_node temp_1031 = local_attacks21;
	rel_algebra_node temp_1036 = generalized_filter_rename(temp_1027, temp_1029)(temp_1031);
	rel_algebra_node temp_1041 = generalized_filter_rename(temp_1023, temp_1025)(temp_1036);
	local_attacks10 = temp_1041;

	int64_t temp_1043 = 0;
	int64_t temp_1045 = 2;
	compact_string temp_1047 = compact_string::make_from("arguments");
	rel_algebra_node temp_1048 = database[temp_1047];
	rel_algebra_node temp_1053 = generalized_filter_equals(temp_1043, temp_1045)(temp_1048);
	local_args02 = temp_1053;
}

bool gg_datatype_Spec_type4::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_1512 = compact_string::make_from("cfe");
	rel_algebra_node temp_1528 = rel_algebra::trueTable();
	compact_string temp_1514 = compact_string::make_from("arguments");
	rel_algebra_node temp_1515 = database[temp_1514];
	temp_1528 = rel_algebra::join(temp_1528, temp_1515);
	rel_algebra_node temp_1527 = rel_algebra::trueTable();
	compact_string temp_1516 = compact_string::make_from("cfe");
	rel_algebra_node temp_1517 = database[temp_1516];
	temp_1527 = rel_algebra::join(temp_1527, rel_algebra::complement(temp_1517));
	rel_algebra_node temp_1518 = local_attacks01;
	rel_algebra_node temp_1519 = local_attacks10;
	compact_string temp_1520 = compact_string::make_from("cte");
	rel_algebra_node temp_1521 = database[temp_1520];
	compact_string temp_1522 = compact_string::make_from("cfd");
	rel_algebra_node temp_1523 = database[temp_1522];
	rel_algebra_node temp_1526 = macro_completion_cfe_bound(temp_1518, temp_1519, temp_1521, temp_1523);
	temp_1527 = rel_algebra::join(temp_1527, rel_algebra::complement(temp_1526));
	temp_1527 = rel_algebra::complement(temp_1527);
	temp_1528 = rel_algebra::join(temp_1528, temp_1527);
	result = result || (database[temp_1512] != temp_1528);
	set_database_atom(temp_1512, temp_1528);

	compact_string temp_1530 = compact_string::make_from("cte");
	rel_algebra_node temp_1549 = rel_algebra::trueTable();
	compact_string temp_1532 = compact_string::make_from("arguments");
	rel_algebra_node temp_1533 = database[temp_1532];
	temp_1549 = rel_algebra::join(temp_1549, temp_1533);
	rel_algebra_node temp_1548 = rel_algebra::trueTable();
	compact_string temp_1534 = compact_string::make_from("cte");
	rel_algebra_node temp_1535 = database[temp_1534];
	temp_1548 = rel_algebra::join(temp_1548, rel_algebra::complement(temp_1535));
	compact_string temp_1536 = compact_string::make_from("arguments");
	rel_algebra_node temp_1537 = database[temp_1536];
	rel_algebra_node temp_1538 = local_args02;
	rel_algebra_node temp_1539 = local_attacks10;
	rel_algebra_node temp_1540 = local_attacks21;
	compact_string temp_1541 = compact_string::make_from("cfe");
	rel_algebra_node temp_1542 = database[temp_1541];
	compact_string temp_1543 = compact_string::make_from("ctd");
	rel_algebra_node temp_1544 = database[temp_1543];
	rel_algebra_node temp_1547 = macro_completion_cte_bound(temp_1537, temp_1538, temp_1539, temp_1540, temp_1542, temp_1544);
	temp_1548 = rel_algebra::join(temp_1548, rel_algebra::complement(temp_1547));
	temp_1548 = rel_algebra::complement(temp_1548);
	temp_1549 = rel_algebra::join(temp_1549, temp_1548);
	result = result || (database[temp_1530] != temp_1549);
	set_database_atom(temp_1530, temp_1549);

	compact_string temp_1551 = compact_string::make_from("cfd");
	rel_algebra_node temp_1570 = rel_algebra::trueTable();
	compact_string temp_1553 = compact_string::make_from("arguments");
	rel_algebra_node temp_1554 = database[temp_1553];
	temp_1570 = rel_algebra::join(temp_1570, temp_1554);
	rel_algebra_node temp_1569 = rel_algebra::trueTable();
	compact_string temp_1555 = compact_string::make_from("cfd");
	rel_algebra_node temp_1556 = database[temp_1555];
	temp_1569 = rel_algebra::join(temp_1569, rel_algebra::complement(temp_1556));
	compact_string temp_1557 = compact_string::make_from("arguments");
	rel_algebra_node temp_1558 = database[temp_1557];
	rel_algebra_node temp_1559 = local_args02;
	rel_algebra_node temp_1560 = local_attacks10;
	rel_algebra_node temp_1561 = local_attacks21;
	compact_string temp_1562 = compact_string::make_from("cfe");
	rel_algebra_node temp_1563 = database[temp_1562];
	compact_string temp_1564 = compact_string::make_from("ctd");
	rel_algebra_node temp_1565 = database[temp_1564];
	rel_algebra_node temp_1568 = macro_completion_cfd_bound(temp_1558, temp_1559, temp_1560, temp_1561, temp_1563, temp_1565);
	temp_1569 = rel_algebra::join(temp_1569, rel_algebra::complement(temp_1568));
	temp_1569 = rel_algebra::complement(temp_1569);
	temp_1570 = rel_algebra::join(temp_1570, temp_1569);
	result = result || (database[temp_1551] != temp_1570);
	set_database_atom(temp_1551, temp_1570);

	compact_string temp_1572 = compact_string::make_from("ctd");
	rel_algebra_node temp_1586 = rel_algebra::trueTable();
	compact_string temp_1574 = compact_string::make_from("arguments");
	rel_algebra_node temp_1575 = database[temp_1574];
	temp_1586 = rel_algebra::join(temp_1586, temp_1575);
	rel_algebra_node temp_1585 = rel_algebra::trueTable();
	compact_string temp_1576 = compact_string::make_from("ctd");
	rel_algebra_node temp_1577 = database[temp_1576];
	temp_1585 = rel_algebra::join(temp_1585, rel_algebra::complement(temp_1577));
	rel_algebra_node temp_1578 = local_attacks01;
	rel_algebra_node temp_1579 = local_attacks10;
	compact_string temp_1580 = compact_string::make_from("cte");
	rel_algebra_node temp_1581 = database[temp_1580];
	rel_algebra_node temp_1584 = macro_completion_ctd_bound(temp_1578, temp_1579, temp_1581);
	temp_1585 = rel_algebra::join(temp_1585, rel_algebra::complement(temp_1584));
	temp_1585 = rel_algebra::complement(temp_1585);
	temp_1586 = rel_algebra::join(temp_1586, temp_1585);
	result = result || (database[temp_1572] != temp_1586);
	set_database_atom(temp_1572, temp_1586);

	return result;
}

bool gg_datatype_Spec_type4::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_1594 = rel_algebra::trueTable();
	compact_string temp_1589 = compact_string::make_from("arguments");
	rel_algebra_node temp_1590 = database[temp_1589];
	temp_1594 = rel_algebra::join(temp_1594, temp_1590);
	compact_string temp_1591 = compact_string::make_from("cfe");
	rel_algebra_node temp_1592 = database[temp_1591];
	rel_algebra_node temp_1593 = rel_algebra::complement(temp_1592);
	temp_1594 = rel_algebra::join(temp_1594, temp_1593);
	int64_t temp_1595 = 1;
	rel_algebra_node temp_1599 = macro_unaryTranslator(temp_1594, temp_1595);
	local_eDicTU = temp_1599;

	int64_t temp_1621 = std::numeric_limits<ValueType>::min();
	int64_t temp_1601 = 1;
	temp_1621 = std::max(temp_1621, temp_1601);
	rel_algebra_node temp_1608 = rel_algebra::trueTable();
	int64_t temp_1606 = 0;
	int64_t temp_1607 = 0;
	rel_algebra_node temp_1612 = rel_algebra::filterLessThanOrEqualTo(temp_1606, temp_1607, temp_1608);
	rel_algebra_node temp_1613 = local_eDicTU;
	rel_algebra_node temp_1616 = rel_algebra::complement(rel_algebra::divide(temp_1612, rel_algebra::complement(temp_1613)));
	int64_t temp_1619 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_1616); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1603 = 0;
		int64_t temp_1605 = local_X[temp_1603];
		temp_1619 = std::max(temp_1619, temp_1605);
	}
	temp_1621 = std::max(temp_1621, temp_1619);
	local_afterEVar = temp_1621;

	rel_algebra_node temp_1631 = rel_algebra::trueTable();
	compact_string temp_1623 = compact_string::make_from("arguments");
	rel_algebra_node temp_1624 = database[temp_1623];
	temp_1631 = rel_algebra::join(temp_1631, temp_1624);
	compact_string temp_1625 = compact_string::make_from("cfd");
	rel_algebra_node temp_1626 = database[temp_1625];
	rel_algebra_node temp_1627 = rel_algebra::complement(temp_1626);
	temp_1631 = rel_algebra::join(temp_1631, temp_1627);
	compact_string temp_1628 = compact_string::make_from("ctd");
	rel_algebra_node temp_1629 = database[temp_1628];
	rel_algebra_node temp_1630 = rel_algebra::complement(temp_1629);
	temp_1631 = rel_algebra::join(temp_1631, temp_1630);
	int64_t temp_1632 = local_afterEVar;
	rel_algebra_node temp_1636 = macro_unaryTranslator(temp_1631, temp_1632);
	local_dDicU = temp_1636;

	int64_t temp_1658 = std::numeric_limits<ValueType>::min();
	int64_t temp_1638 = local_afterEVar;
	temp_1658 = std::max(temp_1658, temp_1638);
	rel_algebra_node temp_1645 = rel_algebra::trueTable();
	int64_t temp_1643 = 0;
	int64_t temp_1644 = 0;
	rel_algebra_node temp_1649 = rel_algebra::filterLessThanOrEqualTo(temp_1643, temp_1644, temp_1645);
	rel_algebra_node temp_1650 = local_dDicU;
	rel_algebra_node temp_1653 = rel_algebra::complement(rel_algebra::divide(temp_1649, rel_algebra::complement(temp_1650)));
	int64_t temp_1656 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_1653); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1640 = 0;
		int64_t temp_1642 = local_X[temp_1640];
		temp_1656 = std::max(temp_1656, temp_1642);
	}
	temp_1658 = std::max(temp_1658, temp_1656);
	local_afterDVar = temp_1658;

	rel_algebra_node temp_1674 = rel_algebra::trueTable();
	compact_string temp_1660 = compact_string::make_from("arguments");
	rel_algebra_node temp_1661 = database[temp_1660];
	temp_1674 = rel_algebra::join(temp_1674, temp_1661);
	compact_string temp_1662 = compact_string::make_from("cfe");
	rel_algebra_node temp_1663 = database[temp_1662];
	rel_algebra_node temp_1664 = rel_algebra::complement(temp_1663);
	temp_1674 = rel_algebra::join(temp_1674, temp_1664);
	compact_string temp_1665 = compact_string::make_from("cte");
	rel_algebra_node temp_1666 = database[temp_1665];
	rel_algebra_node temp_1667 = rel_algebra::complement(temp_1666);
	temp_1674 = rel_algebra::join(temp_1674, temp_1667);
	compact_string temp_1668 = compact_string::make_from("cfd");
	rel_algebra_node temp_1669 = database[temp_1668];
	rel_algebra_node temp_1670 = rel_algebra::complement(temp_1669);
	temp_1674 = rel_algebra::join(temp_1674, temp_1670);
	compact_string temp_1671 = compact_string::make_from("ctd");
	rel_algebra_node temp_1672 = database[temp_1671];
	rel_algebra_node temp_1673 = rel_algebra::complement(temp_1672);
	temp_1674 = rel_algebra::join(temp_1674, temp_1673);
	int64_t temp_1675 = local_afterDVar;
	rel_algebra_node temp_1679 = macro_unaryTranslator(temp_1674, temp_1675);
	local_pDicNew = temp_1679;

	int64_t temp_1681 = 1;
	int64_t temp_1683 = 0;
	rel_algebra_node temp_1687 = rel_algebra::trueTable();
	int64_t temp_1685 = 0;
	int64_t temp_1686 = 0;
	rel_algebra_node temp_1691 = rel_algebra::filterGreaterThan(temp_1685, temp_1686, temp_1687);
	rel_algebra_node temp_1692 = local_eDicTU;
	rel_algebra_node temp_1695 = rel_algebra::complement(rel_algebra::divide(temp_1691, rel_algebra::complement(temp_1692)));
	rel_algebra_node temp_1700 = generalized_filter_rename(temp_1681, temp_1683)(temp_1695);
	local_eDic0to2 = temp_1700;

	int64_t temp_1702 = 2;
	int64_t temp_1704 = 3;
	rel_algebra_node temp_1708 = rel_algebra::trueTable();
	int64_t temp_1706 = 0;
	int64_t temp_1707 = 0;
	rel_algebra_node temp_1712 = rel_algebra::filterGreaterThan(temp_1706, temp_1707, temp_1708);
	rel_algebra_node temp_1713 = local_eDicTU;
	rel_algebra_node temp_1716 = rel_algebra::complement(rel_algebra::divide(temp_1712, rel_algebra::complement(temp_1713)));
	rel_algebra_node temp_1721 = generalized_filter_rename(temp_1702, temp_1704)(temp_1716);
	local_eDic1to3 = temp_1721;

	int64_t temp_1723 = 1;
	int64_t temp_1725 = 0;
	rel_algebra_node temp_1729 = rel_algebra::trueTable();
	int64_t temp_1727 = 0;
	int64_t temp_1728 = 0;
	rel_algebra_node temp_1733 = rel_algebra::filterGreaterThan(temp_1727, temp_1728, temp_1729);
	rel_algebra_node temp_1734 = local_dDicU;
	rel_algebra_node temp_1737 = rel_algebra::complement(rel_algebra::divide(temp_1733, rel_algebra::complement(temp_1734)));
	rel_algebra_node temp_1742 = generalized_filter_rename(temp_1723, temp_1725)(temp_1737);
	local_dDic0to2 = temp_1742;

	int64_t temp_1744 = 2;
	int64_t temp_1746 = 4;
	rel_algebra_node temp_1748 = local_dDic0to2;
	rel_algebra_node temp_1753 = generalized_filter_rename(temp_1744, temp_1746)(temp_1748);
	local_dDic0to4 = temp_1753;

	int64_t temp_1755 = 2;
	int64_t temp_1757 = 3;
	rel_algebra_node temp_1761 = rel_algebra::trueTable();
	int64_t temp_1759 = 0;
	int64_t temp_1760 = 0;
	rel_algebra_node temp_1765 = rel_algebra::filterGreaterThan(temp_1759, temp_1760, temp_1761);
	rel_algebra_node temp_1766 = local_dDicU;
	rel_algebra_node temp_1769 = rel_algebra::complement(rel_algebra::divide(temp_1765, rel_algebra::complement(temp_1766)));
	rel_algebra_node temp_1774 = generalized_filter_rename(temp_1755, temp_1757)(temp_1769);
	local_dDic1to3 = temp_1774;

	rel_algebra_node temp_1780 = rel_algebra::trueTable();
	rel_algebra_node temp_1776 = local_eDic0to2;
	temp_1780 = rel_algebra::join(temp_1780, temp_1776);
	compact_string temp_1777 = compact_string::make_from("cte");
	rel_algebra_node temp_1778 = database[temp_1777];
	rel_algebra_node temp_1779 = rel_algebra::complement(temp_1778);
	temp_1780 = rel_algebra::join(temp_1780, temp_1779);
	local_eDicU0to2 = temp_1780;

	int64_t temp_1782 = 2;
	int64_t temp_1784 = 3;
	rel_algebra_node temp_1786 = local_eDicU0to2;
	rel_algebra_node temp_1791 = generalized_filter_rename(temp_1782, temp_1784)(temp_1786);
	local_eDicU0to3 = temp_1791;

	rel_algebra_node temp_1821 = rel_algebra::trueTable();
	rel_algebra_node temp_1796 = rel_algebra::trueTable();
	rel_algebra_node temp_1793 = local_eDicU0to2;
	temp_1796 = rel_algebra::join(temp_1796, temp_1793);
	compact_string temp_1794 = compact_string::make_from("cfd");
	rel_algebra_node temp_1795 = database[temp_1794];
	temp_1796 = rel_algebra::join(temp_1796, temp_1795);
	temp_1821 = rel_algebra::join(temp_1821, rel_algebra::complement(temp_1796));
	rel_algebra_node temp_1800 = rel_algebra::trueTable();
	rel_algebra_node temp_1797 = local_dDic0to2;
	temp_1800 = rel_algebra::join(temp_1800, temp_1797);
	compact_string temp_1798 = compact_string::make_from("cfe");
	rel_algebra_node temp_1799 = database[temp_1798];
	temp_1800 = rel_algebra::join(temp_1800, temp_1799);
	temp_1821 = rel_algebra::join(temp_1821, rel_algebra::complement(temp_1800));
	int64_t temp_1801 = 1;
	int64_t temp_1803 = 0;
	rel_algebra_node temp_1807 = rel_algebra::trueTable();
	int64_t temp_1805 = 0;
	int64_t temp_1806 = 0;
	rel_algebra_node temp_1811 = rel_algebra::filterGreaterThan(temp_1805, temp_1806, temp_1807);
	rel_algebra_node temp_1812 = local_pDicNew;
	rel_algebra_node temp_1815 = rel_algebra::complement(rel_algebra::divide(temp_1811, rel_algebra::complement(temp_1812)));
	rel_algebra_node temp_1820 = generalized_filter_rename(temp_1801, temp_1803)(temp_1815);
	temp_1821 = rel_algebra::join(temp_1821, rel_algebra::complement(temp_1820));
	temp_1821 = rel_algebra::complement(temp_1821);
	local_pDic0to2 = temp_1821;

	int64_t temp_1823 = 2;
	int64_t temp_1825 = 1;
	rel_algebra_node temp_1827 = local_pDic0to2;
	rel_algebra_node temp_1832 = generalized_filter_rename(temp_1823, temp_1825)(temp_1827);
	local_pDic0to1 = temp_1832;

	auto temp_1851 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1834 = 1;
			int64_t temp_1835 = param_1;
			int64_t temp_1836 = temp_1834 + temp_1835;
			return temp_1836;
		};
	int64_t temp_1837 = 0;
	int64_t temp_1852 = temp_1837;
	rel_algebra_node temp_1847 = rel_algebra::trueTable();
	compact_string temp_1839 = compact_string::make_from("arguments");
	rel_algebra_node temp_1840 = database[temp_1839];
	temp_1847 = rel_algebra::join(temp_1847, temp_1840);
	compact_string temp_1841 = compact_string::make_from("ctd");
	rel_algebra_node temp_1842 = database[temp_1841];
	rel_algebra_node temp_1843 = rel_algebra::complement(temp_1842);
	temp_1847 = rel_algebra::join(temp_1847, temp_1843);
	compact_string temp_1844 = compact_string::make_from("cfd");
	rel_algebra_node temp_1845 = database[temp_1844];
	rel_algebra_node temp_1846 = rel_algebra::complement(temp_1845);
	temp_1847 = rel_algebra::join(temp_1847, temp_1846);
	for (auto local_X = rel_algebra::getUnitIterator(temp_1847); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1838 = 0;
		temp_1852 = temp_1851(temp_1852, temp_1838);
	}
	local_dTupleUCount = temp_1852;

	auto temp_1871 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1854 = 1;
			int64_t temp_1855 = param_1;
			int64_t temp_1856 = temp_1854 + temp_1855;
			return temp_1856;
		};
	int64_t temp_1857 = 0;
	int64_t temp_1872 = temp_1857;
	rel_algebra_node temp_1867 = rel_algebra::trueTable();
	compact_string temp_1859 = compact_string::make_from("arguments");
	rel_algebra_node temp_1860 = database[temp_1859];
	temp_1867 = rel_algebra::join(temp_1867, temp_1860);
	compact_string temp_1861 = compact_string::make_from("cte");
	rel_algebra_node temp_1862 = database[temp_1861];
	rel_algebra_node temp_1863 = rel_algebra::complement(temp_1862);
	temp_1867 = rel_algebra::join(temp_1867, temp_1863);
	compact_string temp_1864 = compact_string::make_from("cfe");
	rel_algebra_node temp_1865 = database[temp_1864];
	rel_algebra_node temp_1866 = rel_algebra::complement(temp_1865);
	temp_1867 = rel_algebra::join(temp_1867, temp_1866);
	for (auto local_X = rel_algebra::getUnitIterator(temp_1867); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1858 = 0;
		temp_1872 = temp_1871(temp_1872, temp_1858);
	}
	local_eTupleUCount = temp_1872;

	auto temp_1884 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1874 = 1;
			int64_t temp_1875 = param_1;
			int64_t temp_1876 = temp_1874 + temp_1875;
			return temp_1876;
		};
	int64_t temp_1877 = 0;
	int64_t temp_1885 = temp_1877;
	compact_string temp_1879 = compact_string::make_from("cte");
	rel_algebra_node temp_1880 = database[temp_1879];
	for (auto local_X = rel_algebra::getUnitIterator(temp_1880); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1878 = 0;
		temp_1885 = temp_1884(temp_1885, temp_1878);
	}
	local_eTupleTCount = temp_1885;

	auto temp_1896 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1887 = 1;
			int64_t temp_1888 = param_1;
			int64_t temp_1889 = temp_1887 + temp_1888;
			return temp_1889;
		};
	int64_t temp_1890 = 0;
	int64_t temp_1897 = temp_1890;
	rel_algebra_node temp_1892 = local_pDicNew;
	for (auto local_X = rel_algebra::getUnitIterator(temp_1892); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1891 = 0;
		temp_1897 = temp_1896(temp_1897, temp_1891);
	}
	local_pNewTupleCount = temp_1897;

	auto temp_1908 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_1899 = 1;
			int64_t temp_1900 = param_1;
			int64_t temp_1901 = temp_1899 + temp_1900;
			return temp_1901;
		};
	int64_t temp_1902 = 0;
	int64_t temp_1909 = temp_1902;
	rel_algebra_node temp_1904 = local_pDicNew;
	for (auto local_X = rel_algebra::getUnitIterator(temp_1904); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_1903 = 0;
		temp_1909 = temp_1908(temp_1909, temp_1903);
	}
	local_pTotalTupleCount = temp_1909;

	int64_t temp_1911 = local_dTupleUCount;
	int64_t temp_1912 = local_eTupleUCount;
	int64_t temp_1913 = temp_1911 + temp_1912;
	int64_t temp_1914 = local_eTupleTCount;
	int64_t temp_1915 = temp_1913 + temp_1914;
	int64_t temp_1916 = local_pNewTupleCount;
	int64_t temp_1917 = temp_1915 + temp_1916;
	local_totalVarCount = temp_1917;

	rel_algebra_node temp_1957 = rel_algebra::trueTable();
	rel_algebra_node temp_1919 = local_pDic0to1;
	temp_1957 = rel_algebra::join(temp_1957, temp_1919);
	int64_t temp_1920 = 1;
	int64_t temp_1922 = 0;
	rel_algebra_node temp_1926 = rel_algebra::trueTable();
	int64_t temp_1924 = 0;
	int64_t temp_1925 = 0;
	rel_algebra_node temp_1930 = rel_algebra::filterGreaterThan(temp_1924, temp_1925, temp_1926);
	rel_algebra_node temp_1933 = rel_algebra::trueTable();
	int64_t temp_1931 = 0;
	int64_t temp_1932 = 0;
	rel_algebra_node temp_1937 = rel_algebra::filterLessThanOrEqualTo(temp_1931, temp_1932, temp_1933);
	rel_algebra_node temp_1938 = local_pDic0to2;
	rel_algebra_node temp_1941 = rel_algebra::complement(rel_algebra::divide(temp_1937, rel_algebra::complement(temp_1938)));
	int64_t temp_1942 = 1;
	int64_t temp_1943 = local_totalVarCount;
	int64_t temp_1944 = temp_1942 + temp_1943;
	rel_algebra_node temp_1948 = macro_unaryTranslator(temp_1941, temp_1944);
	rel_algebra_node temp_1951 = rel_algebra::complement(rel_algebra::divide(temp_1930, rel_algebra::complement(temp_1948)));
	rel_algebra_node temp_1956 = generalized_filter_rename(temp_1920, temp_1922)(temp_1951);
	temp_1957 = rel_algebra::join(temp_1957, temp_1956);
	local_pTranslator = temp_1957;

	return result;
}

void gg_datatype_Spec_type4::output_grounder(ostream &os) const
{
	rel_algebra_node temp_1972 = rel_algebra::trueTable();
	rel_algebra_node temp_1966 = rel_algebra::trueTable();
	compact_string temp_1962 = compact_string::make_from("cte");
	rel_algebra_node temp_1963 = database[temp_1962];
	temp_1966 = rel_algebra::join(temp_1966, temp_1963);
	compact_string temp_1964 = compact_string::make_from("cfe");
	rel_algebra_node temp_1965 = database[temp_1964];
	temp_1966 = rel_algebra::join(temp_1966, temp_1965);
	temp_1972 = rel_algebra::join(temp_1972, rel_algebra::complement(temp_1966));
	rel_algebra_node temp_1971 = rel_algebra::trueTable();
	compact_string temp_1967 = compact_string::make_from("ctd");
	rel_algebra_node temp_1968 = database[temp_1967];
	temp_1971 = rel_algebra::join(temp_1971, temp_1968);
	compact_string temp_1969 = compact_string::make_from("cfd");
	rel_algebra_node temp_1970 = database[temp_1969];
	temp_1971 = rel_algebra::join(temp_1971, temp_1970);
	temp_1972 = rel_algebra::join(temp_1972, rel_algebra::complement(temp_1971));
	temp_1972 = rel_algebra::complement(temp_1972);
	if ((!rel_algebra::isEmpty(temp_1972)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_1979 = local_totalVarCount;
		os << temp_1979;
		os << " 10\n";
		rel_algebra_node temp_2002 = local_eDic0to2;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_2002); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_1985 = 2;
			int64_t temp_1987 = local_tuple[temp_1985];
			os << temp_1987;
			os << " ";
			compact_string temp_1992 = compact_string::make_from("arguments");
			int64_t temp_1993 = 0;
			int64_t temp_1995 = local_tuple[temp_1993];
			os << mapFromInt(temp_1992, temp_1995);
			os << "\n";
		}
		compact_string temp_2007 = compact_string::make_from("arguments");
		rel_algebra_node temp_2008 = database[temp_2007];
		rel_algebra_node temp_2009 = local_attacks01;
		rel_algebra_node temp_2010 = local_attacks10;
		compact_string temp_2011 = compact_string::make_from("cfe");
		rel_algebra_node temp_2012 = database[temp_2011];
		compact_string temp_2013 = compact_string::make_from("cte");
		rel_algebra_node temp_2014 = database[temp_2013];
		compact_string temp_2015 = compact_string::make_from("cfd");
		rel_algebra_node temp_2016 = database[temp_2015];
		compact_string temp_2017 = compact_string::make_from("ctd");
		rel_algebra_node temp_2018 = database[temp_2017];
		rel_algebra_node temp_2019 = local_eDic0to2;
		rel_algebra_node temp_2020 = local_eDic1to3;
		rel_algebra_node temp_2021 = local_dDic0to2;
		rel_algebra_node temp_2022 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_2008, temp_2009, temp_2010, temp_2012, temp_2014, temp_2016, temp_2018, temp_2019, temp_2020, temp_2021, temp_2022);
		rel_algebra_node temp_2027 = local_pDic0to2;
		rel_algebra_node temp_2028 = local_eDicU0to3;
		rel_algebra_node temp_2029 = local_dDic0to4;
		compact_string temp_2030 = compact_string::make_from("cfd");
		rel_algebra_node temp_2031 = database[temp_2030];
		compact_string temp_2032 = compact_string::make_from("cfe");
		rel_algebra_node temp_2033 = database[temp_2032];
		subtree_out->output_range_clauses(os, temp_2027, temp_2028, temp_2029, temp_2031, temp_2033);
		os << "module ";
		int64_t temp_2040 = 2;
		int64_t temp_2041 = local_pNewTupleCount;
		int64_t temp_2042 = temp_2040 * temp_2041;
		int64_t temp_2043 = local_totalVarCount;
		int64_t temp_2044 = temp_2042 + temp_2043;
		os << temp_2044;
		os << " ";
		int64_t temp_2049 = local_pTotalTupleCount;
		os << temp_2049;
		rel_algebra_node temp_2060 = local_pDic0to2;
		for (auto local_X = rel_algebra::getUnitIterator(temp_2060); !local_X.atEnd(); ++local_X)
		{
			os << " ";
			int64_t temp_2053 = 2;
			int64_t temp_2055 = local_X[temp_2053];
			int64_t temp_2056 = local_pTotalTupleCount;
			int64_t temp_2057 = temp_2055 + temp_2056;
			os << temp_2057;
		}
		os << "\n";
		compact_string temp_2067 = compact_string::make_from("arguments");
		rel_algebra_node temp_2068 = database[temp_2067];
		rel_algebra_node temp_2069 = local_attacks01;
		rel_algebra_node temp_2070 = local_attacks10;
		compact_string temp_2071 = compact_string::make_from("cfe");
		rel_algebra_node temp_2072 = database[temp_2071];
		compact_string temp_2073 = compact_string::make_from("cte");
		rel_algebra_node temp_2074 = database[temp_2073];
		compact_string temp_2075 = compact_string::make_from("cfd");
		rel_algebra_node temp_2076 = database[temp_2075];
		compact_string temp_2077 = compact_string::make_from("ctd");
		rel_algebra_node temp_2078 = database[temp_2077];
		rel_algebra_node temp_2079 = local_eDic0to2;
		rel_algebra_node temp_2080 = local_eDic1to3;
		rel_algebra_node temp_2081 = local_dDic0to2;
		rel_algebra_node temp_2082 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_2068, temp_2069, temp_2070, temp_2072, temp_2074, temp_2076, temp_2078, temp_2079, temp_2080, temp_2081, temp_2082);
		rel_algebra_node temp_2087 = local_pDic0to2;
		rel_algebra_node temp_2088 = local_eDicU0to3;
		rel_algebra_node temp_2089 = local_dDic0to4;
		compact_string temp_2090 = compact_string::make_from("cfd");
		rel_algebra_node temp_2091 = database[temp_2090];
		compact_string temp_2092 = compact_string::make_from("cfe");
		rel_algebra_node temp_2093 = database[temp_2092];
		subtree_out->output_range_clauses(os, temp_2087, temp_2088, temp_2089, temp_2091, temp_2093);
		auto temp_2146 = [=](rel_algebra_node param_1, rel_algebra_node param_2) -> rel_algebra_node
			{
				rel_algebra_node temp_2100 = rel_algebra::trueTable();
				rel_algebra_node temp_2098 = param_1;
				temp_2100 = rel_algebra::join(temp_2100, rel_algebra::complement(temp_2098));
				rel_algebra_node temp_2099 = param_2;
				temp_2100 = rel_algebra::join(temp_2100, rel_algebra::complement(temp_2099));
				temp_2100 = rel_algebra::complement(temp_2100);
				return temp_2100;
			};
		rel_algebra_node temp_2101 = rel_algebra::trueTable();
		temp_2101 = rel_algebra::complement(temp_2101);
		rel_algebra_node temp_2147 = temp_2101;
		rel_algebra_node temp_2142 = local_pTranslator;
		for (auto local_X = rel_algebra::getUnitIterator(temp_2142); !local_X.atEnd(); ++local_X)
		{
			rel_algebra_node temp_2141 = rel_algebra::trueTable();
			rel_algebra_node temp_2108 = rel_algebra::trueTable();
			int64_t temp_2102 = 3;
			int64_t temp_2103 = 2;
			int64_t temp_2105 = local_X[temp_2103];
			int64_t temp_2106 = local_pTotalTupleCount;
			int64_t temp_2107 = temp_2105 + temp_2106;
			rel_algebra_node temp_2112 = rel_algebra::filterEqualTo(temp_2102, temp_2107, temp_2108);
			temp_2141 = rel_algebra::join(temp_2141, temp_2112);
			rel_algebra_node temp_2117 = rel_algebra::trueTable();
			int64_t temp_2113 = 2;
			int64_t temp_2114 = 1;
			int64_t temp_2116 = local_X[temp_2114];
			rel_algebra_node temp_2121 = rel_algebra::filterEqualTo(temp_2113, temp_2116, temp_2117);
			temp_2141 = rel_algebra::join(temp_2141, temp_2121);
			rel_algebra_node temp_2126 = rel_algebra::trueTable();
			int64_t temp_2122 = 1;
			int64_t temp_2123 = 2;
			int64_t temp_2125 = local_X[temp_2123];
			rel_algebra_node temp_2130 = rel_algebra::filterEqualTo(temp_2122, temp_2125, temp_2126);
			temp_2141 = rel_algebra::join(temp_2141, temp_2130);
			rel_algebra_node temp_2136 = rel_algebra::trueTable();
			int64_t temp_2131 = 0;
			int64_t temp_2132 = 0;
			int64_t temp_2134 = local_X[temp_2132];
			int64_t temp_2135 = -temp_2134;
			rel_algebra_node temp_2140 = rel_algebra::filterEqualTo(temp_2131, temp_2135, temp_2136);
			temp_2141 = rel_algebra::join(temp_2141, temp_2140);
			temp_2147 = temp_2146(temp_2147, temp_2141);
		}
		subtree_out->output_unary_proper_subset_clauses(os, temp_2147);
		os << "endmodule\n";
		os << "falsify 0";
		rel_algebra_node temp_2162 = local_pDic0to1;
		for (auto local_X = rel_algebra::getUnitIterator(temp_2162); !local_X.atEnd(); ++local_X)
		{
			os << " ";
			int64_t temp_2157 = 1;
			int64_t temp_2159 = local_X[temp_2157];
			os << temp_2159;
		}
		os << "\n";
	}
}

string gg_datatype_Spec_type4::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "semistable";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type4::gg_datatype_Spec_type4(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_1448 = compact_string::make_from("cfe");
	rel_algebra_node temp_1451 = subtree_r->local_cf;
	set_database_atom(temp_1448, temp_1451);

	compact_string temp_1453 = compact_string::make_from("cte");
	rel_algebra_node temp_1456 = subtree_r->local_ct;
	set_database_atom(temp_1453, temp_1456);

	compact_string temp_1458 = compact_string::make_from("cfd");
	rel_algebra_node temp_1460 = rel_algebra::trueTable();
	temp_1460 = rel_algebra::complement(temp_1460);
	set_database_atom(temp_1458, temp_1460);

	compact_string temp_1462 = compact_string::make_from("ctd");
	rel_algebra_node temp_1464 = rel_algebra::trueTable();
	temp_1464 = rel_algebra::complement(temp_1464);
	set_database_atom(temp_1462, temp_1464);

	compact_string temp_1466 = compact_string::make_from("attacks");
	rel_algebra_node temp_1467 = database[temp_1466];
	local_attacks01 = temp_1467;

	int64_t temp_1469 = 0;
	int64_t temp_1471 = 2;
	rel_algebra_node temp_1473 = local_attacks01;
	rel_algebra_node temp_1478 = generalized_filter_rename(temp_1469, temp_1471)(temp_1473);
	local_attacks21 = temp_1478;

	int64_t temp_1480 = 2;
	int64_t temp_1482 = 1;
	int64_t temp_1484 = 1;
	int64_t temp_1486 = 0;
	rel_algebra_node temp_1488 = local_attacks21;
	rel_algebra_node temp_1493 = generalized_filter_rename(temp_1484, temp_1486)(temp_1488);
	rel_algebra_node temp_1498 = generalized_filter_rename(temp_1480, temp_1482)(temp_1493);
	local_attacks10 = temp_1498;

	int64_t temp_1500 = 0;
	int64_t temp_1502 = 2;
	compact_string temp_1504 = compact_string::make_from("arguments");
	rel_algebra_node temp_1505 = database[temp_1504];
	rel_algebra_node temp_1510 = generalized_filter_equals(temp_1500, temp_1502)(temp_1505);
	local_args02 = temp_1510;
}

bool gg_datatype_Spec_type5::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_2231 = compact_string::make_from("cfe");
	rel_algebra_node temp_2263 = rel_algebra::trueTable();
	compact_string temp_2233 = compact_string::make_from("arguments");
	rel_algebra_node temp_2234 = database[temp_2233];
	temp_2263 = rel_algebra::join(temp_2263, temp_2234);
	rel_algebra_node temp_2262 = rel_algebra::trueTable();
	compact_string temp_2235 = compact_string::make_from("cfe");
	rel_algebra_node temp_2236 = database[temp_2235];
	temp_2262 = rel_algebra::join(temp_2262, rel_algebra::complement(temp_2236));
	rel_algebra_node temp_2239 = rel_algebra::trueTable();
	int64_t temp_2237 = 0;
	int64_t temp_2238 = 0;
	rel_algebra_node temp_2243 = rel_algebra::filterLessThanOrEqualTo(temp_2237, temp_2238, temp_2239);
	rel_algebra_node temp_2258 = rel_algebra::trueTable();
	rel_algebra_node temp_2246 = rel_algebra::trueTable();
	rel_algebra_node temp_2244 = local_attacks01;
	temp_2246 = rel_algebra::join(temp_2246, rel_algebra::complement(temp_2244));
	rel_algebra_node temp_2245 = local_attacks10;
	temp_2246 = rel_algebra::join(temp_2246, rel_algebra::complement(temp_2245));
	temp_2246 = rel_algebra::complement(temp_2246);
	temp_2258 = rel_algebra::join(temp_2258, temp_2246);
	int64_t temp_2247 = 0;
	int64_t temp_2249 = 1;
	compact_string temp_2251 = compact_string::make_from("cte");
	rel_algebra_node temp_2252 = database[temp_2251];
	rel_algebra_node temp_2257 = generalized_filter_rename(temp_2247, temp_2249)(temp_2252);
	temp_2258 = rel_algebra::join(temp_2258, temp_2257);
	rel_algebra_node temp_2261 = rel_algebra::complement(rel_algebra::divide(temp_2243, rel_algebra::complement(temp_2258)));
	temp_2262 = rel_algebra::join(temp_2262, rel_algebra::complement(temp_2261));
	temp_2262 = rel_algebra::complement(temp_2262);
	temp_2263 = rel_algebra::join(temp_2263, temp_2262);
	result = result || (database[temp_2231] != temp_2263);
	set_database_atom(temp_2231, temp_2263);

	return result;
}

bool gg_datatype_Spec_type5::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_2291 = rel_algebra::trueTable();
	compact_string temp_2266 = compact_string::make_from("cte");
	rel_algebra_node temp_2267 = database[temp_2266];
	temp_2291 = rel_algebra::join(temp_2291, rel_algebra::complement(temp_2267));
	rel_algebra_node temp_2270 = rel_algebra::trueTable();
	int64_t temp_2268 = 0;
	int64_t temp_2269 = 0;
	rel_algebra_node temp_2274 = rel_algebra::filterLessThanOrEqualTo(temp_2268, temp_2269, temp_2270);
	rel_algebra_node temp_2287 = rel_algebra::trueTable();
	rel_algebra_node temp_2275 = local_attacks10;
	temp_2287 = rel_algebra::join(temp_2287, temp_2275);
	int64_t temp_2276 = 0;
	int64_t temp_2278 = 1;
	compact_string temp_2280 = compact_string::make_from("cte");
	rel_algebra_node temp_2281 = database[temp_2280];
	rel_algebra_node temp_2286 = generalized_filter_rename(temp_2276, temp_2278)(temp_2281);
	temp_2287 = rel_algebra::join(temp_2287, temp_2286);
	rel_algebra_node temp_2290 = rel_algebra::complement(rel_algebra::divide(temp_2274, rel_algebra::complement(temp_2287)));
	temp_2291 = rel_algebra::join(temp_2291, rel_algebra::complement(temp_2290));
	temp_2291 = rel_algebra::complement(temp_2291);
	local_ctp = temp_2291;

	rel_algebra_node temp_2319 = rel_algebra::trueTable();
	compact_string temp_2293 = compact_string::make_from("cfe");
	rel_algebra_node temp_2294 = database[temp_2293];
	temp_2319 = rel_algebra::join(temp_2319, temp_2294);
	rel_algebra_node temp_2297 = rel_algebra::trueTable();
	int64_t temp_2295 = 0;
	int64_t temp_2296 = 0;
	rel_algebra_node temp_2301 = rel_algebra::filterLessThanOrEqualTo(temp_2295, temp_2296, temp_2297);
	rel_algebra_node temp_2315 = rel_algebra::trueTable();
	rel_algebra_node temp_2302 = local_attacks10;
	rel_algebra_node temp_2303 = rel_algebra::complement(temp_2302);
	temp_2315 = rel_algebra::join(temp_2315, rel_algebra::complement(temp_2303));
	int64_t temp_2304 = 0;
	int64_t temp_2306 = 1;
	compact_string temp_2308 = compact_string::make_from("cfe");
	rel_algebra_node temp_2309 = database[temp_2308];
	rel_algebra_node temp_2314 = generalized_filter_rename(temp_2304, temp_2306)(temp_2309);
	temp_2315 = rel_algebra::join(temp_2315, rel_algebra::complement(temp_2314));
	temp_2315 = rel_algebra::complement(temp_2315);
	rel_algebra_node temp_2318 = rel_algebra::divide(temp_2301, temp_2315);
	temp_2319 = rel_algebra::join(temp_2319, temp_2318);
	local_cfp = temp_2319;

	rel_algebra_node temp_2327 = rel_algebra::trueTable();
	compact_string temp_2321 = compact_string::make_from("arguments");
	rel_algebra_node temp_2322 = database[temp_2321];
	temp_2327 = rel_algebra::join(temp_2327, temp_2322);
	rel_algebra_node temp_2323 = local_cfp;
	rel_algebra_node temp_2324 = rel_algebra::complement(temp_2323);
	temp_2327 = rel_algebra::join(temp_2327, temp_2324);
	rel_algebra_node temp_2325 = local_ctp;
	rel_algebra_node temp_2326 = rel_algebra::complement(temp_2325);
	temp_2327 = rel_algebra::join(temp_2327, temp_2326);
	local_cup = temp_2327;

	rel_algebra_node temp_2334 = rel_algebra::trueTable();
	compact_string temp_2329 = compact_string::make_from("arguments");
	rel_algebra_node temp_2330 = database[temp_2329];
	temp_2334 = rel_algebra::join(temp_2334, temp_2330);
	compact_string temp_2331 = compact_string::make_from("cfe");
	rel_algebra_node temp_2332 = database[temp_2331];
	rel_algebra_node temp_2333 = rel_algebra::complement(temp_2332);
	temp_2334 = rel_algebra::join(temp_2334, temp_2333);
	int64_t temp_2335 = 1;
	rel_algebra_node temp_2339 = macro_unaryTranslator(temp_2334, temp_2335);
	local_eDicTU = temp_2339;

	rel_algebra_node temp_2346 = rel_algebra::trueTable();
	compact_string temp_2341 = compact_string::make_from("arguments");
	rel_algebra_node temp_2342 = database[temp_2341];
	temp_2346 = rel_algebra::join(temp_2346, temp_2342);
	compact_string temp_2343 = compact_string::make_from("cfe");
	rel_algebra_node temp_2344 = database[temp_2343];
	rel_algebra_node temp_2345 = rel_algebra::complement(temp_2344);
	temp_2346 = rel_algebra::join(temp_2346, temp_2345);
	int64_t temp_2367 = std::numeric_limits<ValueType>::min();
	int64_t temp_2347 = 1;
	temp_2367 = std::max(temp_2367, temp_2347);
	rel_algebra_node temp_2354 = rel_algebra::trueTable();
	int64_t temp_2352 = 0;
	int64_t temp_2353 = 0;
	rel_algebra_node temp_2358 = rel_algebra::filterLessThanOrEqualTo(temp_2352, temp_2353, temp_2354);
	rel_algebra_node temp_2359 = local_eDicTU;
	rel_algebra_node temp_2362 = rel_algebra::complement(rel_algebra::divide(temp_2358, rel_algebra::complement(temp_2359)));
	int64_t temp_2365 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_2362); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_2349 = 0;
		int64_t temp_2351 = local_X[temp_2349];
		temp_2365 = std::max(temp_2365, temp_2351);
	}
	temp_2367 = std::max(temp_2367, temp_2365);
	rel_algebra_node temp_2371 = macro_unaryTranslator(temp_2346, temp_2367);
	local_pDicU = temp_2371;

	int64_t temp_2373 = 1;
	int64_t temp_2375 = 0;
	rel_algebra_node temp_2379 = rel_algebra::trueTable();
	int64_t temp_2377 = 0;
	int64_t temp_2378 = 0;
	rel_algebra_node temp_2383 = rel_algebra::filterGreaterThan(temp_2377, temp_2378, temp_2379);
	rel_algebra_node temp_2384 = local_eDicTU;
	rel_algebra_node temp_2387 = rel_algebra::complement(rel_algebra::divide(temp_2383, rel_algebra::complement(temp_2384)));
	rel_algebra_node temp_2392 = generalized_filter_rename(temp_2373, temp_2375)(temp_2387);
	local_eDicTU0to2 = temp_2392;

	int64_t temp_2394 = 2;
	int64_t temp_2396 = 3;
	rel_algebra_node temp_2400 = rel_algebra::trueTable();
	int64_t temp_2398 = 0;
	int64_t temp_2399 = 0;
	rel_algebra_node temp_2404 = rel_algebra::filterGreaterThan(temp_2398, temp_2399, temp_2400);
	rel_algebra_node temp_2405 = local_eDicTU;
	rel_algebra_node temp_2408 = rel_algebra::complement(rel_algebra::divide(temp_2404, rel_algebra::complement(temp_2405)));
	rel_algebra_node temp_2413 = generalized_filter_rename(temp_2394, temp_2396)(temp_2408);
	local_eDicTU1to3 = temp_2413;

	int64_t temp_2415 = 1;
	int64_t temp_2417 = 0;
	rel_algebra_node temp_2421 = rel_algebra::trueTable();
	int64_t temp_2419 = 0;
	int64_t temp_2420 = 0;
	rel_algebra_node temp_2425 = rel_algebra::filterGreaterThan(temp_2419, temp_2420, temp_2421);
	rel_algebra_node temp_2426 = local_pDicU;
	rel_algebra_node temp_2429 = rel_algebra::complement(rel_algebra::divide(temp_2425, rel_algebra::complement(temp_2426)));
	rel_algebra_node temp_2434 = generalized_filter_rename(temp_2415, temp_2417)(temp_2429);
	local_pDicU0to2 = temp_2434;

	int64_t temp_2436 = 2;
	int64_t temp_2438 = 3;
	rel_algebra_node temp_2440 = local_pDicU0to2;
	rel_algebra_node temp_2445 = generalized_filter_rename(temp_2436, temp_2438)(temp_2440);
	local_pDicU0to3 = temp_2445;

	int64_t temp_2447 = 2;
	int64_t temp_2449 = 3;
	rel_algebra_node temp_2453 = rel_algebra::trueTable();
	int64_t temp_2451 = 0;
	int64_t temp_2452 = 0;
	rel_algebra_node temp_2457 = rel_algebra::filterGreaterThan(temp_2451, temp_2452, temp_2453);
	rel_algebra_node temp_2458 = local_pDicU;
	rel_algebra_node temp_2461 = rel_algebra::complement(rel_algebra::divide(temp_2457, rel_algebra::complement(temp_2458)));
	rel_algebra_node temp_2466 = generalized_filter_rename(temp_2447, temp_2449)(temp_2461);
	local_pDicU1to3 = temp_2466;

	auto temp_2477 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_2468 = 1;
			int64_t temp_2469 = param_1;
			int64_t temp_2470 = temp_2468 + temp_2469;
			return temp_2470;
		};
	int64_t temp_2471 = 0;
	int64_t temp_2478 = temp_2471;
	rel_algebra_node temp_2473 = local_eDicTU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_2473); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_2472 = 0;
		temp_2478 = temp_2477(temp_2478, temp_2472);
	}
	local_eTupleTUCount = temp_2478;

	auto temp_2489 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_2480 = 1;
			int64_t temp_2481 = param_1;
			int64_t temp_2482 = temp_2480 + temp_2481;
			return temp_2482;
		};
	int64_t temp_2483 = 0;
	int64_t temp_2490 = temp_2483;
	rel_algebra_node temp_2485 = local_pDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_2485); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_2484 = 0;
		temp_2490 = temp_2489(temp_2490, temp_2484);
	}
	local_pTupleUCount = temp_2490;

	int64_t temp_2492 = local_eTupleTUCount;
	int64_t temp_2493 = local_pTupleUCount;
	int64_t temp_2494 = temp_2492 + temp_2493;
	local_totalVarCount = temp_2494;

	return result;
}

void gg_datatype_Spec_type5::output_grounder(ostream &os) const
{
	rel_algebra_node temp_2503 = rel_algebra::trueTable();
	compact_string temp_2499 = compact_string::make_from("cte");
	rel_algebra_node temp_2500 = database[temp_2499];
	temp_2503 = rel_algebra::join(temp_2503, temp_2500);
	compact_string temp_2501 = compact_string::make_from("cfe");
	rel_algebra_node temp_2502 = database[temp_2501];
	temp_2503 = rel_algebra::join(temp_2503, temp_2502);
	if ((!rel_algebra::isEmpty(temp_2503)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_2510 = local_totalVarCount;
		os << temp_2510;
		os << " 10\n";
		rel_algebra_node temp_2533 = local_eDicTU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_2533); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_2516 = 2;
			int64_t temp_2518 = local_tuple[temp_2516];
			os << temp_2518;
			os << " ";
			compact_string temp_2523 = compact_string::make_from("arguments");
			int64_t temp_2524 = 1;
			int64_t temp_2526 = local_tuple[temp_2524];
			os << mapFromInt(temp_2523, temp_2526);
			os << "\n";
		}
		rel_algebra_node temp_2538 = local_attacks01;
		rel_algebra_node temp_2539 = local_eDicTU0to2;
		rel_algebra_node temp_2540 = local_eDicTU1to3;
		rel_algebra_node temp_2541 = local_pDicU0to2;
		rel_algebra_node temp_2542 = local_pDicU0to3;
		rel_algebra_node temp_2543 = local_pDicU1to3;
		compact_string temp_2544 = compact_string::make_from("cte");
		rel_algebra_node temp_2545 = database[temp_2544];
		subtree_out->output_stage_semantics(os, temp_2538, temp_2539, temp_2540, temp_2541, temp_2542, temp_2543, temp_2545);
		os << "module ";
		int64_t temp_2552 = 2;
		int64_t temp_2553 = local_pTupleUCount;
		int64_t temp_2554 = temp_2552 * temp_2553;
		int64_t temp_2555 = local_totalVarCount;
		int64_t temp_2556 = temp_2554 + temp_2555;
		os << temp_2556;
		os << " ";
		int64_t temp_2561 = local_pTupleUCount;
		os << temp_2561;
		rel_algebra_node temp_2572 = local_pDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_2572); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_2565 = local_pTupleUCount;
			int64_t temp_2566 = 2;
			int64_t temp_2568 = local_tuple[temp_2566];
			int64_t temp_2569 = temp_2565 + temp_2568;
			os << temp_2569;
		}
		os << "\n";
		rel_algebra_node temp_2579 = local_attacks01;
		rel_algebra_node temp_2580 = local_eDicTU0to2;
		rel_algebra_node temp_2581 = local_eDicTU1to3;
		rel_algebra_node temp_2582 = local_pDicU0to2;
		rel_algebra_node temp_2583 = local_pDicU0to3;
		rel_algebra_node temp_2584 = local_pDicU1to3;
		compact_string temp_2585 = compact_string::make_from("cte");
		rel_algebra_node temp_2586 = database[temp_2585];
		subtree_out->output_stage_semantics(os, temp_2579, temp_2580, temp_2581, temp_2582, temp_2583, temp_2584, temp_2586);
		auto temp_2643 = [=](rel_algebra_node param_1, rel_algebra_node param_2) -> rel_algebra_node
			{
				rel_algebra_node temp_2593 = rel_algebra::trueTable();
				rel_algebra_node temp_2591 = param_1;
				temp_2593 = rel_algebra::join(temp_2593, rel_algebra::complement(temp_2591));
				rel_algebra_node temp_2592 = param_2;
				temp_2593 = rel_algebra::join(temp_2593, rel_algebra::complement(temp_2592));
				temp_2593 = rel_algebra::complement(temp_2593);
				return temp_2593;
			};
		rel_algebra_node temp_2594 = rel_algebra::trueTable();
		temp_2594 = rel_algebra::complement(temp_2594);
		rel_algebra_node temp_2644 = temp_2594;
		rel_algebra_node temp_2639 = local_pDicU;
		for (auto local_X = rel_algebra::getUnitIterator(temp_2639); !local_X.atEnd(); ++local_X)
		{
			rel_algebra_node temp_2638 = rel_algebra::trueTable();
			rel_algebra_node temp_2603 = rel_algebra::trueTable();
			int64_t temp_2595 = 3;
			int64_t temp_2596 = 2;
			int64_t temp_2597 = local_pTupleUCount;
			int64_t temp_2598 = temp_2596 * temp_2597;
			int64_t temp_2599 = 2;
			int64_t temp_2601 = local_X[temp_2599];
			int64_t temp_2602 = temp_2598 + temp_2601;
			rel_algebra_node temp_2607 = rel_algebra::filterEqualTo(temp_2595, temp_2602, temp_2603);
			temp_2638 = rel_algebra::join(temp_2638, temp_2607);
			rel_algebra_node temp_2612 = rel_algebra::trueTable();
			int64_t temp_2608 = 2;
			int64_t temp_2609 = 2;
			int64_t temp_2611 = local_X[temp_2609];
			rel_algebra_node temp_2616 = rel_algebra::filterEqualTo(temp_2608, temp_2611, temp_2612);
			temp_2638 = rel_algebra::join(temp_2638, temp_2616);
			rel_algebra_node temp_2623 = rel_algebra::trueTable();
			int64_t temp_2617 = 1;
			int64_t temp_2618 = local_pTupleUCount;
			int64_t temp_2619 = 2;
			int64_t temp_2621 = local_X[temp_2619];
			int64_t temp_2622 = temp_2618 + temp_2621;
			rel_algebra_node temp_2627 = rel_algebra::filterEqualTo(temp_2617, temp_2622, temp_2623);
			temp_2638 = rel_algebra::join(temp_2638, temp_2627);
			rel_algebra_node temp_2633 = rel_algebra::trueTable();
			int64_t temp_2628 = 0;
			int64_t temp_2629 = 1;
			int64_t temp_2631 = local_X[temp_2629];
			int64_t temp_2632 = -temp_2631;
			rel_algebra_node temp_2637 = rel_algebra::filterEqualTo(temp_2628, temp_2632, temp_2633);
			temp_2638 = rel_algebra::join(temp_2638, temp_2637);
			temp_2644 = temp_2643(temp_2644, temp_2638);
		}
		subtree_out->output_unary_proper_subset_clauses(os, temp_2644);
		os << "endmodule\n";
		os << "falsify 0";
		rel_algebra_node temp_2659 = local_pDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_2659); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_2654 = 2;
			int64_t temp_2656 = local_tuple[temp_2654];
			os << temp_2656;
		}
		os << "\n";
	}
}

string gg_datatype_Spec_type5::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "stage";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type5::gg_datatype_Spec_type5(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_2187 = compact_string::make_from("cfe");
	rel_algebra_node temp_2190 = subtree_r->local_cf;
	set_database_atom(temp_2187, temp_2190);

	compact_string temp_2192 = compact_string::make_from("cte");
	rel_algebra_node temp_2195 = subtree_r->local_ct;
	set_database_atom(temp_2192, temp_2195);

	compact_string temp_2197 = compact_string::make_from("attacks");
	rel_algebra_node temp_2198 = database[temp_2197];
	local_attacks01 = temp_2198;

	int64_t temp_2200 = 0;
	int64_t temp_2202 = 2;
	rel_algebra_node temp_2204 = local_attacks01;
	rel_algebra_node temp_2209 = generalized_filter_rename(temp_2200, temp_2202)(temp_2204);
	local_attacks21 = temp_2209;

	int64_t temp_2211 = 2;
	int64_t temp_2213 = 1;
	int64_t temp_2215 = 1;
	int64_t temp_2217 = 0;
	rel_algebra_node temp_2219 = local_attacks21;
	rel_algebra_node temp_2224 = generalized_filter_rename(temp_2215, temp_2217)(temp_2219);
	rel_algebra_node temp_2229 = generalized_filter_rename(temp_2211, temp_2213)(temp_2224);
	local_attacks10 = temp_2229;
}

bool gg_datatype_Spec_type6::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_2748 = compact_string::make_from("cfe");
	rel_algebra_node temp_2764 = rel_algebra::trueTable();
	compact_string temp_2750 = compact_string::make_from("arguments");
	rel_algebra_node temp_2751 = database[temp_2750];
	temp_2764 = rel_algebra::join(temp_2764, temp_2751);
	rel_algebra_node temp_2763 = rel_algebra::trueTable();
	compact_string temp_2752 = compact_string::make_from("cfe");
	rel_algebra_node temp_2753 = database[temp_2752];
	temp_2763 = rel_algebra::join(temp_2763, rel_algebra::complement(temp_2753));
	rel_algebra_node temp_2754 = local_attacks01;
	rel_algebra_node temp_2755 = local_attacks10;
	compact_string temp_2756 = compact_string::make_from("cte");
	rel_algebra_node temp_2757 = database[temp_2756];
	compact_string temp_2758 = compact_string::make_from("cfd");
	rel_algebra_node temp_2759 = database[temp_2758];
	rel_algebra_node temp_2762 = macro_completion_cfe_bound(temp_2754, temp_2755, temp_2757, temp_2759);
	temp_2763 = rel_algebra::join(temp_2763, rel_algebra::complement(temp_2762));
	temp_2763 = rel_algebra::complement(temp_2763);
	temp_2764 = rel_algebra::join(temp_2764, temp_2763);
	result = result || (database[temp_2748] != temp_2764);
	set_database_atom(temp_2748, temp_2764);

	compact_string temp_2766 = compact_string::make_from("cte");
	rel_algebra_node temp_2785 = rel_algebra::trueTable();
	compact_string temp_2768 = compact_string::make_from("arguments");
	rel_algebra_node temp_2769 = database[temp_2768];
	temp_2785 = rel_algebra::join(temp_2785, temp_2769);
	rel_algebra_node temp_2784 = rel_algebra::trueTable();
	compact_string temp_2770 = compact_string::make_from("cte");
	rel_algebra_node temp_2771 = database[temp_2770];
	temp_2784 = rel_algebra::join(temp_2784, rel_algebra::complement(temp_2771));
	compact_string temp_2772 = compact_string::make_from("arguments");
	rel_algebra_node temp_2773 = database[temp_2772];
	rel_algebra_node temp_2774 = local_args02;
	rel_algebra_node temp_2775 = local_attacks10;
	rel_algebra_node temp_2776 = local_attacks21;
	compact_string temp_2777 = compact_string::make_from("cfe");
	rel_algebra_node temp_2778 = database[temp_2777];
	compact_string temp_2779 = compact_string::make_from("ctd");
	rel_algebra_node temp_2780 = database[temp_2779];
	rel_algebra_node temp_2783 = macro_completion_cte_bound(temp_2773, temp_2774, temp_2775, temp_2776, temp_2778, temp_2780);
	temp_2784 = rel_algebra::join(temp_2784, rel_algebra::complement(temp_2783));
	temp_2784 = rel_algebra::complement(temp_2784);
	temp_2785 = rel_algebra::join(temp_2785, temp_2784);
	result = result || (database[temp_2766] != temp_2785);
	set_database_atom(temp_2766, temp_2785);

	compact_string temp_2787 = compact_string::make_from("cfd");
	rel_algebra_node temp_2806 = rel_algebra::trueTable();
	compact_string temp_2789 = compact_string::make_from("arguments");
	rel_algebra_node temp_2790 = database[temp_2789];
	temp_2806 = rel_algebra::join(temp_2806, temp_2790);
	rel_algebra_node temp_2805 = rel_algebra::trueTable();
	compact_string temp_2791 = compact_string::make_from("cfd");
	rel_algebra_node temp_2792 = database[temp_2791];
	temp_2805 = rel_algebra::join(temp_2805, rel_algebra::complement(temp_2792));
	compact_string temp_2793 = compact_string::make_from("arguments");
	rel_algebra_node temp_2794 = database[temp_2793];
	rel_algebra_node temp_2795 = local_args02;
	rel_algebra_node temp_2796 = local_attacks10;
	rel_algebra_node temp_2797 = local_attacks21;
	compact_string temp_2798 = compact_string::make_from("cfe");
	rel_algebra_node temp_2799 = database[temp_2798];
	compact_string temp_2800 = compact_string::make_from("ctd");
	rel_algebra_node temp_2801 = database[temp_2800];
	rel_algebra_node temp_2804 = macro_completion_cfd_bound(temp_2794, temp_2795, temp_2796, temp_2797, temp_2799, temp_2801);
	temp_2805 = rel_algebra::join(temp_2805, rel_algebra::complement(temp_2804));
	temp_2805 = rel_algebra::complement(temp_2805);
	temp_2806 = rel_algebra::join(temp_2806, temp_2805);
	result = result || (database[temp_2787] != temp_2806);
	set_database_atom(temp_2787, temp_2806);

	compact_string temp_2808 = compact_string::make_from("ctd");
	rel_algebra_node temp_2822 = rel_algebra::trueTable();
	compact_string temp_2810 = compact_string::make_from("arguments");
	rel_algebra_node temp_2811 = database[temp_2810];
	temp_2822 = rel_algebra::join(temp_2822, temp_2811);
	rel_algebra_node temp_2821 = rel_algebra::trueTable();
	compact_string temp_2812 = compact_string::make_from("ctd");
	rel_algebra_node temp_2813 = database[temp_2812];
	temp_2821 = rel_algebra::join(temp_2821, rel_algebra::complement(temp_2813));
	rel_algebra_node temp_2814 = local_attacks01;
	rel_algebra_node temp_2815 = local_attacks10;
	compact_string temp_2816 = compact_string::make_from("cte");
	rel_algebra_node temp_2817 = database[temp_2816];
	rel_algebra_node temp_2820 = macro_completion_ctd_bound(temp_2814, temp_2815, temp_2817);
	temp_2821 = rel_algebra::join(temp_2821, rel_algebra::complement(temp_2820));
	temp_2821 = rel_algebra::complement(temp_2821);
	temp_2822 = rel_algebra::join(temp_2822, temp_2821);
	result = result || (database[temp_2808] != temp_2822);
	set_database_atom(temp_2808, temp_2822);

	return result;
}

bool gg_datatype_Spec_type6::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_2833 = rel_algebra::trueTable();
	compact_string temp_2825 = compact_string::make_from("arguments");
	rel_algebra_node temp_2826 = database[temp_2825];
	temp_2833 = rel_algebra::join(temp_2833, temp_2826);
	compact_string temp_2827 = compact_string::make_from("cfe");
	rel_algebra_node temp_2828 = database[temp_2827];
	rel_algebra_node temp_2829 = rel_algebra::complement(temp_2828);
	temp_2833 = rel_algebra::join(temp_2833, temp_2829);
	compact_string temp_2830 = compact_string::make_from("cte");
	rel_algebra_node temp_2831 = database[temp_2830];
	rel_algebra_node temp_2832 = rel_algebra::complement(temp_2831);
	temp_2833 = rel_algebra::join(temp_2833, temp_2832);
	int64_t temp_2834 = 1;
	rel_algebra_node temp_2838 = macro_unaryTranslator(temp_2833, temp_2834);
	local_eDicU = temp_2838;

	int64_t temp_2860 = std::numeric_limits<ValueType>::min();
	int64_t temp_2840 = 1;
	temp_2860 = std::max(temp_2860, temp_2840);
	rel_algebra_node temp_2847 = rel_algebra::trueTable();
	int64_t temp_2845 = 0;
	int64_t temp_2846 = 0;
	rel_algebra_node temp_2851 = rel_algebra::filterLessThanOrEqualTo(temp_2845, temp_2846, temp_2847);
	rel_algebra_node temp_2852 = local_eDicU;
	rel_algebra_node temp_2855 = rel_algebra::complement(rel_algebra::divide(temp_2851, rel_algebra::complement(temp_2852)));
	int64_t temp_2858 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_2855); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_2842 = 0;
		int64_t temp_2844 = local_X[temp_2842];
		temp_2858 = std::max(temp_2858, temp_2844);
	}
	temp_2860 = std::max(temp_2860, temp_2858);
	local_afterEDicU = temp_2860;

	compact_string temp_2862 = compact_string::make_from("cte");
	rel_algebra_node temp_2863 = database[temp_2862];
	int64_t temp_2864 = local_afterEDicU;
	rel_algebra_node temp_2868 = macro_unaryTranslator(temp_2863, temp_2864);
	local_eDicT = temp_2868;

	rel_algebra_node temp_2872 = rel_algebra::trueTable();
	rel_algebra_node temp_2870 = local_eDicU;
	temp_2872 = rel_algebra::join(temp_2872, rel_algebra::complement(temp_2870));
	rel_algebra_node temp_2871 = local_eDicT;
	temp_2872 = rel_algebra::join(temp_2872, rel_algebra::complement(temp_2871));
	temp_2872 = rel_algebra::complement(temp_2872);
	local_eDicTU = temp_2872;

	int64_t temp_2894 = std::numeric_limits<ValueType>::min();
	int64_t temp_2874 = local_afterEDicU;
	temp_2894 = std::max(temp_2894, temp_2874);
	rel_algebra_node temp_2881 = rel_algebra::trueTable();
	int64_t temp_2879 = 0;
	int64_t temp_2880 = 0;
	rel_algebra_node temp_2885 = rel_algebra::filterLessThanOrEqualTo(temp_2879, temp_2880, temp_2881);
	rel_algebra_node temp_2886 = local_eDicTU;
	rel_algebra_node temp_2889 = rel_algebra::complement(rel_algebra::divide(temp_2885, rel_algebra::complement(temp_2886)));
	int64_t temp_2892 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_2889); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_2876 = 0;
		int64_t temp_2878 = local_X[temp_2876];
		temp_2892 = std::max(temp_2892, temp_2878);
	}
	temp_2894 = std::max(temp_2894, temp_2892);
	local_afterEDicTU = temp_2894;

	rel_algebra_node temp_2904 = rel_algebra::trueTable();
	compact_string temp_2896 = compact_string::make_from("arguments");
	rel_algebra_node temp_2897 = database[temp_2896];
	temp_2904 = rel_algebra::join(temp_2904, temp_2897);
	compact_string temp_2898 = compact_string::make_from("cfd");
	rel_algebra_node temp_2899 = database[temp_2898];
	rel_algebra_node temp_2900 = rel_algebra::complement(temp_2899);
	temp_2904 = rel_algebra::join(temp_2904, temp_2900);
	compact_string temp_2901 = compact_string::make_from("ctd");
	rel_algebra_node temp_2902 = database[temp_2901];
	rel_algebra_node temp_2903 = rel_algebra::complement(temp_2902);
	temp_2904 = rel_algebra::join(temp_2904, temp_2903);
	int64_t temp_2905 = local_afterEDicTU;
	rel_algebra_node temp_2909 = macro_unaryTranslator(temp_2904, temp_2905);
	local_dDicU = temp_2909;

	int64_t temp_2911 = 1;
	int64_t temp_2913 = 0;
	rel_algebra_node temp_2917 = rel_algebra::trueTable();
	int64_t temp_2915 = 0;
	int64_t temp_2916 = 0;
	rel_algebra_node temp_2921 = rel_algebra::filterGreaterThan(temp_2915, temp_2916, temp_2917);
	rel_algebra_node temp_2922 = local_eDicTU;
	rel_algebra_node temp_2925 = rel_algebra::complement(rel_algebra::divide(temp_2921, rel_algebra::complement(temp_2922)));
	rel_algebra_node temp_2930 = generalized_filter_rename(temp_2911, temp_2913)(temp_2925);
	local_eDic0to2 = temp_2930;

	int64_t temp_2932 = 2;
	int64_t temp_2934 = 3;
	rel_algebra_node temp_2938 = rel_algebra::trueTable();
	int64_t temp_2936 = 0;
	int64_t temp_2937 = 0;
	rel_algebra_node temp_2942 = rel_algebra::filterGreaterThan(temp_2936, temp_2937, temp_2938);
	rel_algebra_node temp_2943 = local_eDicTU;
	rel_algebra_node temp_2946 = rel_algebra::complement(rel_algebra::divide(temp_2942, rel_algebra::complement(temp_2943)));
	rel_algebra_node temp_2951 = generalized_filter_rename(temp_2932, temp_2934)(temp_2946);
	local_eDic1to3 = temp_2951;

	int64_t temp_2953 = 1;
	int64_t temp_2955 = 0;
	rel_algebra_node temp_2959 = rel_algebra::trueTable();
	int64_t temp_2957 = 0;
	int64_t temp_2958 = 0;
	rel_algebra_node temp_2963 = rel_algebra::filterGreaterThan(temp_2957, temp_2958, temp_2959);
	rel_algebra_node temp_2964 = local_dDicU;
	rel_algebra_node temp_2967 = rel_algebra::complement(rel_algebra::divide(temp_2963, rel_algebra::complement(temp_2964)));
	rel_algebra_node temp_2972 = generalized_filter_rename(temp_2953, temp_2955)(temp_2967);
	local_dDic0to2 = temp_2972;

	int64_t temp_2974 = 2;
	int64_t temp_2976 = 3;
	rel_algebra_node temp_2980 = rel_algebra::trueTable();
	int64_t temp_2978 = 0;
	int64_t temp_2979 = 0;
	rel_algebra_node temp_2984 = rel_algebra::filterGreaterThan(temp_2978, temp_2979, temp_2980);
	rel_algebra_node temp_2985 = local_dDicU;
	rel_algebra_node temp_2988 = rel_algebra::complement(rel_algebra::divide(temp_2984, rel_algebra::complement(temp_2985)));
	rel_algebra_node temp_2993 = generalized_filter_rename(temp_2974, temp_2976)(temp_2988);
	local_dDic1to3 = temp_2993;

	auto temp_3004 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_2995 = 1;
			int64_t temp_2996 = param_1;
			int64_t temp_2997 = temp_2995 + temp_2996;
			return temp_2997;
		};
	int64_t temp_2998 = 0;
	int64_t temp_3005 = temp_2998;
	rel_algebra_node temp_3000 = local_dDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_3000); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_2999 = 0;
		temp_3005 = temp_3004(temp_3005, temp_2999);
	}
	local_dTupleUCount = temp_3005;

	auto temp_3016 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_3007 = 1;
			int64_t temp_3008 = param_1;
			int64_t temp_3009 = temp_3007 + temp_3008;
			return temp_3009;
		};
	int64_t temp_3010 = 0;
	int64_t temp_3017 = temp_3010;
	rel_algebra_node temp_3012 = local_eDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_3012); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3011 = 0;
		temp_3017 = temp_3016(temp_3017, temp_3011);
	}
	local_eTupleUCount = temp_3017;

	auto temp_3029 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_3019 = 1;
			int64_t temp_3020 = param_1;
			int64_t temp_3021 = temp_3019 + temp_3020;
			return temp_3021;
		};
	int64_t temp_3022 = 0;
	int64_t temp_3030 = temp_3022;
	compact_string temp_3024 = compact_string::make_from("cte");
	rel_algebra_node temp_3025 = database[temp_3024];
	for (auto local_X = rel_algebra::getUnitIterator(temp_3025); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3023 = 0;
		temp_3030 = temp_3029(temp_3030, temp_3023);
	}
	local_eTupleTCount = temp_3030;

	int64_t temp_3032 = local_dTupleUCount;
	int64_t temp_3033 = local_eTupleUCount;
	int64_t temp_3034 = temp_3032 + temp_3033;
	int64_t temp_3035 = local_eTupleTCount;
	int64_t temp_3036 = temp_3034 + temp_3035;
	local_totalVarCount = temp_3036;

	return result;
}

void gg_datatype_Spec_type6::output_grounder(ostream &os) const
{
	rel_algebra_node temp_3051 = rel_algebra::trueTable();
	rel_algebra_node temp_3045 = rel_algebra::trueTable();
	compact_string temp_3041 = compact_string::make_from("cte");
	rel_algebra_node temp_3042 = database[temp_3041];
	temp_3045 = rel_algebra::join(temp_3045, temp_3042);
	compact_string temp_3043 = compact_string::make_from("cfe");
	rel_algebra_node temp_3044 = database[temp_3043];
	temp_3045 = rel_algebra::join(temp_3045, temp_3044);
	temp_3051 = rel_algebra::join(temp_3051, rel_algebra::complement(temp_3045));
	rel_algebra_node temp_3050 = rel_algebra::trueTable();
	compact_string temp_3046 = compact_string::make_from("ctd");
	rel_algebra_node temp_3047 = database[temp_3046];
	temp_3050 = rel_algebra::join(temp_3050, temp_3047);
	compact_string temp_3048 = compact_string::make_from("cfd");
	rel_algebra_node temp_3049 = database[temp_3048];
	temp_3050 = rel_algebra::join(temp_3050, temp_3049);
	temp_3051 = rel_algebra::join(temp_3051, rel_algebra::complement(temp_3050));
	temp_3051 = rel_algebra::complement(temp_3051);
	if ((!rel_algebra::isEmpty(temp_3051)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_3058 = local_totalVarCount;
		os << temp_3058;
		os << " 10\n";
		rel_algebra_node temp_3081 = local_eDic0to2;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3081); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_3064 = 2;
			int64_t temp_3066 = local_tuple[temp_3064];
			os << temp_3066;
			os << " ";
			compact_string temp_3071 = compact_string::make_from("arguments");
			int64_t temp_3072 = 0;
			int64_t temp_3074 = local_tuple[temp_3072];
			os << mapFromInt(temp_3071, temp_3074);
			os << "\n";
		}
		compact_string temp_3086 = compact_string::make_from("arguments");
		rel_algebra_node temp_3087 = database[temp_3086];
		rel_algebra_node temp_3088 = local_attacks01;
		rel_algebra_node temp_3089 = local_attacks10;
		compact_string temp_3090 = compact_string::make_from("cfe");
		rel_algebra_node temp_3091 = database[temp_3090];
		compact_string temp_3092 = compact_string::make_from("cte");
		rel_algebra_node temp_3093 = database[temp_3092];
		compact_string temp_3094 = compact_string::make_from("cfd");
		rel_algebra_node temp_3095 = database[temp_3094];
		compact_string temp_3096 = compact_string::make_from("ctd");
		rel_algebra_node temp_3097 = database[temp_3096];
		rel_algebra_node temp_3098 = local_eDic0to2;
		rel_algebra_node temp_3099 = local_eDic1to3;
		rel_algebra_node temp_3100 = local_dDic0to2;
		rel_algebra_node temp_3101 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_3087, temp_3088, temp_3089, temp_3091, temp_3093, temp_3095, temp_3097, temp_3098, temp_3099, temp_3100, temp_3101);
		os << "module ";
		int64_t temp_3108 = 2;
		int64_t temp_3109 = local_eTupleUCount;
		int64_t temp_3110 = temp_3108 * temp_3109;
		int64_t temp_3111 = local_totalVarCount;
		int64_t temp_3112 = temp_3110 + temp_3111;
		os << temp_3112;
		os << " ";
		int64_t temp_3117 = local_eTupleUCount;
		os << temp_3117;
		rel_algebra_node temp_3128 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3128); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_3121 = local_totalVarCount;
			int64_t temp_3122 = 2;
			int64_t temp_3124 = local_tuple[temp_3122];
			int64_t temp_3125 = temp_3121 + temp_3124;
			os << temp_3125;
		}
		os << "\n";
		compact_string temp_3135 = compact_string::make_from("arguments");
		rel_algebra_node temp_3136 = database[temp_3135];
		rel_algebra_node temp_3137 = local_attacks01;
		rel_algebra_node temp_3138 = local_attacks10;
		compact_string temp_3139 = compact_string::make_from("cfe");
		rel_algebra_node temp_3140 = database[temp_3139];
		compact_string temp_3141 = compact_string::make_from("cte");
		rel_algebra_node temp_3142 = database[temp_3141];
		compact_string temp_3143 = compact_string::make_from("cfd");
		rel_algebra_node temp_3144 = database[temp_3143];
		compact_string temp_3145 = compact_string::make_from("ctd");
		rel_algebra_node temp_3146 = database[temp_3145];
		rel_algebra_node temp_3147 = local_eDic0to2;
		rel_algebra_node temp_3148 = local_eDic1to3;
		rel_algebra_node temp_3149 = local_dDic0to2;
		rel_algebra_node temp_3150 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_3136, temp_3137, temp_3138, temp_3140, temp_3142, temp_3144, temp_3146, temp_3147, temp_3148, temp_3149, temp_3150);
		auto temp_3207 = [=](rel_algebra_node param_1, rel_algebra_node param_2) -> rel_algebra_node
			{
				rel_algebra_node temp_3157 = rel_algebra::trueTable();
				rel_algebra_node temp_3155 = param_1;
				temp_3157 = rel_algebra::join(temp_3157, rel_algebra::complement(temp_3155));
				rel_algebra_node temp_3156 = param_2;
				temp_3157 = rel_algebra::join(temp_3157, rel_algebra::complement(temp_3156));
				temp_3157 = rel_algebra::complement(temp_3157);
				return temp_3157;
			};
		rel_algebra_node temp_3158 = rel_algebra::trueTable();
		temp_3158 = rel_algebra::complement(temp_3158);
		rel_algebra_node temp_3208 = temp_3158;
		rel_algebra_node temp_3203 = local_eDicU;
		for (auto local_X = rel_algebra::getUnitIterator(temp_3203); !local_X.atEnd(); ++local_X)
		{
			rel_algebra_node temp_3202 = rel_algebra::trueTable();
			rel_algebra_node temp_3167 = rel_algebra::trueTable();
			int64_t temp_3159 = 3;
			int64_t temp_3160 = local_totalVarCount;
			int64_t temp_3161 = local_eTupleUCount;
			int64_t temp_3162 = temp_3160 + temp_3161;
			int64_t temp_3163 = 2;
			int64_t temp_3165 = local_X[temp_3163];
			int64_t temp_3166 = temp_3162 + temp_3165;
			rel_algebra_node temp_3171 = rel_algebra::filterEqualTo(temp_3159, temp_3166, temp_3167);
			temp_3202 = rel_algebra::join(temp_3202, temp_3171);
			rel_algebra_node temp_3178 = rel_algebra::trueTable();
			int64_t temp_3172 = 2;
			int64_t temp_3173 = local_totalVarCount;
			int64_t temp_3174 = 2;
			int64_t temp_3176 = local_X[temp_3174];
			int64_t temp_3177 = temp_3173 + temp_3176;
			rel_algebra_node temp_3182 = rel_algebra::filterEqualTo(temp_3172, temp_3177, temp_3178);
			temp_3202 = rel_algebra::join(temp_3202, temp_3182);
			rel_algebra_node temp_3187 = rel_algebra::trueTable();
			int64_t temp_3183 = 1;
			int64_t temp_3184 = 2;
			int64_t temp_3186 = local_X[temp_3184];
			rel_algebra_node temp_3191 = rel_algebra::filterEqualTo(temp_3183, temp_3186, temp_3187);
			temp_3202 = rel_algebra::join(temp_3202, temp_3191);
			rel_algebra_node temp_3197 = rel_algebra::trueTable();
			int64_t temp_3192 = 0;
			int64_t temp_3193 = 1;
			int64_t temp_3195 = local_X[temp_3193];
			int64_t temp_3196 = -temp_3195;
			rel_algebra_node temp_3201 = rel_algebra::filterEqualTo(temp_3192, temp_3196, temp_3197);
			temp_3202 = rel_algebra::join(temp_3202, temp_3201);
			temp_3208 = temp_3207(temp_3208, temp_3202);
		}
		subtree_out->output_unary_proper_subset_clauses(os, temp_3208);
		os << "endmodule\n";
		os << "falsify 0";
		rel_algebra_node temp_3223 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3223); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_3218 = 2;
			int64_t temp_3220 = local_tuple[temp_3218];
			os << temp_3220;
		}
		os << "\n";
	}
}

string gg_datatype_Spec_type6::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "grounded";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type6::gg_datatype_Spec_type6(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_2684 = compact_string::make_from("cfe");
	rel_algebra_node temp_2687 = subtree_r->local_cf;
	set_database_atom(temp_2684, temp_2687);

	compact_string temp_2689 = compact_string::make_from("cte");
	rel_algebra_node temp_2692 = subtree_r->local_ct;
	set_database_atom(temp_2689, temp_2692);

	compact_string temp_2694 = compact_string::make_from("cfd");
	rel_algebra_node temp_2696 = rel_algebra::trueTable();
	temp_2696 = rel_algebra::complement(temp_2696);
	set_database_atom(temp_2694, temp_2696);

	compact_string temp_2698 = compact_string::make_from("ctd");
	rel_algebra_node temp_2700 = rel_algebra::trueTable();
	temp_2700 = rel_algebra::complement(temp_2700);
	set_database_atom(temp_2698, temp_2700);

	compact_string temp_2702 = compact_string::make_from("attacks");
	rel_algebra_node temp_2703 = database[temp_2702];
	local_attacks01 = temp_2703;

	int64_t temp_2705 = 0;
	int64_t temp_2707 = 2;
	rel_algebra_node temp_2709 = local_attacks01;
	rel_algebra_node temp_2714 = generalized_filter_rename(temp_2705, temp_2707)(temp_2709);
	local_attacks21 = temp_2714;

	int64_t temp_2716 = 2;
	int64_t temp_2718 = 1;
	int64_t temp_2720 = 1;
	int64_t temp_2722 = 0;
	rel_algebra_node temp_2724 = local_attacks21;
	rel_algebra_node temp_2729 = generalized_filter_rename(temp_2720, temp_2722)(temp_2724);
	rel_algebra_node temp_2734 = generalized_filter_rename(temp_2716, temp_2718)(temp_2729);
	local_attacks10 = temp_2734;

	int64_t temp_2736 = 0;
	int64_t temp_2738 = 2;
	compact_string temp_2740 = compact_string::make_from("arguments");
	rel_algebra_node temp_2741 = database[temp_2740];
	rel_algebra_node temp_2746 = generalized_filter_equals(temp_2736, temp_2738)(temp_2741);
	local_args02 = temp_2746;
}

bool gg_datatype_Spec_type7::fixpoint_semantics()
{
	bool result = false;

	compact_string temp_3312 = compact_string::make_from("cfe");
	rel_algebra_node temp_3328 = rel_algebra::trueTable();
	compact_string temp_3314 = compact_string::make_from("arguments");
	rel_algebra_node temp_3315 = database[temp_3314];
	temp_3328 = rel_algebra::join(temp_3328, temp_3315);
	rel_algebra_node temp_3327 = rel_algebra::trueTable();
	compact_string temp_3316 = compact_string::make_from("cfe");
	rel_algebra_node temp_3317 = database[temp_3316];
	temp_3327 = rel_algebra::join(temp_3327, rel_algebra::complement(temp_3317));
	rel_algebra_node temp_3318 = local_attacks01;
	rel_algebra_node temp_3319 = local_attacks10;
	compact_string temp_3320 = compact_string::make_from("cte");
	rel_algebra_node temp_3321 = database[temp_3320];
	compact_string temp_3322 = compact_string::make_from("cfd");
	rel_algebra_node temp_3323 = database[temp_3322];
	rel_algebra_node temp_3326 = macro_completion_cfe_bound(temp_3318, temp_3319, temp_3321, temp_3323);
	temp_3327 = rel_algebra::join(temp_3327, rel_algebra::complement(temp_3326));
	temp_3327 = rel_algebra::complement(temp_3327);
	temp_3328 = rel_algebra::join(temp_3328, temp_3327);
	result = result || (database[temp_3312] != temp_3328);
	set_database_atom(temp_3312, temp_3328);

	compact_string temp_3330 = compact_string::make_from("cte");
	rel_algebra_node temp_3349 = rel_algebra::trueTable();
	compact_string temp_3332 = compact_string::make_from("arguments");
	rel_algebra_node temp_3333 = database[temp_3332];
	temp_3349 = rel_algebra::join(temp_3349, temp_3333);
	rel_algebra_node temp_3348 = rel_algebra::trueTable();
	compact_string temp_3334 = compact_string::make_from("cte");
	rel_algebra_node temp_3335 = database[temp_3334];
	temp_3348 = rel_algebra::join(temp_3348, rel_algebra::complement(temp_3335));
	compact_string temp_3336 = compact_string::make_from("arguments");
	rel_algebra_node temp_3337 = database[temp_3336];
	rel_algebra_node temp_3338 = local_args02;
	rel_algebra_node temp_3339 = local_attacks10;
	rel_algebra_node temp_3340 = local_attacks21;
	compact_string temp_3341 = compact_string::make_from("cfe");
	rel_algebra_node temp_3342 = database[temp_3341];
	compact_string temp_3343 = compact_string::make_from("ctd");
	rel_algebra_node temp_3344 = database[temp_3343];
	rel_algebra_node temp_3347 = macro_completion_cte_bound(temp_3337, temp_3338, temp_3339, temp_3340, temp_3342, temp_3344);
	temp_3348 = rel_algebra::join(temp_3348, rel_algebra::complement(temp_3347));
	temp_3348 = rel_algebra::complement(temp_3348);
	temp_3349 = rel_algebra::join(temp_3349, temp_3348);
	result = result || (database[temp_3330] != temp_3349);
	set_database_atom(temp_3330, temp_3349);

	compact_string temp_3351 = compact_string::make_from("cfd");
	rel_algebra_node temp_3370 = rel_algebra::trueTable();
	compact_string temp_3353 = compact_string::make_from("arguments");
	rel_algebra_node temp_3354 = database[temp_3353];
	temp_3370 = rel_algebra::join(temp_3370, temp_3354);
	rel_algebra_node temp_3369 = rel_algebra::trueTable();
	compact_string temp_3355 = compact_string::make_from("cfd");
	rel_algebra_node temp_3356 = database[temp_3355];
	temp_3369 = rel_algebra::join(temp_3369, rel_algebra::complement(temp_3356));
	compact_string temp_3357 = compact_string::make_from("arguments");
	rel_algebra_node temp_3358 = database[temp_3357];
	rel_algebra_node temp_3359 = local_args02;
	rel_algebra_node temp_3360 = local_attacks10;
	rel_algebra_node temp_3361 = local_attacks21;
	compact_string temp_3362 = compact_string::make_from("cfe");
	rel_algebra_node temp_3363 = database[temp_3362];
	compact_string temp_3364 = compact_string::make_from("ctd");
	rel_algebra_node temp_3365 = database[temp_3364];
	rel_algebra_node temp_3368 = macro_completion_cfd_bound(temp_3358, temp_3359, temp_3360, temp_3361, temp_3363, temp_3365);
	temp_3369 = rel_algebra::join(temp_3369, rel_algebra::complement(temp_3368));
	temp_3369 = rel_algebra::complement(temp_3369);
	temp_3370 = rel_algebra::join(temp_3370, temp_3369);
	result = result || (database[temp_3351] != temp_3370);
	set_database_atom(temp_3351, temp_3370);

	compact_string temp_3372 = compact_string::make_from("ctd");
	rel_algebra_node temp_3386 = rel_algebra::trueTable();
	compact_string temp_3374 = compact_string::make_from("arguments");
	rel_algebra_node temp_3375 = database[temp_3374];
	temp_3386 = rel_algebra::join(temp_3386, temp_3375);
	rel_algebra_node temp_3385 = rel_algebra::trueTable();
	compact_string temp_3376 = compact_string::make_from("ctd");
	rel_algebra_node temp_3377 = database[temp_3376];
	temp_3385 = rel_algebra::join(temp_3385, rel_algebra::complement(temp_3377));
	rel_algebra_node temp_3378 = local_attacks01;
	rel_algebra_node temp_3379 = local_attacks10;
	compact_string temp_3380 = compact_string::make_from("cte");
	rel_algebra_node temp_3381 = database[temp_3380];
	rel_algebra_node temp_3384 = macro_completion_ctd_bound(temp_3378, temp_3379, temp_3381);
	temp_3385 = rel_algebra::join(temp_3385, rel_algebra::complement(temp_3384));
	temp_3385 = rel_algebra::complement(temp_3385);
	temp_3386 = rel_algebra::join(temp_3386, temp_3385);
	result = result || (database[temp_3372] != temp_3386);
	set_database_atom(temp_3372, temp_3386);

	return result;
}

bool gg_datatype_Spec_type7::fixpoint_postsem()
{
	bool result = false;

	rel_algebra_node temp_3397 = rel_algebra::trueTable();
	compact_string temp_3389 = compact_string::make_from("arguments");
	rel_algebra_node temp_3390 = database[temp_3389];
	temp_3397 = rel_algebra::join(temp_3397, temp_3390);
	compact_string temp_3391 = compact_string::make_from("cfe");
	rel_algebra_node temp_3392 = database[temp_3391];
	rel_algebra_node temp_3393 = rel_algebra::complement(temp_3392);
	temp_3397 = rel_algebra::join(temp_3397, temp_3393);
	compact_string temp_3394 = compact_string::make_from("cte");
	rel_algebra_node temp_3395 = database[temp_3394];
	rel_algebra_node temp_3396 = rel_algebra::complement(temp_3395);
	temp_3397 = rel_algebra::join(temp_3397, temp_3396);
	int64_t temp_3398 = 1;
	rel_algebra_node temp_3402 = macro_unaryTranslator(temp_3397, temp_3398);
	local_eDicU = temp_3402;

	int64_t temp_3424 = std::numeric_limits<ValueType>::min();
	int64_t temp_3404 = 1;
	temp_3424 = std::max(temp_3424, temp_3404);
	rel_algebra_node temp_3411 = rel_algebra::trueTable();
	int64_t temp_3409 = 0;
	int64_t temp_3410 = 0;
	rel_algebra_node temp_3415 = rel_algebra::filterLessThanOrEqualTo(temp_3409, temp_3410, temp_3411);
	rel_algebra_node temp_3416 = local_eDicU;
	rel_algebra_node temp_3419 = rel_algebra::complement(rel_algebra::divide(temp_3415, rel_algebra::complement(temp_3416)));
	int64_t temp_3422 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_3419); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3406 = 0;
		int64_t temp_3408 = local_X[temp_3406];
		temp_3422 = std::max(temp_3422, temp_3408);
	}
	temp_3424 = std::max(temp_3424, temp_3422);
	local_afterEDicU = temp_3424;

	compact_string temp_3426 = compact_string::make_from("cte");
	rel_algebra_node temp_3427 = database[temp_3426];
	int64_t temp_3428 = local_afterEDicU;
	rel_algebra_node temp_3432 = macro_unaryTranslator(temp_3427, temp_3428);
	local_eDicT = temp_3432;

	rel_algebra_node temp_3436 = rel_algebra::trueTable();
	rel_algebra_node temp_3434 = local_eDicU;
	temp_3436 = rel_algebra::join(temp_3436, rel_algebra::complement(temp_3434));
	rel_algebra_node temp_3435 = local_eDicT;
	temp_3436 = rel_algebra::join(temp_3436, rel_algebra::complement(temp_3435));
	temp_3436 = rel_algebra::complement(temp_3436);
	local_eDicTU = temp_3436;

	int64_t temp_3458 = std::numeric_limits<ValueType>::min();
	int64_t temp_3438 = local_afterEDicU;
	temp_3458 = std::max(temp_3458, temp_3438);
	rel_algebra_node temp_3445 = rel_algebra::trueTable();
	int64_t temp_3443 = 0;
	int64_t temp_3444 = 0;
	rel_algebra_node temp_3449 = rel_algebra::filterLessThanOrEqualTo(temp_3443, temp_3444, temp_3445);
	rel_algebra_node temp_3450 = local_eDicTU;
	rel_algebra_node temp_3453 = rel_algebra::complement(rel_algebra::divide(temp_3449, rel_algebra::complement(temp_3450)));
	int64_t temp_3456 = std::numeric_limits<ValueType>::min();
	for (auto local_X = rel_algebra::getUnitIterator(temp_3453); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3440 = 0;
		int64_t temp_3442 = local_X[temp_3440];
		temp_3456 = std::max(temp_3456, temp_3442);
	}
	temp_3458 = std::max(temp_3458, temp_3456);
	local_afterEDicTU = temp_3458;

	rel_algebra_node temp_3468 = rel_algebra::trueTable();
	compact_string temp_3460 = compact_string::make_from("arguments");
	rel_algebra_node temp_3461 = database[temp_3460];
	temp_3468 = rel_algebra::join(temp_3468, temp_3461);
	compact_string temp_3462 = compact_string::make_from("cfd");
	rel_algebra_node temp_3463 = database[temp_3462];
	rel_algebra_node temp_3464 = rel_algebra::complement(temp_3463);
	temp_3468 = rel_algebra::join(temp_3468, temp_3464);
	compact_string temp_3465 = compact_string::make_from("ctd");
	rel_algebra_node temp_3466 = database[temp_3465];
	rel_algebra_node temp_3467 = rel_algebra::complement(temp_3466);
	temp_3468 = rel_algebra::join(temp_3468, temp_3467);
	int64_t temp_3469 = local_afterEDicTU;
	rel_algebra_node temp_3473 = macro_unaryTranslator(temp_3468, temp_3469);
	local_dDicU = temp_3473;

	int64_t temp_3475 = 1;
	int64_t temp_3477 = 0;
	rel_algebra_node temp_3481 = rel_algebra::trueTable();
	int64_t temp_3479 = 0;
	int64_t temp_3480 = 0;
	rel_algebra_node temp_3485 = rel_algebra::filterGreaterThan(temp_3479, temp_3480, temp_3481);
	rel_algebra_node temp_3486 = local_eDicTU;
	rel_algebra_node temp_3489 = rel_algebra::complement(rel_algebra::divide(temp_3485, rel_algebra::complement(temp_3486)));
	rel_algebra_node temp_3494 = generalized_filter_rename(temp_3475, temp_3477)(temp_3489);
	local_eDic0to2 = temp_3494;

	int64_t temp_3496 = 2;
	int64_t temp_3498 = 3;
	rel_algebra_node temp_3502 = rel_algebra::trueTable();
	int64_t temp_3500 = 0;
	int64_t temp_3501 = 0;
	rel_algebra_node temp_3506 = rel_algebra::filterGreaterThan(temp_3500, temp_3501, temp_3502);
	rel_algebra_node temp_3507 = local_eDicTU;
	rel_algebra_node temp_3510 = rel_algebra::complement(rel_algebra::divide(temp_3506, rel_algebra::complement(temp_3507)));
	rel_algebra_node temp_3515 = generalized_filter_rename(temp_3496, temp_3498)(temp_3510);
	local_eDic1to3 = temp_3515;

	int64_t temp_3517 = 1;
	int64_t temp_3519 = 0;
	rel_algebra_node temp_3523 = rel_algebra::trueTable();
	int64_t temp_3521 = 0;
	int64_t temp_3522 = 0;
	rel_algebra_node temp_3527 = rel_algebra::filterGreaterThan(temp_3521, temp_3522, temp_3523);
	rel_algebra_node temp_3528 = local_dDicU;
	rel_algebra_node temp_3531 = rel_algebra::complement(rel_algebra::divide(temp_3527, rel_algebra::complement(temp_3528)));
	rel_algebra_node temp_3536 = generalized_filter_rename(temp_3517, temp_3519)(temp_3531);
	local_dDic0to2 = temp_3536;

	int64_t temp_3538 = 2;
	int64_t temp_3540 = 3;
	rel_algebra_node temp_3544 = rel_algebra::trueTable();
	int64_t temp_3542 = 0;
	int64_t temp_3543 = 0;
	rel_algebra_node temp_3548 = rel_algebra::filterGreaterThan(temp_3542, temp_3543, temp_3544);
	rel_algebra_node temp_3549 = local_dDicU;
	rel_algebra_node temp_3552 = rel_algebra::complement(rel_algebra::divide(temp_3548, rel_algebra::complement(temp_3549)));
	rel_algebra_node temp_3557 = generalized_filter_rename(temp_3538, temp_3540)(temp_3552);
	local_dDic1to3 = temp_3557;

	auto temp_3568 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_3559 = 1;
			int64_t temp_3560 = param_1;
			int64_t temp_3561 = temp_3559 + temp_3560;
			return temp_3561;
		};
	int64_t temp_3562 = 0;
	int64_t temp_3569 = temp_3562;
	rel_algebra_node temp_3564 = local_dDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_3564); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3563 = 0;
		temp_3569 = temp_3568(temp_3569, temp_3563);
	}
	local_dTupleUCount = temp_3569;

	auto temp_3580 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_3571 = 1;
			int64_t temp_3572 = param_1;
			int64_t temp_3573 = temp_3571 + temp_3572;
			return temp_3573;
		};
	int64_t temp_3574 = 0;
	int64_t temp_3581 = temp_3574;
	rel_algebra_node temp_3576 = local_eDicU;
	for (auto local_X = rel_algebra::getUnitIterator(temp_3576); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3575 = 0;
		temp_3581 = temp_3580(temp_3581, temp_3575);
	}
	local_eTupleUCount = temp_3581;

	auto temp_3593 = [=](int64_t param_1, int64_t param_2) -> int64_t
		{
			int64_t temp_3583 = 1;
			int64_t temp_3584 = param_1;
			int64_t temp_3585 = temp_3583 + temp_3584;
			return temp_3585;
		};
	int64_t temp_3586 = 0;
	int64_t temp_3594 = temp_3586;
	compact_string temp_3588 = compact_string::make_from("cte");
	rel_algebra_node temp_3589 = database[temp_3588];
	for (auto local_X = rel_algebra::getUnitIterator(temp_3589); !local_X.atEnd(); ++local_X)
	{
		int64_t temp_3587 = 0;
		temp_3594 = temp_3593(temp_3594, temp_3587);
	}
	local_eTupleTCount = temp_3594;

	int64_t temp_3596 = local_eTupleTCount;
	int64_t temp_3597 = local_eTupleUCount;
	int64_t temp_3598 = temp_3596 + temp_3597;
	local_eTupleTUCount = temp_3598;

	int64_t temp_3600 = local_dTupleUCount;
	int64_t temp_3601 = local_eTupleTUCount;
	int64_t temp_3602 = temp_3600 + temp_3601;
	local_totalVarCount = temp_3602;

	return result;
}

void gg_datatype_Spec_type7::output_grounder(ostream &os) const
{
	rel_algebra_node temp_3617 = rel_algebra::trueTable();
	rel_algebra_node temp_3611 = rel_algebra::trueTable();
	compact_string temp_3607 = compact_string::make_from("cte");
	rel_algebra_node temp_3608 = database[temp_3607];
	temp_3611 = rel_algebra::join(temp_3611, temp_3608);
	compact_string temp_3609 = compact_string::make_from("cfe");
	rel_algebra_node temp_3610 = database[temp_3609];
	temp_3611 = rel_algebra::join(temp_3611, temp_3610);
	temp_3617 = rel_algebra::join(temp_3617, rel_algebra::complement(temp_3611));
	rel_algebra_node temp_3616 = rel_algebra::trueTable();
	compact_string temp_3612 = compact_string::make_from("ctd");
	rel_algebra_node temp_3613 = database[temp_3612];
	temp_3616 = rel_algebra::join(temp_3616, temp_3613);
	compact_string temp_3614 = compact_string::make_from("cfd");
	rel_algebra_node temp_3615 = database[temp_3614];
	temp_3616 = rel_algebra::join(temp_3616, temp_3615);
	temp_3617 = rel_algebra::join(temp_3617, rel_algebra::complement(temp_3616));
	temp_3617 = rel_algebra::complement(temp_3617);
	if ((!rel_algebra::isEmpty(temp_3617)))
	{
		os << "p cnf 1 2\n";
		os << "1 0\n";
		os << "-1 0\n";
	}
	else
	{
		os << "p cnf ";
		int64_t temp_3624 = local_eTupleTUCount;
		os << temp_3624;
		os << " 10\n";
		rel_algebra_node temp_3647 = local_eDic0to2;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3647); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "c ";
			int64_t temp_3630 = 2;
			int64_t temp_3632 = local_tuple[temp_3630];
			os << temp_3632;
			os << " ";
			compact_string temp_3637 = compact_string::make_from("arguments");
			int64_t temp_3638 = 0;
			int64_t temp_3640 = local_tuple[temp_3638];
			os << mapFromInt(temp_3637, temp_3640);
			os << "\n";
		}
		os << "module ";
		int64_t temp_3654 = 2;
		int64_t temp_3655 = local_eTupleUCount;
		int64_t temp_3656 = temp_3654 * temp_3655;
		int64_t temp_3657 = local_totalVarCount;
		int64_t temp_3658 = temp_3656 + temp_3657;
		os << temp_3658;
		os << " ";
		int64_t temp_3663 = local_eTupleUCount;
		os << temp_3663;
		rel_algebra_node temp_3674 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3674); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_3667 = local_totalVarCount;
			int64_t temp_3668 = 2;
			int64_t temp_3670 = local_tuple[temp_3668];
			int64_t temp_3671 = temp_3667 + temp_3670;
			os << temp_3671;
		}
		os << "\n";
		compact_string temp_3681 = compact_string::make_from("arguments");
		rel_algebra_node temp_3682 = database[temp_3681];
		rel_algebra_node temp_3683 = local_attacks01;
		rel_algebra_node temp_3684 = local_attacks10;
		compact_string temp_3685 = compact_string::make_from("cfe");
		rel_algebra_node temp_3686 = database[temp_3685];
		compact_string temp_3687 = compact_string::make_from("cte");
		rel_algebra_node temp_3688 = database[temp_3687];
		compact_string temp_3689 = compact_string::make_from("cfd");
		rel_algebra_node temp_3690 = database[temp_3689];
		compact_string temp_3691 = compact_string::make_from("ctd");
		rel_algebra_node temp_3692 = database[temp_3691];
		rel_algebra_node temp_3693 = local_eDic0to2;
		rel_algebra_node temp_3694 = local_eDic1to3;
		rel_algebra_node temp_3695 = local_dDic0to2;
		rel_algebra_node temp_3696 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_3682, temp_3683, temp_3684, temp_3686, temp_3688, temp_3690, temp_3692, temp_3693, temp_3694, temp_3695, temp_3696);
		auto temp_3753 = [=](rel_algebra_node param_1, rel_algebra_node param_2) -> rel_algebra_node
			{
				rel_algebra_node temp_3703 = rel_algebra::trueTable();
				rel_algebra_node temp_3701 = param_1;
				temp_3703 = rel_algebra::join(temp_3703, rel_algebra::complement(temp_3701));
				rel_algebra_node temp_3702 = param_2;
				temp_3703 = rel_algebra::join(temp_3703, rel_algebra::complement(temp_3702));
				temp_3703 = rel_algebra::complement(temp_3703);
				return temp_3703;
			};
		rel_algebra_node temp_3704 = rel_algebra::trueTable();
		temp_3704 = rel_algebra::complement(temp_3704);
		rel_algebra_node temp_3754 = temp_3704;
		rel_algebra_node temp_3749 = local_eDicU;
		for (auto local_X = rel_algebra::getUnitIterator(temp_3749); !local_X.atEnd(); ++local_X)
		{
			rel_algebra_node temp_3748 = rel_algebra::trueTable();
			rel_algebra_node temp_3713 = rel_algebra::trueTable();
			int64_t temp_3705 = 3;
			int64_t temp_3706 = local_totalVarCount;
			int64_t temp_3707 = local_eTupleUCount;
			int64_t temp_3708 = temp_3706 + temp_3707;
			int64_t temp_3709 = 2;
			int64_t temp_3711 = local_X[temp_3709];
			int64_t temp_3712 = temp_3708 + temp_3711;
			rel_algebra_node temp_3717 = rel_algebra::filterEqualTo(temp_3705, temp_3712, temp_3713);
			temp_3748 = rel_algebra::join(temp_3748, temp_3717);
			rel_algebra_node temp_3722 = rel_algebra::trueTable();
			int64_t temp_3718 = 2;
			int64_t temp_3719 = 2;
			int64_t temp_3721 = local_X[temp_3719];
			rel_algebra_node temp_3726 = rel_algebra::filterEqualTo(temp_3718, temp_3721, temp_3722);
			temp_3748 = rel_algebra::join(temp_3748, temp_3726);
			rel_algebra_node temp_3733 = rel_algebra::trueTable();
			int64_t temp_3727 = 1;
			int64_t temp_3728 = local_totalVarCount;
			int64_t temp_3729 = 2;
			int64_t temp_3731 = local_X[temp_3729];
			int64_t temp_3732 = temp_3728 + temp_3731;
			rel_algebra_node temp_3737 = rel_algebra::filterEqualTo(temp_3727, temp_3732, temp_3733);
			temp_3748 = rel_algebra::join(temp_3748, temp_3737);
			rel_algebra_node temp_3743 = rel_algebra::trueTable();
			int64_t temp_3738 = 0;
			int64_t temp_3739 = 1;
			int64_t temp_3741 = local_X[temp_3739];
			int64_t temp_3742 = -temp_3741;
			rel_algebra_node temp_3747 = rel_algebra::filterEqualTo(temp_3738, temp_3742, temp_3743);
			temp_3748 = rel_algebra::join(temp_3748, temp_3747);
			temp_3754 = temp_3753(temp_3754, temp_3748);
		}
		subtree_out->output_unary_proper_subset_clauses(os, temp_3754);
		os << "endmodule\n";
		os << "module ";
		int64_t temp_3763 = local_totalVarCount;
		int64_t temp_3764 = 2;
		int64_t temp_3765 = local_eTupleUCount;
		int64_t temp_3766 = temp_3764 * temp_3765;
		int64_t temp_3767 = temp_3763 + temp_3766;
		os << temp_3767;
		os << " ";
		int64_t temp_3772 = local_eTupleUCount;
		os << temp_3772;
		rel_algebra_node temp_3783 = local_eDicU;
		for (auto local_X = rel_algebra::getUnitIterator(temp_3783); !local_X.atEnd(); ++local_X)
		{
			os << " ";
			int64_t temp_3776 = local_totalVarCount;
			int64_t temp_3777 = 2;
			int64_t temp_3779 = local_X[temp_3777];
			int64_t temp_3780 = temp_3776 + temp_3779;
			os << temp_3780;
		}
		os << "\n";
		compact_string temp_3790 = compact_string::make_from("arguments");
		rel_algebra_node temp_3791 = database[temp_3790];
		rel_algebra_node temp_3792 = local_attacks01;
		rel_algebra_node temp_3793 = local_attacks10;
		compact_string temp_3794 = compact_string::make_from("cfe");
		rel_algebra_node temp_3795 = database[temp_3794];
		compact_string temp_3796 = compact_string::make_from("cte");
		rel_algebra_node temp_3797 = database[temp_3796];
		compact_string temp_3798 = compact_string::make_from("cfd");
		rel_algebra_node temp_3799 = database[temp_3798];
		compact_string temp_3800 = compact_string::make_from("ctd");
		rel_algebra_node temp_3801 = database[temp_3800];
		rel_algebra_node temp_3802 = local_eDic0to2;
		rel_algebra_node temp_3803 = local_eDic1to3;
		rel_algebra_node temp_3804 = local_dDic0to2;
		rel_algebra_node temp_3805 = local_dDic1to3;
		subtree_out->output_completion_semantics(os, temp_3791, temp_3792, temp_3793, temp_3795, temp_3797, temp_3799, temp_3801, temp_3802, temp_3803, temp_3804, temp_3805);
		os << "c ? v1: diff(v1)\n";
		rel_algebra_node temp_3822 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3822); !local_tuple.atEnd(); ++local_tuple)
		{
			int64_t temp_3812 = 2;
			int64_t temp_3814 = local_tuple[temp_3812];
			int64_t temp_3815 = local_totalVarCount;
			int64_t temp_3816 = temp_3814 + temp_3815;
			int64_t temp_3817 = local_eTupleUCount;
			int64_t temp_3818 = temp_3816 + temp_3817;
			os << temp_3818;
			os << " ";
		}
		os << "0\n";
		os << "c ~diff(v0) | ~e(v0) for all arguments v0\n";
		rel_algebra_node temp_3850 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3850); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "-";
			int64_t temp_3832 = local_totalVarCount;
			int64_t temp_3833 = local_eTupleUCount;
			int64_t temp_3834 = temp_3832 + temp_3833;
			int64_t temp_3835 = 2;
			int64_t temp_3837 = local_tuple[temp_3835];
			int64_t temp_3838 = temp_3834 + temp_3837;
			os << temp_3838;
			os << " -";
			int64_t temp_3843 = 2;
			int64_t temp_3845 = local_tuple[temp_3843];
			os << temp_3845;
			os << " 0\n";
		}
		os << "c ~diff(v0) | inp(v0) for all arguments v0\n";
		rel_algebra_node temp_3878 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3878); !local_tuple.atEnd(); ++local_tuple)
		{
			os << "-";
			int64_t temp_3858 = local_totalVarCount;
			int64_t temp_3859 = local_eTupleUCount;
			int64_t temp_3860 = temp_3858 + temp_3859;
			int64_t temp_3861 = 2;
			int64_t temp_3863 = local_tuple[temp_3861];
			int64_t temp_3864 = temp_3860 + temp_3863;
			os << temp_3864;
			os << " ";
			int64_t temp_3869 = local_totalVarCount;
			int64_t temp_3870 = 2;
			int64_t temp_3872 = local_tuple[temp_3870];
			int64_t temp_3873 = temp_3869 + temp_3872;
			os << temp_3873;
			os << " 0\n";
		}
		os << "falsify 0";
		rel_algebra_node temp_3891 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_3891); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_3886 = 2;
			int64_t temp_3888 = local_tuple[temp_3886];
			os << temp_3888;
		}
		os << "\n";
		os << "endmodule\n";
		os << "module ";
		int64_t temp_3902 = 3;
		int64_t temp_3903 = local_eTupleTUCount;
		int64_t temp_3904 = temp_3902 * temp_3903;
		os << temp_3904;
		os << " ";
		int64_t temp_3909 = local_eTupleTUCount;
		os << temp_3909;
		rel_algebra_node temp_3934 = rel_algebra::trueTable();
		rel_algebra_node temp_3920 = rel_algebra::trueTable();
		int64_t temp_3918 = 0;
		int64_t temp_3919 = local_eTupleTUCount;
		rel_algebra_node temp_3924 = rel_algebra::filterGreaterThan(temp_3918, temp_3919, temp_3920);
		temp_3934 = rel_algebra::join(temp_3934, temp_3924);
		rel_algebra_node temp_3929 = rel_algebra::trueTable();
		int64_t temp_3925 = 0;
		int64_t temp_3926 = 2;
		int64_t temp_3927 = local_eTupleTUCount;
		int64_t temp_3928 = temp_3926 * temp_3927;
		rel_algebra_node temp_3933 = rel_algebra::filterLessThanOrEqualTo(temp_3925, temp_3928, temp_3929);
		temp_3934 = rel_algebra::join(temp_3934, temp_3933);
		for (auto local_X = rel_algebra::getUnitIterator(temp_3934); !local_X.atEnd(); ++local_X)
		{
			os << " ";
			int64_t temp_3913 = 0;
			int64_t temp_3915 = local_X[temp_3913];
			os << temp_3915;
		}
		os << "\n";
		rel_algebra_node temp_3941 = local_attacks01;
		rel_algebra_node temp_3942 = local_eDic0to2;
		rel_algebra_node temp_3943 = local_eDic1to3;
		rel_algebra_node temp_3944 = rel_algebra::trueTable();
		temp_3944 = rel_algebra::complement(temp_3944);
		subtree_out->output_admissibility_clauses(os, temp_3941, temp_3942, temp_3943, temp_3944);
		auto temp_4001 = [=](rel_algebra_node param_1, rel_algebra_node param_2) -> rel_algebra_node
			{
				rel_algebra_node temp_3951 = rel_algebra::trueTable();
				rel_algebra_node temp_3949 = param_1;
				temp_3951 = rel_algebra::join(temp_3951, rel_algebra::complement(temp_3949));
				rel_algebra_node temp_3950 = param_2;
				temp_3951 = rel_algebra::join(temp_3951, rel_algebra::complement(temp_3950));
				temp_3951 = rel_algebra::complement(temp_3951);
				return temp_3951;
			};
		rel_algebra_node temp_3952 = rel_algebra::trueTable();
		temp_3952 = rel_algebra::complement(temp_3952);
		rel_algebra_node temp_4002 = temp_3952;
		rel_algebra_node temp_3997 = local_eDicTU;
		for (auto local_X = rel_algebra::getUnitIterator(temp_3997); !local_X.atEnd(); ++local_X)
		{
			rel_algebra_node temp_3996 = rel_algebra::trueTable();
			rel_algebra_node temp_3961 = rel_algebra::trueTable();
			int64_t temp_3953 = 3;
			int64_t temp_3954 = 2;
			int64_t temp_3955 = local_eTupleTUCount;
			int64_t temp_3956 = temp_3954 * temp_3955;
			int64_t temp_3957 = 2;
			int64_t temp_3959 = local_X[temp_3957];
			int64_t temp_3960 = temp_3956 + temp_3959;
			rel_algebra_node temp_3965 = rel_algebra::filterEqualTo(temp_3953, temp_3960, temp_3961);
			temp_3996 = rel_algebra::join(temp_3996, temp_3965);
			rel_algebra_node temp_3970 = rel_algebra::trueTable();
			int64_t temp_3966 = 2;
			int64_t temp_3967 = 2;
			int64_t temp_3969 = local_X[temp_3967];
			rel_algebra_node temp_3974 = rel_algebra::filterEqualTo(temp_3966, temp_3969, temp_3970);
			temp_3996 = rel_algebra::join(temp_3996, temp_3974);
			rel_algebra_node temp_3981 = rel_algebra::trueTable();
			int64_t temp_3975 = 1;
			int64_t temp_3976 = local_eTupleTUCount;
			int64_t temp_3977 = 2;
			int64_t temp_3979 = local_X[temp_3977];
			int64_t temp_3980 = temp_3976 + temp_3979;
			rel_algebra_node temp_3985 = rel_algebra::filterEqualTo(temp_3975, temp_3980, temp_3981);
			temp_3996 = rel_algebra::join(temp_3996, temp_3985);
			rel_algebra_node temp_3991 = rel_algebra::trueTable();
			int64_t temp_3986 = 0;
			int64_t temp_3987 = 1;
			int64_t temp_3989 = local_X[temp_3987];
			int64_t temp_3990 = -temp_3989;
			rel_algebra_node temp_3995 = rel_algebra::filterEqualTo(temp_3986, temp_3990, temp_3991);
			temp_3996 = rel_algebra::join(temp_3996, temp_3995);
			temp_4002 = temp_4001(temp_4002, temp_3996);
		}
		subtree_out->output_unary_proper_subset_clauses(os, temp_4002);
		os << "falsify 1";
		rel_algebra_node temp_4015 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_4015); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_4010 = 2;
			int64_t temp_4012 = local_tuple[temp_4010];
			os << temp_4012;
		}
		os << "\n";
		os << "endmodule\n";
		rel_algebra_node temp_4024 = local_attacks01;
		rel_algebra_node temp_4025 = local_eDic0to2;
		rel_algebra_node temp_4026 = local_eDic1to3;
		rel_algebra_node temp_4027 = rel_algebra::trueTable();
		temp_4027 = rel_algebra::complement(temp_4027);
		subtree_out->output_admissibility_clauses(os, temp_4024, temp_4025, temp_4026, temp_4027);
		os << "falsify 1";
		rel_algebra_node temp_4040 = local_eDicU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_4040); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_4035 = 2;
			int64_t temp_4037 = local_tuple[temp_4035];
			os << temp_4037;
		}
		os << "\n";
		os << "falsify 2";
		rel_algebra_node temp_4055 = local_eDicTU;
		for (auto local_tuple = rel_algebra::getUnitIterator(temp_4055); !local_tuple.atEnd(); ++local_tuple)
		{
			os << " ";
			int64_t temp_4050 = 2;
			int64_t temp_4052 = local_tuple[temp_4050];
			os << temp_4052;
		}
		os << "\n";
	}
}

string gg_datatype_Spec_type7::toString() const
{
	string result = "";
	result += subtree_inp->toString();
	result += subtree_r->toString();
	result += "ideal";
	result += subtree_out->toString();
	return result;
}

gg_datatype_Spec_type7::gg_datatype_Spec_type7(gg_datatype_Input_base* const &inp, gg_datatype_Reasoning_base* const &r, gg_datatype_Output_base* const &out) : gg_datatype_Spec_base(), subtree_inp(inp), subtree_r(r), subtree_out(out)
{
	compact_string temp_3248 = compact_string::make_from("cfe");
	rel_algebra_node temp_3251 = subtree_r->local_cf;
	set_database_atom(temp_3248, temp_3251);

	compact_string temp_3253 = compact_string::make_from("cte");
	rel_algebra_node temp_3256 = subtree_r->local_ct;
	set_database_atom(temp_3253, temp_3256);

	compact_string temp_3258 = compact_string::make_from("cfd");
	rel_algebra_node temp_3260 = rel_algebra::trueTable();
	temp_3260 = rel_algebra::complement(temp_3260);
	set_database_atom(temp_3258, temp_3260);

	compact_string temp_3262 = compact_string::make_from("ctd");
	rel_algebra_node temp_3264 = rel_algebra::trueTable();
	temp_3264 = rel_algebra::complement(temp_3264);
	set_database_atom(temp_3262, temp_3264);

	compact_string temp_3266 = compact_string::make_from("attacks");
	rel_algebra_node temp_3267 = database[temp_3266];
	local_attacks01 = temp_3267;

	int64_t temp_3269 = 0;
	int64_t temp_3271 = 2;
	rel_algebra_node temp_3273 = local_attacks01;
	rel_algebra_node temp_3278 = generalized_filter_rename(temp_3269, temp_3271)(temp_3273);
	local_attacks21 = temp_3278;

	int64_t temp_3280 = 2;
	int64_t temp_3282 = 1;
	int64_t temp_3284 = 1;
	int64_t temp_3286 = 0;
	rel_algebra_node temp_3288 = local_attacks21;
	rel_algebra_node temp_3293 = generalized_filter_rename(temp_3284, temp_3286)(temp_3288);
	rel_algebra_node temp_3298 = generalized_filter_rename(temp_3280, temp_3282)(temp_3293);
	local_attacks10 = temp_3298;

	int64_t temp_3300 = 0;
	int64_t temp_3302 = 2;
	compact_string temp_3304 = compact_string::make_from("arguments");
	rel_algebra_node temp_3305 = database[temp_3304];
	rel_algebra_node temp_3310 = generalized_filter_equals(temp_3300, temp_3302)(temp_3305);
	local_args02 = temp_3310;
}

void gg_datatype_Output_type1::output_completion_semantics(ostream &os, rel_algebra_node local_arguments, rel_algebra_node local_attacks01, rel_algebra_node local_attacks10, rel_algebra_node local_cfe, rel_algebra_node local_cte, rel_algebra_node local_cfd, rel_algebra_node local_ctd, rel_algebra_node local_eDic0to2, rel_algebra_node local_eDic1to3, rel_algebra_node local_dDic0to2, rel_algebra_node local_dDic1to3) const
{
	rel_algebra_node temp_4093 = rel_algebra::trueTable();
	rel_algebra_node temp_4091 = local_cte;
	temp_4093 = rel_algebra::join(temp_4093, temp_4091);
	rel_algebra_node temp_4092 = local_eDic0to2;
	temp_4093 = rel_algebra::join(temp_4093, temp_4092);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4093); !local_tuple.atEnd(); ++local_tuple)
	{
		int64_t temp_4085 = 2;
		int64_t temp_4087 = local_tuple[temp_4085];
		os << temp_4087;
		os << " 0\n";
	}
	os << "c ~e(v1) | ~e(v0) for all (v0, v1) in attacks\n";
	rel_algebra_node temp_4117 = rel_algebra::trueTable();
	rel_algebra_node temp_4114 = local_attacks01;
	temp_4117 = rel_algebra::join(temp_4117, temp_4114);
	rel_algebra_node temp_4115 = local_eDic0to2;
	temp_4117 = rel_algebra::join(temp_4117, temp_4115);
	rel_algebra_node temp_4116 = local_eDic1to3;
	temp_4117 = rel_algebra::join(temp_4117, temp_4116);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4117); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4100 = 3;
		int64_t temp_4102 = local_tuple[temp_4100];
		os << temp_4102;
		os << " -";
		int64_t temp_4107 = 2;
		int64_t temp_4109 = local_tuple[temp_4107];
		os << temp_4109;
		os << " 0\n";
	}
	os << "c ~e(v1) | d(v0) for all (v0, v1) in attacks\n";
	rel_algebra_node temp_4142 = rel_algebra::trueTable();
	rel_algebra_node temp_4139 = local_attacks01;
	temp_4142 = rel_algebra::join(temp_4142, temp_4139);
	rel_algebra_node temp_4140 = local_eDic1to3;
	temp_4142 = rel_algebra::join(temp_4142, temp_4140);
	rel_algebra_node temp_4141 = local_dDic0to2;
	temp_4142 = rel_algebra::join(temp_4142, temp_4141);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4142); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4125 = 3;
		int64_t temp_4127 = local_tuple[temp_4125];
		os << temp_4127;
		os << " ";
		int64_t temp_4132 = 2;
		int64_t temp_4134 = local_tuple[temp_4132];
		os << temp_4134;
		os << " 0\n";
	}
	os << "c ~d(v0) | ?u0: (attacks(u0, v0) & e(u0)) for all v0 in arguments\n";
	rel_algebra_node temp_4204 = rel_algebra::trueTable();
	rel_algebra_node temp_4179 = local_arguments;
	temp_4204 = rel_algebra::join(temp_4204, temp_4179);
	rel_algebra_node temp_4182 = rel_algebra::trueTable();
	int64_t temp_4180 = 0;
	int64_t temp_4181 = 0;
	rel_algebra_node temp_4186 = rel_algebra::filterLessThanOrEqualTo(temp_4180, temp_4181, temp_4182);
	rel_algebra_node temp_4198 = rel_algebra::trueTable();
	rel_algebra_node temp_4187 = local_attacks10;
	temp_4198 = rel_algebra::join(temp_4198, temp_4187);
	int64_t temp_4188 = 0;
	int64_t temp_4190 = 1;
	rel_algebra_node temp_4192 = local_cte;
	rel_algebra_node temp_4197 = generalized_filter_rename(temp_4188, temp_4190)(temp_4192);
	temp_4198 = rel_algebra::join(temp_4198, temp_4197);
	rel_algebra_node temp_4201 = rel_algebra::complement(rel_algebra::divide(temp_4186, rel_algebra::complement(temp_4198)));
	rel_algebra_node temp_4202 = rel_algebra::complement(temp_4201);
	temp_4204 = rel_algebra::join(temp_4204, temp_4202);
	rel_algebra_node temp_4203 = local_dDic0to2;
	temp_4204 = rel_algebra::join(temp_4204, temp_4203);
	for (auto local_dtuple = rel_algebra::getUnitIterator(temp_4204); !local_dtuple.atEnd(); ++local_dtuple)
	{
		os << "-";
		int64_t temp_4150 = 2;
		int64_t temp_4152 = local_dtuple[temp_4150];
		os << temp_4152;
		rel_algebra_node temp_4172 = rel_algebra::trueTable();
		rel_algebra_node temp_4161 = local_attacks01;
		temp_4172 = rel_algebra::join(temp_4172, temp_4161);
		rel_algebra_node temp_4166 = rel_algebra::trueTable();
		int64_t temp_4162 = 1;
		int64_t temp_4163 = 0;
		int64_t temp_4165 = local_dtuple[temp_4163];
		rel_algebra_node temp_4170 = rel_algebra::filterEqualTo(temp_4162, temp_4165, temp_4166);
		temp_4172 = rel_algebra::join(temp_4172, temp_4170);
		rel_algebra_node temp_4171 = local_eDic0to2;
		temp_4172 = rel_algebra::join(temp_4172, temp_4171);
		for (auto local_etuple = rel_algebra::getUnitIterator(temp_4172); !local_etuple.atEnd(); ++local_etuple)
		{
			os << " ";
			int64_t temp_4156 = 2;
			int64_t temp_4158 = local_etuple[temp_4156];
			os << temp_4158;
		}
		os << " 0\n";
	}
	os << "c ~e(v0) | d(v1) for all (v0, v1) in attacks\n";
	rel_algebra_node temp_4229 = rel_algebra::trueTable();
	rel_algebra_node temp_4226 = local_attacks01;
	temp_4229 = rel_algebra::join(temp_4229, temp_4226);
	rel_algebra_node temp_4227 = local_eDic0to2;
	temp_4229 = rel_algebra::join(temp_4229, temp_4227);
	rel_algebra_node temp_4228 = local_dDic1to3;
	temp_4229 = rel_algebra::join(temp_4229, temp_4228);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4229); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4212 = 2;
		int64_t temp_4214 = local_tuple[temp_4212];
		os << temp_4214;
		os << " ";
		int64_t temp_4219 = 3;
		int64_t temp_4221 = local_tuple[temp_4219];
		os << temp_4221;
		os << " 0\n";
	}
	os << "c e(v0) | ?u0: (attacks(u0, v0) & d(u0))\n";
	rel_algebra_node temp_4289 = rel_algebra::trueTable();
	rel_algebra_node temp_4264 = local_arguments;
	temp_4289 = rel_algebra::join(temp_4289, temp_4264);
	rel_algebra_node temp_4267 = rel_algebra::trueTable();
	int64_t temp_4265 = 0;
	int64_t temp_4266 = 0;
	rel_algebra_node temp_4271 = rel_algebra::filterLessThanOrEqualTo(temp_4265, temp_4266, temp_4267);
	rel_algebra_node temp_4283 = rel_algebra::trueTable();
	rel_algebra_node temp_4272 = local_attacks10;
	temp_4283 = rel_algebra::join(temp_4283, temp_4272);
	int64_t temp_4273 = 0;
	int64_t temp_4275 = 1;
	rel_algebra_node temp_4277 = local_cfd;
	rel_algebra_node temp_4282 = generalized_filter_rename(temp_4273, temp_4275)(temp_4277);
	temp_4283 = rel_algebra::join(temp_4283, temp_4282);
	rel_algebra_node temp_4286 = rel_algebra::complement(rel_algebra::divide(temp_4271, rel_algebra::complement(temp_4283)));
	rel_algebra_node temp_4287 = rel_algebra::complement(temp_4286);
	temp_4289 = rel_algebra::join(temp_4289, temp_4287);
	rel_algebra_node temp_4288 = local_eDic0to2;
	temp_4289 = rel_algebra::join(temp_4289, temp_4288);
	for (auto local_etuple = rel_algebra::getUnitIterator(temp_4289); !local_etuple.atEnd(); ++local_etuple)
	{
		int64_t temp_4236 = 2;
		int64_t temp_4238 = local_etuple[temp_4236];
		os << temp_4238;
		rel_algebra_node temp_4257 = rel_algebra::trueTable();
		rel_algebra_node temp_4246 = local_attacks01;
		temp_4257 = rel_algebra::join(temp_4257, temp_4246);
		rel_algebra_node temp_4251 = rel_algebra::trueTable();
		int64_t temp_4247 = 1;
		int64_t temp_4248 = 0;
		int64_t temp_4250 = local_etuple[temp_4248];
		rel_algebra_node temp_4255 = rel_algebra::filterEqualTo(temp_4247, temp_4250, temp_4251);
		temp_4257 = rel_algebra::join(temp_4257, temp_4255);
		rel_algebra_node temp_4256 = local_dDic0to2;
		temp_4257 = rel_algebra::join(temp_4257, temp_4256);
		for (auto local_dtuple = rel_algebra::getUnitIterator(temp_4257); !local_dtuple.atEnd(); ++local_dtuple)
		{
			os << " -";
			int64_t temp_4241 = 2;
			int64_t temp_4243 = local_dtuple[temp_4241];
			os << temp_4243;
		}
		os << " 0\n";
	}
}

void gg_datatype_Output_type1::output_range_clauses(ostream &os, rel_algebra_node local_pDic0to2, rel_algebra_node local_eDicU0to3, rel_algebra_node local_dDic0to4, rel_algebra_node local_cfd, rel_algebra_node local_cfe) const
{
	os << "c ~e(v0) | p(v0) for v0 in arguments\n";
	rel_algebra_node temp_4322 = rel_algebra::trueTable();
	rel_algebra_node temp_4318 = local_pDic0to2;
	temp_4322 = rel_algebra::join(temp_4322, temp_4318);
	rel_algebra_node temp_4319 = local_cfd;
	rel_algebra_node temp_4320 = rel_algebra::complement(temp_4319);
	temp_4322 = rel_algebra::join(temp_4322, temp_4320);
	rel_algebra_node temp_4321 = local_eDicU0to3;
	temp_4322 = rel_algebra::join(temp_4322, temp_4321);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4322); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4304 = 3;
		int64_t temp_4306 = local_tuple[temp_4304];
		os << temp_4306;
		os << " ";
		int64_t temp_4311 = 2;
		int64_t temp_4313 = local_tuple[temp_4311];
		os << temp_4313;
		os << " 0\n";
	}
	os << "c ~d(v0) | p(v0) for v0 in arguments\n";
	rel_algebra_node temp_4348 = rel_algebra::trueTable();
	rel_algebra_node temp_4344 = local_pDic0to2;
	temp_4348 = rel_algebra::join(temp_4348, temp_4344);
	rel_algebra_node temp_4345 = local_cfe;
	rel_algebra_node temp_4346 = rel_algebra::complement(temp_4345);
	temp_4348 = rel_algebra::join(temp_4348, temp_4346);
	rel_algebra_node temp_4347 = local_dDic0to4;
	temp_4348 = rel_algebra::join(temp_4348, temp_4347);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4348); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4330 = 4;
		int64_t temp_4332 = local_tuple[temp_4330];
		os << temp_4332;
		os << " ";
		int64_t temp_4337 = 2;
		int64_t temp_4339 = local_tuple[temp_4337];
		os << temp_4339;
		os << " 0\n";
	}
	os << "c ~p(v0) | e(v0) | d(v0) for v0 in arguments\n";
	rel_algebra_node temp_4380 = rel_algebra::trueTable();
	rel_algebra_node temp_4377 = local_pDic0to2;
	temp_4380 = rel_algebra::join(temp_4380, temp_4377);
	rel_algebra_node temp_4378 = local_eDicU0to3;
	temp_4380 = rel_algebra::join(temp_4380, temp_4378);
	rel_algebra_node temp_4379 = local_dDic0to4;
	temp_4380 = rel_algebra::join(temp_4380, temp_4379);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4380); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4356 = 2;
		int64_t temp_4358 = local_tuple[temp_4356];
		os << temp_4358;
		os << " ";
		int64_t temp_4363 = 3;
		int64_t temp_4365 = local_tuple[temp_4363];
		os << temp_4365;
		os << " ";
		int64_t temp_4370 = 4;
		int64_t temp_4372 = local_tuple[temp_4370];
		os << temp_4372;
		os << " 0\n";
	}
}

void gg_datatype_Output_type1::output_unary_proper_subset_clauses(ostream &os, rel_algebra_node local_dictionary) const
{
	os << "c generating clauses to prove that s1 is a proper subset of s2\n";
	os << "c ~s1(x) | s2(x)\n";
	rel_algebra_node temp_4407 = local_dictionary;
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4407); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4393 = 1;
		int64_t temp_4395 = local_tuple[temp_4393];
		os << temp_4395;
		os << " ";
		int64_t temp_4400 = 2;
		int64_t temp_4402 = local_tuple[temp_4400];
		os << temp_4402;
		os << " 0\n";
	}
	os << "c ?x: diff(x)\n";
	rel_algebra_node temp_4420 = local_dictionary;
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4420); !local_tuple.atEnd(); ++local_tuple)
	{
		int64_t temp_4414 = 3;
		int64_t temp_4416 = local_tuple[temp_4414];
		os << temp_4416;
		os << " ";
	}
	os << "0\n";
	os << "c ~diff(x) | s2(x)\n";
	rel_algebra_node temp_4444 = local_dictionary;
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4444); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4430 = 3;
		int64_t temp_4432 = local_tuple[temp_4430];
		os << temp_4432;
		os << " ";
		int64_t temp_4437 = 2;
		int64_t temp_4439 = local_tuple[temp_4437];
		os << temp_4439;
		os << " 0\n";
	}
	os << "c ~diff(x) | ~s1(x)\n";
	rel_algebra_node temp_4466 = local_dictionary;
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4466); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4452 = 3;
		int64_t temp_4454 = local_tuple[temp_4452];
		os << temp_4454;
		os << " -";
		int64_t temp_4459 = 1;
		int64_t temp_4461 = local_tuple[temp_4459];
		os << temp_4461;
		os << " 0\n";
	}
	os << "c diff(x) | s1(x) | ~s2(x)\n";
	rel_algebra_node temp_4493 = local_dictionary;
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4493); !local_tuple.atEnd(); ++local_tuple)
	{
		int64_t temp_4473 = 3;
		int64_t temp_4475 = local_tuple[temp_4473];
		os << temp_4475;
		os << " ";
		int64_t temp_4479 = 1;
		int64_t temp_4481 = local_tuple[temp_4479];
		os << temp_4481;
		os << " -";
		int64_t temp_4486 = 2;
		int64_t temp_4488 = local_tuple[temp_4486];
		os << temp_4488;
		os << " 0\n";
	}
}

void gg_datatype_Output_type1::output_stage_semantics(ostream &os, rel_algebra_node local_attacks01, rel_algebra_node local_eDicTU0to2, rel_algebra_node local_eDicTU1to3, rel_algebra_node local_pDicU0to2, rel_algebra_node local_pDicU0to3, rel_algebra_node local_pDicU1to3, rel_algebra_node local_cte) const
{
	rel_algebra_node temp_4516 = rel_algebra::trueTable();
	rel_algebra_node temp_4514 = local_eDicTU0to2;
	temp_4516 = rel_algebra::join(temp_4516, temp_4514);
	rel_algebra_node temp_4515 = local_cte;
	temp_4516 = rel_algebra::join(temp_4516, temp_4515);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4516); !local_tuple.atEnd(); ++local_tuple)
	{
		int64_t temp_4508 = 2;
		int64_t temp_4510 = local_tuple[temp_4508];
		os << temp_4510;
		os << " 0\n";
	}
	os << "c ~e(x) | ~e(y) for (x,y) in attacks\n";
	rel_algebra_node temp_4553 = rel_algebra::trueTable();
	rel_algebra_node temp_4537 = local_attacks01;
	temp_4553 = rel_algebra::join(temp_4553, temp_4537);
	rel_algebra_node temp_4538 = local_eDicTU0to2;
	temp_4553 = rel_algebra::join(temp_4553, temp_4538);
	rel_algebra_node temp_4539 = local_cte;
	rel_algebra_node temp_4540 = rel_algebra::complement(temp_4539);
	temp_4553 = rel_algebra::join(temp_4553, temp_4540);
	int64_t temp_4541 = 0;
	int64_t temp_4543 = 1;
	rel_algebra_node temp_4545 = local_cte;
	rel_algebra_node temp_4550 = generalized_filter_rename(temp_4541, temp_4543)(temp_4545);
	rel_algebra_node temp_4551 = rel_algebra::complement(temp_4550);
	temp_4553 = rel_algebra::join(temp_4553, temp_4551);
	rel_algebra_node temp_4552 = local_eDicTU1to3;
	temp_4553 = rel_algebra::join(temp_4553, temp_4552);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4553); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4523 = 2;
		int64_t temp_4525 = local_tuple[temp_4523];
		os << temp_4525;
		os << " -";
		int64_t temp_4530 = 3;
		int64_t temp_4532 = local_tuple[temp_4530];
		os << temp_4532;
		os << " 0\n";
	}
	os << "c ~e(x) | p(x) for x in arguments\n";
	rel_algebra_node temp_4579 = rel_algebra::trueTable();
	rel_algebra_node temp_4575 = local_pDicU0to3;
	temp_4579 = rel_algebra::join(temp_4579, temp_4575);
	rel_algebra_node temp_4576 = local_eDicTU0to2;
	temp_4579 = rel_algebra::join(temp_4579, temp_4576);
	rel_algebra_node temp_4577 = local_cte;
	rel_algebra_node temp_4578 = rel_algebra::complement(temp_4577);
	temp_4579 = rel_algebra::join(temp_4579, temp_4578);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4579); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4561 = 2;
		int64_t temp_4563 = local_tuple[temp_4561];
		os << temp_4563;
		os << " ";
		int64_t temp_4568 = 3;
		int64_t temp_4570 = local_tuple[temp_4568];
		os << temp_4570;
		os << " 0\n";
	}
	os << "c ~e(x) | p(y) for (x, y) in attacks\n";
	rel_algebra_node temp_4606 = rel_algebra::trueTable();
	rel_algebra_node temp_4601 = local_attacks01;
	temp_4606 = rel_algebra::join(temp_4606, temp_4601);
	rel_algebra_node temp_4602 = local_eDicTU0to2;
	temp_4606 = rel_algebra::join(temp_4606, temp_4602);
	rel_algebra_node temp_4603 = local_cte;
	rel_algebra_node temp_4604 = rel_algebra::complement(temp_4603);
	temp_4606 = rel_algebra::join(temp_4606, temp_4604);
	rel_algebra_node temp_4605 = local_pDicU1to3;
	temp_4606 = rel_algebra::join(temp_4606, temp_4605);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4606); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4587 = 2;
		int64_t temp_4589 = local_tuple[temp_4587];
		os << temp_4589;
		os << " ";
		int64_t temp_4594 = 3;
		int64_t temp_4596 = local_tuple[temp_4594];
		os << temp_4596;
		os << " 0\n";
	}
	os << "c ~p(x) | e(x) | ?y: (attack(y, x) & e(y)) for x in arguments\n";
	rel_algebra_node temp_4654 = rel_algebra::trueTable();
	rel_algebra_node temp_4650 = local_pDicU0to3;
	temp_4654 = rel_algebra::join(temp_4654, temp_4650);
	rel_algebra_node temp_4651 = local_eDicTU0to2;
	temp_4654 = rel_algebra::join(temp_4654, temp_4651);
	rel_algebra_node temp_4652 = local_cte;
	rel_algebra_node temp_4653 = rel_algebra::complement(temp_4652);
	temp_4654 = rel_algebra::join(temp_4654, temp_4653);
	for (auto local_xtuple = rel_algebra::getUnitIterator(temp_4654); !local_xtuple.atEnd(); ++local_xtuple)
	{
		os << "-";
		int64_t temp_4614 = 3;
		int64_t temp_4616 = local_xtuple[temp_4614];
		os << temp_4616;
		os << " ";
		int64_t temp_4621 = 2;
		int64_t temp_4623 = local_xtuple[temp_4621];
		os << temp_4623;
		rel_algebra_node temp_4643 = rel_algebra::trueTable();
		rel_algebra_node temp_4632 = local_attacks01;
		temp_4643 = rel_algebra::join(temp_4643, temp_4632);
		rel_algebra_node temp_4637 = rel_algebra::trueTable();
		int64_t temp_4633 = 1;
		int64_t temp_4634 = 0;
		int64_t temp_4636 = local_xtuple[temp_4634];
		rel_algebra_node temp_4641 = rel_algebra::filterEqualTo(temp_4633, temp_4636, temp_4637);
		temp_4643 = rel_algebra::join(temp_4643, temp_4641);
		rel_algebra_node temp_4642 = local_eDicTU0to2;
		temp_4643 = rel_algebra::join(temp_4643, temp_4642);
		for (auto local_ytuple = rel_algebra::getUnitIterator(temp_4643); !local_ytuple.atEnd(); ++local_ytuple)
		{
			os << " ";
			int64_t temp_4627 = 2;
			int64_t temp_4629 = local_ytuple[temp_4627];
			os << temp_4629;
		}
		os << " 0\n";
	}
}

void gg_datatype_Output_type1::output_admissibility_clauses(ostream &os, rel_algebra_node local_attacks01, rel_algebra_node local_eDic0to2, rel_algebra_node local_eDic1to3, rel_algebra_node local_cte) const
{
	rel_algebra_node temp_4674 = rel_algebra::trueTable();
	rel_algebra_node temp_4672 = local_cte;
	temp_4674 = rel_algebra::join(temp_4674, temp_4672);
	rel_algebra_node temp_4673 = local_eDic0to2;
	temp_4674 = rel_algebra::join(temp_4674, temp_4673);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4674); !local_tuple.atEnd(); ++local_tuple)
	{
		int64_t temp_4666 = 2;
		int64_t temp_4668 = local_tuple[temp_4666];
		os << temp_4668;
		os << " 0\n";
	}
	os << "c ~e(v1) | ~e(v0) for all (v0, v1) in attacks\n";
	rel_algebra_node temp_4698 = rel_algebra::trueTable();
	rel_algebra_node temp_4695 = local_attacks01;
	temp_4698 = rel_algebra::join(temp_4698, temp_4695);
	rel_algebra_node temp_4696 = local_eDic0to2;
	temp_4698 = rel_algebra::join(temp_4698, temp_4696);
	rel_algebra_node temp_4697 = local_eDic1to3;
	temp_4698 = rel_algebra::join(temp_4698, temp_4697);
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4698); !local_tuple.atEnd(); ++local_tuple)
	{
		os << "-";
		int64_t temp_4681 = 3;
		int64_t temp_4683 = local_tuple[temp_4681];
		os << temp_4683;
		os << " -";
		int64_t temp_4688 = 2;
		int64_t temp_4690 = local_tuple[temp_4688];
		os << temp_4690;
		os << " 0\n";
	}
	os << "c ~e(v1) | ?v2:(attacks(v2, v0) & e(v2)) for all (v0, v1) in attacks\n";
	rel_algebra_node temp_4737 = rel_algebra::trueTable();
	rel_algebra_node temp_4735 = local_attacks01;
	temp_4737 = rel_algebra::join(temp_4737, temp_4735);
	rel_algebra_node temp_4736 = local_eDic1to3;
	temp_4737 = rel_algebra::join(temp_4737, temp_4736);
	for (auto local_tuple1 = rel_algebra::getUnitIterator(temp_4737); !local_tuple1.atEnd(); ++local_tuple1)
	{
		os << "-";
		int64_t temp_4706 = 3;
		int64_t temp_4708 = local_tuple1[temp_4706];
		os << temp_4708;
		rel_algebra_node temp_4728 = rel_algebra::trueTable();
		rel_algebra_node temp_4717 = local_attacks01;
		temp_4728 = rel_algebra::join(temp_4728, temp_4717);
		rel_algebra_node temp_4722 = rel_algebra::trueTable();
		int64_t temp_4718 = 1;
		int64_t temp_4719 = 0;
		int64_t temp_4721 = local_tuple1[temp_4719];
		rel_algebra_node temp_4726 = rel_algebra::filterEqualTo(temp_4718, temp_4721, temp_4722);
		temp_4728 = rel_algebra::join(temp_4728, temp_4726);
		rel_algebra_node temp_4727 = local_eDic0to2;
		temp_4728 = rel_algebra::join(temp_4728, temp_4727);
		for (auto local_tuple2 = rel_algebra::getUnitIterator(temp_4728); !local_tuple2.atEnd(); ++local_tuple2)
		{
			os << " ";
			int64_t temp_4712 = 2;
			int64_t temp_4714 = local_tuple2[temp_4712];
			os << temp_4714;
		}
		os << " 0\n";
	}
}

string gg_datatype_Output_type1::toString() const
{
	string result = "";
	return result;
}

gg_datatype_Output_type1::gg_datatype_Output_type1() : gg_datatype_Output_base()
{
}

string gg_datatype_Reasoning_type1::toString() const
{
	string result = "";
	result += "brave";
	result += subtree_argument->toString();
	return result;
}

gg_datatype_Reasoning_type1::gg_datatype_Reasoning_type1(gg_datatype_ArgName_base* const &argument) : gg_datatype_Reasoning_base(), subtree_argument(argument)
{
	rel_algebra_node temp_4755 = rel_algebra::trueTable();
	int64_t temp_4752 = 0;
	int64_t temp_4754 = subtree_argument->local_arg;
	rel_algebra_node temp_4759 = rel_algebra::filterEqualTo(temp_4752, temp_4754, temp_4755);
	local_ct = temp_4759;

	rel_algebra_node temp_4761 = rel_algebra::trueTable();
	temp_4761 = rel_algebra::complement(temp_4761);
	local_cf = temp_4761;
}

string gg_datatype_Reasoning_type2::toString() const
{
	string result = "";
	result += "skeptical";
	result += subtree_argument->toString();
	return result;
}

gg_datatype_Reasoning_type2::gg_datatype_Reasoning_type2(gg_datatype_ArgName_base* const &argument) : gg_datatype_Reasoning_base(), subtree_argument(argument)
{
	rel_algebra_node temp_4772 = rel_algebra::trueTable();
	temp_4772 = rel_algebra::complement(temp_4772);
	local_ct = temp_4772;

	rel_algebra_node temp_4777 = rel_algebra::trueTable();
	int64_t temp_4774 = 0;
	int64_t temp_4776 = subtree_argument->local_arg;
	rel_algebra_node temp_4781 = rel_algebra::filterEqualTo(temp_4774, temp_4776, temp_4777);
	local_cf = temp_4781;
}

string gg_datatype_Reasoning_type3::toString() const
{
	string result = "";
	result += "search";
	return result;
}

gg_datatype_Reasoning_type3::gg_datatype_Reasoning_type3() : gg_datatype_Reasoning_base()
{
	rel_algebra_node temp_4790 = rel_algebra::trueTable();
	temp_4790 = rel_algebra::complement(temp_4790);
	local_ct = temp_4790;

	rel_algebra_node temp_4792 = rel_algebra::trueTable();
	temp_4792 = rel_algebra::complement(temp_4792);
	local_cf = temp_4792;
}

void gg_datatype_Input_type1::output_symbolTable(ostream &os) const
{
	rel_algebra_node temp_4897 = rel_algebra::trueTable();
	rel_algebra_node temp_4885 = rel_algebra::trueTable();
	int64_t temp_4883 = 0;
	int64_t temp_4884 = 0;
	rel_algebra_node temp_4889 = rel_algebra::filterGreaterThanOrEqualTo(temp_4883, temp_4884, temp_4885);
	temp_4897 = rel_algebra::join(temp_4897, temp_4889);
	rel_algebra_node temp_4892 = rel_algebra::trueTable();
	int64_t temp_4890 = 0;
	int64_t temp_4891 = local_argCount;
	rel_algebra_node temp_4896 = rel_algebra::filterLessThan(temp_4890, temp_4891, temp_4892);
	temp_4897 = rel_algebra::join(temp_4897, temp_4896);
	for (auto local_i = rel_algebra::getUnitIterator(temp_4897); !local_i.atEnd(); ++local_i)
	{
		int64_t temp_4876 = 0;
		int64_t temp_4878 = local_i[temp_4876];
		subtree_args[temp_4878]->output_symbolTableLine(os);
	}
}

string gg_datatype_Input_type1::toString() const
{
	string result = "";
	result += "apx";
	for (auto it = subtree_args.begin(); it != subtree_args.end(); ++it)
		result += (*it)->toString();
	for (auto it = subtree_atts.begin(); it != subtree_atts.end(); ++it)
		result += (*it)->toString();
	return result;
}

gg_datatype_Input_type1::gg_datatype_Input_type1(vector<gg_datatype_APXArgument_base*> const &args, vector<gg_datatype_APXAttack_base*> const &atts) : gg_datatype_Input_base(), subtree_args(args), subtree_atts(atts)
{
	int64_t temp_4806 = subtree_args.size();
	local_argCount = temp_4806;

	compact_string temp_4808 = compact_string::make_from("arguments");
	rel_algebra_node temp_4825 = rel_algebra::trueTable();
	rel_algebra_node temp_4812 = rel_algebra::trueTable();
	int64_t temp_4810 = 0;
	int64_t temp_4811 = 1;
	rel_algebra_node temp_4816 = rel_algebra::filterGreaterThanOrEqualTo(temp_4810, temp_4811, temp_4812);
	temp_4825 = rel_algebra::join(temp_4825, temp_4816);
	rel_algebra_node temp_4820 = rel_algebra::trueTable();
	int64_t temp_4817 = 0;
	int64_t temp_4819 = subtree_args.size();
	rel_algebra_node temp_4824 = rel_algebra::filterLessThanOrEqualTo(temp_4817, temp_4819, temp_4820);
	temp_4825 = rel_algebra::join(temp_4825, temp_4824);
	set_database_atom(temp_4808, temp_4825);

	compact_string temp_4827 = compact_string::make_from("attacks");
	rel_algebra_node temp_4869 = rel_algebra::trueTable();
	rel_algebra_node temp_4856 = rel_algebra::trueTable();
	int64_t temp_4854 = 0;
	int64_t temp_4855 = 0;
	rel_algebra_node temp_4860 = rel_algebra::filterGreaterThanOrEqualTo(temp_4854, temp_4855, temp_4856);
	temp_4869 = rel_algebra::join(temp_4869, temp_4860);
	rel_algebra_node temp_4864 = rel_algebra::trueTable();
	int64_t temp_4861 = 0;
	int64_t temp_4863 = subtree_atts.size();
	rel_algebra_node temp_4868 = rel_algebra::filterLessThan(temp_4861, temp_4863, temp_4864);
	temp_4869 = rel_algebra::join(temp_4869, temp_4868);
	rel_algebra_node temp_4872 = rel_algebra::trueTable();
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4869); !local_tuple.atEnd(); ++local_tuple)
	{
		rel_algebra_node temp_4853 = rel_algebra::trueTable();
		rel_algebra_node temp_4836 = rel_algebra::trueTable();
		int64_t temp_4829 = 0;
		int64_t temp_4830 = 0;
		int64_t temp_4832 = local_tuple[temp_4830];
		int64_t temp_4835 = subtree_atts[temp_4832]->local_source;
		rel_algebra_node temp_4840 = rel_algebra::filterEqualTo(temp_4829, temp_4835, temp_4836);
		temp_4853 = rel_algebra::join(temp_4853, temp_4840);
		rel_algebra_node temp_4848 = rel_algebra::trueTable();
		int64_t temp_4841 = 1;
		int64_t temp_4842 = 0;
		int64_t temp_4844 = local_tuple[temp_4842];
		int64_t temp_4847 = subtree_atts[temp_4844]->local_target;
		rel_algebra_node temp_4852 = rel_algebra::filterEqualTo(temp_4841, temp_4847, temp_4848);
		temp_4853 = rel_algebra::join(temp_4853, temp_4852);
		temp_4872 = rel_algebra::join(temp_4872, rel_algebra::complement(temp_4853));
		if (rel_algebra::isEmpty(rel_algebra::complement(temp_4872))) break;
	}
	temp_4872 = rel_algebra::complement(temp_4872);
	set_database_atom(temp_4827, temp_4872);
}

void gg_datatype_Input_type2::output_symbolTable(ostream &os) const
{
	rel_algebra_node temp_5007 = rel_algebra::trueTable();
	rel_algebra_node temp_4995 = rel_algebra::trueTable();
	int64_t temp_4993 = 0;
	int64_t temp_4994 = 0;
	rel_algebra_node temp_4999 = rel_algebra::filterGreaterThanOrEqualTo(temp_4993, temp_4994, temp_4995);
	temp_5007 = rel_algebra::join(temp_5007, temp_4999);
	rel_algebra_node temp_5002 = rel_algebra::trueTable();
	int64_t temp_5000 = 0;
	int64_t temp_5001 = local_argCount;
	rel_algebra_node temp_5006 = rel_algebra::filterLessThan(temp_5000, temp_5001, temp_5002);
	temp_5007 = rel_algebra::join(temp_5007, temp_5006);
	for (auto local_i = rel_algebra::getUnitIterator(temp_5007); !local_i.atEnd(); ++local_i)
	{
		int64_t temp_4986 = 0;
		int64_t temp_4988 = local_i[temp_4986];
		subtree_args[temp_4988]->output_symbolTableLine(os);
	}
}

string gg_datatype_Input_type2::toString() const
{
	string result = "";
	result += "tgf";
	for (auto it = subtree_args.begin(); it != subtree_args.end(); ++it)
		result += (*it)->toString();
	result += "#";
	for (auto it = subtree_atts.begin(); it != subtree_atts.end(); ++it)
		result += (*it)->toString();
	return result;
}

gg_datatype_Input_type2::gg_datatype_Input_type2(vector<gg_datatype_TGFArgument_base*> const &args, vector<gg_datatype_TGFAttack_base*> const &atts) : gg_datatype_Input_base(), subtree_args(args), subtree_atts(atts)
{
	int64_t temp_4916 = subtree_args.size();
	local_argCount = temp_4916;

	compact_string temp_4918 = compact_string::make_from("arguments");
	rel_algebra_node temp_4935 = rel_algebra::trueTable();
	rel_algebra_node temp_4922 = rel_algebra::trueTable();
	int64_t temp_4920 = 0;
	int64_t temp_4921 = 1;
	rel_algebra_node temp_4926 = rel_algebra::filterGreaterThanOrEqualTo(temp_4920, temp_4921, temp_4922);
	temp_4935 = rel_algebra::join(temp_4935, temp_4926);
	rel_algebra_node temp_4930 = rel_algebra::trueTable();
	int64_t temp_4927 = 0;
	int64_t temp_4929 = subtree_args.size();
	rel_algebra_node temp_4934 = rel_algebra::filterLessThanOrEqualTo(temp_4927, temp_4929, temp_4930);
	temp_4935 = rel_algebra::join(temp_4935, temp_4934);
	set_database_atom(temp_4918, temp_4935);

	compact_string temp_4937 = compact_string::make_from("attacks");
	rel_algebra_node temp_4979 = rel_algebra::trueTable();
	rel_algebra_node temp_4966 = rel_algebra::trueTable();
	int64_t temp_4964 = 0;
	int64_t temp_4965 = 0;
	rel_algebra_node temp_4970 = rel_algebra::filterGreaterThanOrEqualTo(temp_4964, temp_4965, temp_4966);
	temp_4979 = rel_algebra::join(temp_4979, temp_4970);
	rel_algebra_node temp_4974 = rel_algebra::trueTable();
	int64_t temp_4971 = 0;
	int64_t temp_4973 = subtree_atts.size();
	rel_algebra_node temp_4978 = rel_algebra::filterLessThan(temp_4971, temp_4973, temp_4974);
	temp_4979 = rel_algebra::join(temp_4979, temp_4978);
	rel_algebra_node temp_4982 = rel_algebra::trueTable();
	for (auto local_tuple = rel_algebra::getUnitIterator(temp_4979); !local_tuple.atEnd(); ++local_tuple)
	{
		rel_algebra_node temp_4963 = rel_algebra::trueTable();
		rel_algebra_node temp_4946 = rel_algebra::trueTable();
		int64_t temp_4939 = 0;
		int64_t temp_4940 = 0;
		int64_t temp_4942 = local_tuple[temp_4940];
		int64_t temp_4945 = subtree_atts[temp_4942]->local_source;
		rel_algebra_node temp_4950 = rel_algebra::filterEqualTo(temp_4939, temp_4945, temp_4946);
		temp_4963 = rel_algebra::join(temp_4963, temp_4950);
		rel_algebra_node temp_4958 = rel_algebra::trueTable();
		int64_t temp_4951 = 1;
		int64_t temp_4952 = 0;
		int64_t temp_4954 = local_tuple[temp_4952];
		int64_t temp_4957 = subtree_atts[temp_4954]->local_target;
		rel_algebra_node temp_4962 = rel_algebra::filterEqualTo(temp_4951, temp_4957, temp_4958);
		temp_4963 = rel_algebra::join(temp_4963, temp_4962);
		temp_4982 = rel_algebra::join(temp_4982, rel_algebra::complement(temp_4963));
		if (rel_algebra::isEmpty(rel_algebra::complement(temp_4982))) break;
	}
	temp_4982 = rel_algebra::complement(temp_4982);
	set_database_atom(temp_4937, temp_4982);
}

void gg_datatype_APXArgument_type1::output_symbolTableLine(ostream &os) const
{
	os << "c ";
	int64_t temp_5031 = subtree_argument->local_arg;
	os << temp_5031;
	os << " ";
	subtree_argument->output_name(os);
	os << "\n";
}

string gg_datatype_APXArgument_type1::toString() const
{
	string result = "";
	result += "arg";
	result += "(";
	result += subtree_argument->toString();
	result += ")";
	result += ".";
	return result;
}

gg_datatype_APXArgument_type1::gg_datatype_APXArgument_type1(gg_datatype_ArgName_base* const &argument) : gg_datatype_APXArgument_base(), subtree_argument(argument)
{
}

string gg_datatype_APXAttack_type1::toString() const
{
	string result = "";
	result += "att";
	result += "(";
	result += subtree_attacker->toString();
	result += ",";
	result += subtree_attacked->toString();
	result += ")";
	result += ".";
	return result;
}

gg_datatype_APXAttack_type1::gg_datatype_APXAttack_type1(gg_datatype_ArgName_base* const &attacker, gg_datatype_ArgName_base* const &attacked) : gg_datatype_APXAttack_base(), subtree_attacker(attacker), subtree_attacked(attacked)
{
	int64_t temp_5063 = subtree_attacker->local_arg;
	local_source = temp_5063;

	int64_t temp_5066 = subtree_attacked->local_arg;
	local_target = temp_5066;
}

void gg_datatype_TGFArgument_type1::output_symbolTableLine(ostream &os) const
{
	os << "c ";
	int64_t temp_5079 = subtree_argument->local_arg;
	os << temp_5079;
	os << " ";
	subtree_argument->output_name(os);
	os << "\n";
}

string gg_datatype_TGFArgument_type1::toString() const
{
	string result = "";
	result += subtree_argument->toString();
	return result;
}

gg_datatype_TGFArgument_type1::gg_datatype_TGFArgument_type1(gg_datatype_ArgName_base* const &argument) : gg_datatype_TGFArgument_base(), subtree_argument(argument)
{
}

string gg_datatype_TGFAttack_type1::toString() const
{
	string result = "";
	result += subtree_attacker->toString();
	result += subtree_attacked->toString();
	return result;
}

gg_datatype_TGFAttack_type1::gg_datatype_TGFAttack_type1(gg_datatype_ArgName_base* const &attacker, gg_datatype_ArgName_base* const &attacked) : gg_datatype_TGFAttack_base(), subtree_attacker(attacker), subtree_attacked(attacked)
{
	int64_t temp_5101 = subtree_attacker->local_arg;
	local_source = temp_5101;

	int64_t temp_5104 = subtree_attacked->local_arg;
	local_target = temp_5104;
}

void gg_datatype_ArgName_type1::output_name(ostream &os) const
{
	os << subtree_argId;
}

string gg_datatype_ArgName_type1::toString() const
{
	string result = "";
	result += subtree_argId.toString();
	return result;
}

gg_datatype_ArgName_type1::gg_datatype_ArgName_type1(compact_string const &argId) : gg_datatype_ArgName_base(), subtree_argId(argId)
{
	compact_string temp_5113 = compact_string::make_from("arguments");
	compact_string temp_5115 = subtree_argId;
	int64_t temp_5118 = mapToInt(temp_5113, temp_5115);
	local_arg = temp_5118;
}

void gg_datatype_ArgName_type2::output_name(ostream &os) const
{
	int64_t temp_5143 = subtree_argNo;
	os << temp_5143;
}

string gg_datatype_ArgName_type2::toString() const
{
	string result = "";
	result += to_string(subtree_argNo);
	return result;
}

gg_datatype_ArgName_type2::gg_datatype_ArgName_type2(int64_t const &argNo) : gg_datatype_ArgName_base(), subtree_argNo(argNo)
{
	compact_string temp_5132 = compact_string::make_from("argumnets");
	int64_t temp_5134 = subtree_argNo;
	compact_string temp_5135 = compact_string::make_from(temp_5134);
	int64_t temp_5138 = mapToInt(temp_5132, temp_5135);
	local_arg = temp_5138;
}


