
/* generalized-filters.h */

#ifndef _GENERALIZED_FILTERS_H
#define _GENERALIZED_FILTERS_H

#include "relalgebra.h"


class generalized_filter_equals
{
	private:
		int64_t param_1;
		int64_t param_val_1;
		bool has_val_1;

		int64_t param_2;
		int64_t param_val_2;
		bool has_val_2;

		bool is_rule_1_applicable();
		Table apply_rule_1(Table currentNode);

		bool is_rule_2_applicable();
		Table apply_rule_2(Table currentNode);

	public:
		Table operator()(Table currentNode);
		generalized_filter_equals(int64_t param_var_1, int64_t param_var_2) :
			param_1(param_var_1),
			param_val_1(0),
			has_val_1(false),
			param_2(param_var_2),
			param_val_2(0),
			has_val_2(false)
		{
		}
};

class generalized_filter_rename
{
	private:
		int64_t param_1;
		int64_t param_val_1;
		bool has_val_1;

		int64_t param_2;
		int64_t param_val_2;
		bool has_val_2;

		bool is_rule_1_applicable();
		Table apply_rule_1(Table currentNode);

		bool is_rule_2_applicable();
		Table apply_rule_2(Table currentNode);

	public:
		Table operator()(Table currentNode);
		generalized_filter_rename(int64_t param_var_1, int64_t param_var_2) :
			param_1(param_var_1),
			param_val_1(0),
			has_val_1(false),
			param_2(param_var_2),
			param_val_2(0),
			has_val_2(false)
		{
		}
};


#endif

