
#include "generalized-filters.h"
#include "macros.h"


bool generalized_filter_equals::is_rule_1_applicable()
{
	if (!has_val_1)
		return false;

	return true;
}

Table generalized_filter_equals::apply_rule_1(Table currentNode)
{
	rel_algebra_node temp_5526 = rel_algebra::trueTable();
	rel_algebra_node temp_5518 = currentNode;
	temp_5526 = rel_algebra::join(temp_5526, temp_5518);
	rel_algebra_node temp_5521 = rel_algebra::trueTable();
	int64_t temp_5519 = param_2;
	int64_t temp_5520 = param_val_1;
	rel_algebra_node temp_5525 = rel_algebra::filterEqualTo(temp_5519, temp_5520, temp_5521);
	temp_5526 = rel_algebra::join(temp_5526, temp_5525);

	return temp_5526;
}

bool generalized_filter_equals::is_rule_2_applicable()
{
	if (!has_val_2)
		return false;

	return true;
}

Table generalized_filter_equals::apply_rule_2(Table currentNode)
{
	rel_algebra_node temp_5540 = rel_algebra::trueTable();
	rel_algebra_node temp_5532 = currentNode;
	temp_5540 = rel_algebra::join(temp_5540, temp_5532);
	rel_algebra_node temp_5535 = rel_algebra::trueTable();
	int64_t temp_5533 = param_1;
	int64_t temp_5534 = param_val_2;
	rel_algebra_node temp_5539 = rel_algebra::filterEqualTo(temp_5533, temp_5534, temp_5535);
	temp_5540 = rel_algebra::join(temp_5540, temp_5539);

	return temp_5540;
}

Table generalized_filter_equals::operator()(Table currentNode)
{
	if (rel_algebra::isEmpty(currentNode))
		return currentNode;

	if (is_rule_1_applicable())
		return apply_rule_1(currentNode);
	if (is_rule_2_applicable())
		return apply_rule_2(currentNode);

	if (rel_algebra::isLeafNode(currentNode))
		assert(false); // infinite domain
	VariableType currentVar = rel_algebra::getVariable(currentNode);
	bool infiniteDomainDetected = true;
	if (param_1 >= currentVar)
		infiniteDomainDetected = false;
	if (param_2 >= currentVar)
		infiniteDomainDetected = false;
	if (infiniteDomainDetected)
		assert(false); // infinite domain

	size_t currentStackSize = global_table_stack::size();
	while (true)
	{
		if (rel_algebra::isLeafNode(currentNode))
			break;
		if (rel_algebra::getVariable(currentNode) != currentVar)
			break;
		global_table_stack::push(currentNode);
		currentNode = rel_algebra::getElseBranch(currentNode);
	}

	bool currentVarIsAParam = false;
	if (param_1 == currentVar)
		currentVarIsAParam = true;
	if (param_2 == currentVar)
		currentVarIsAParam = true;
	if (!currentVarIsAParam)
	{
		currentNode = (*this)(currentNode);
		while (global_table_stack::size() > currentStackSize)
		{
			Table t = global_table_stack::pop();
			Table thenNode = rel_algebra::getThenBranch(t);
			currentNode = rel_algebra::ifThenElse(currentVar, rel_algebra::getValue(t), (*this)(thenNode), currentNode);
		}
	}
	else
	{
		if (!rel_algebra::isEmpty(currentNode))
			assert(false); // infinite domain detected for parameter
		if (param_1 == currentVar)
			has_val_1 = true;
		if (param_2 == currentVar)
			has_val_2 = true;
		Table lastTable = global_table_stack::pop();

		while (global_table_stack::size() > currentStackSize)
		{
			Table beforeLastTable = global_table_stack::pop();
			Table thenNode = rel_algebra::getThenBranch(lastTable);
			if (rel_algebra::isEmpty(thenNode))
				currentNode = rel_algebra::ifThenElse(currentVar, rel_algebra::getValue(lastTable), rel_algebra::falseTable(), currentNode);
			else
			{
				ValueType lowerBound = rel_algebra::getValue(beforeLastTable);
				ValueType upperBound = rel_algebra::getValue(lastTable);
				for (ValueType value = upperBound; value > lowerBound; value--)
				{
					if (param_1 == currentVar)
						param_val_1 = value;
					if (param_2 == currentVar)
						param_val_2 = value;
					currentNode = rel_algebra::ifThenElse(currentVar, value, (*this)(thenNode), currentNode);
				}
			}

			lastTable = beforeLastTable;
		}
		
		if (param_1 == currentVar)
			has_val_1 = false;
		if (param_2 == currentVar)
			has_val_2 = false;

		Table thenNode = rel_algebra::getThenBranch(lastTable);
		if (!rel_algebra::isEmpty(thenNode))
			assert(false); // infinite domain detected for parameter
		currentNode = rel_algebra::ifThenElse(currentVar, rel_algebra::getValue(lastTable), rel_algebra::falseTable(), currentNode);
	}

	return currentNode;
}

bool generalized_filter_rename::is_rule_1_applicable()
{
	int64_t temp_5547 = param_1;
	int64_t temp_5548 = param_2;
	if (temp_5547 != temp_5548)
		return false;

	return true;
}

Table generalized_filter_rename::apply_rule_1(Table currentNode)
{
	rel_algebra_node temp_5550 = currentNode;

	return temp_5550;
}

bool generalized_filter_rename::is_rule_2_applicable()
{
	return true;
}

Table generalized_filter_rename::apply_rule_2(Table currentNode)
{
	rel_algebra_node temp_5556 = rel_algebra::trueTable();
	int64_t temp_5554 = 0;
	int64_t temp_5555 = param_1;
	rel_algebra_node temp_5560 = rel_algebra::filterEqualTo(temp_5554, temp_5555, temp_5556);
	rel_algebra_node temp_5561 = rel_algebra::complement(temp_5560);
	int64_t temp_5562 = param_1;
	int64_t temp_5564 = param_2;
	rel_algebra_node temp_5566 = currentNode;
	rel_algebra_node temp_5571 = generalized_filter_equals(temp_5562, temp_5564)(temp_5566);
	rel_algebra_node temp_5574 = rel_algebra::complement(rel_algebra::divide(temp_5561, rel_algebra::complement(temp_5571)));

	return temp_5574;
}

Table generalized_filter_rename::operator()(Table currentNode)
{
	if (rel_algebra::isEmpty(currentNode))
		return currentNode;

	if (is_rule_1_applicable())
		return apply_rule_1(currentNode);
	if (is_rule_2_applicable())
		return apply_rule_2(currentNode);

	if (rel_algebra::isLeafNode(currentNode))
		assert(false); // infinite domain
	VariableType currentVar = rel_algebra::getVariable(currentNode);
	bool infiniteDomainDetected = true;
	if (param_1 >= currentVar)
		infiniteDomainDetected = false;
	if (param_2 >= currentVar)
		infiniteDomainDetected = false;
	if (infiniteDomainDetected)
		assert(false); // infinite domain

	size_t currentStackSize = global_table_stack::size();
	while (true)
	{
		if (rel_algebra::isLeafNode(currentNode))
			break;
		if (rel_algebra::getVariable(currentNode) != currentVar)
			break;
		global_table_stack::push(currentNode);
		currentNode = rel_algebra::getElseBranch(currentNode);
	}

	bool currentVarIsAParam = false;
	if (param_1 == currentVar)
		currentVarIsAParam = true;
	if (param_2 == currentVar)
		currentVarIsAParam = true;
	if (!currentVarIsAParam)
	{
		currentNode = (*this)(currentNode);
		while (global_table_stack::size() > currentStackSize)
		{
			Table t = global_table_stack::pop();
			Table thenNode = rel_algebra::getThenBranch(t);
			currentNode = rel_algebra::ifThenElse(currentVar, rel_algebra::getValue(t), (*this)(thenNode), currentNode);
		}
	}
	else
	{
		if (!rel_algebra::isEmpty(currentNode))
			assert(false); // infinite domain detected for parameter
		if (param_1 == currentVar)
			has_val_1 = true;
		if (param_2 == currentVar)
			has_val_2 = true;
		Table lastTable = global_table_stack::pop();

		while (global_table_stack::size() > currentStackSize)
		{
			Table beforeLastTable = global_table_stack::pop();
			Table thenNode = rel_algebra::getThenBranch(lastTable);
			if (rel_algebra::isEmpty(thenNode))
				currentNode = rel_algebra::ifThenElse(currentVar, rel_algebra::getValue(lastTable), rel_algebra::falseTable(), currentNode);
			else
			{
				ValueType lowerBound = rel_algebra::getValue(beforeLastTable);
				ValueType upperBound = rel_algebra::getValue(lastTable);
				for (ValueType value = upperBound; value > lowerBound; value--)
				{
					if (param_1 == currentVar)
						param_val_1 = value;
					if (param_2 == currentVar)
						param_val_2 = value;
					currentNode = rel_algebra::ifThenElse(currentVar, value, (*this)(thenNode), currentNode);
				}
			}

			lastTable = beforeLastTable;
		}
		
		if (param_1 == currentVar)
			has_val_1 = false;
		if (param_2 == currentVar)
			has_val_2 = false;

		Table thenNode = rel_algebra::getThenBranch(lastTable);
		if (!rel_algebra::isEmpty(thenNode))
			assert(false); // infinite domain detected for parameter
		currentNode = rel_algebra::ifThenElse(currentVar, rel_algebra::getValue(lastTable), rel_algebra::falseTable(), currentNode);
	}

	return currentNode;
}
