/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*-  */
/*
 * assignment-manager.cc
 * Copyright (C) 2016 Shahab <shahab@tasharrofi.net>
 *
 * grounder-generator is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * grounder-generator is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <limits>

#include "assignment-manager.h"

AssignmentManager::IndexType AssignmentManager::iteratorStartPosition(0);
AssignmentManager::IndexType AssignmentManager::undefIndex(numeric_limits<IndexType>::max());

unordered_map<VariableType, AssignmentManager::AssignmentIterator> AssignmentManager::lastAssignment;
vector< pair<VariableType, AssignmentManager::IndexType> > AssignmentManager::iteratableAssignments;
vector<AssignmentManager::Action> AssignmentManager::actions;
stack<AssignmentManager::IndexType> AssignmentManager::undoPoints;

void AssignmentManager::undoAssignment(const AssignmentManager::AssignmentAction &a)
{
	auto it = lastAssignment.find(a.variable);
	assert(it != lastAssignment.end());

	if (a.previousIndex == undefIndex)
	{
		lastAssignment.erase(a.variable);
		iteratableAssignments.pop_back();
	}
	else
		iteratableAssignments[it->second.currentIndex].second = a.previousIndex;
}

void AssignmentManager::undoClear(const AssignmentManager::ClearAction &c)
{
	for (size_t i = c.previousIteratorStartPosition; i < iteratableAssignments.size(); i++)
		lastAssignment[iteratableAssignments[i].first] = AssignmentIterator(i);
	iteratorStartPosition = c.previousIteratorStartPosition;
}

void AssignmentManager::pushAssignment(VariableType variable, ValueType value)
{
	auto it = lastAssignment.find(variable);
	AssignmentAction aa;

	aa.variable = variable;
	aa.value = value;

	if (it == lastAssignment.end())
	{
		aa.previousIndex = undefIndex;
		lastAssignment[variable] = AssignmentIterator(iteratableAssignments.size());
		iteratableAssignments.push_back(pair<VariableType, IndexType>(variable, actions.size()));
	}
	else
	{
		aa.previousIndex = iteratableAssignments[it->second.currentIndex].second;
		iteratableAssignments[it->second.currentIndex].second = actions.size();
	}

	actions.push_back(aa);
}

void AssignmentManager::clear()
{
	ClearAction ca;
	ca.previousIteratorStartPosition = iteratorStartPosition;

	actions.push_back(ca);
	iteratorStartPosition = iteratableAssignments.size();
	lastAssignment.clear();
}

void AssignmentManager::undo()
{
	assert(undoPoints.size() > 0);

	IndexType lastUndoPoint = undoPoints.top();
	undoPoints.pop();

	while (actions.size() > lastUndoPoint)
	{
		Action lastAction = actions[actions.size() - 1];
		if (lastAction.which() == 0)
			undoLastAction(boost::get<ClearAction>(lastAction));
		else
			undoLastAction(boost::get<AssignmentAction>(lastAction));
		actions.pop_back();
	}
}

