/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*-  */
/*
 * scanner.h
 * Copyright (C) 2016 Shahab <shahab@tasharrofi.net>
 *
 * grounder-generator is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * grounder-generator is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _GG_SCANNER_H_
#define _GG_SCANNER_H_

#if ! defined(yyFlexLexerOnce)
#include <FlexLexer.h>
#endif

#include "parser.tab.hh"

namespace GG{

class GG_Scanner : public yyFlexLexer
{
public:
	GG_Scanner(std::istream *in) : yyFlexLexer(in) { loc = new GG::GG_Parser::location_type(); };
	virtual ~GG_Scanner() { delete loc; };

	//get rid of override virtual function warning
	using FlexLexer::yylex;

	virtual int yylex(GG::GG_Parser::semantic_type * const lval, GG::GG_Parser::location_type *location);
	// YY_DECL defined in gg_lexer.l
	// Method body created by flex in gg_lexer.yy.cc

private:
	/* yyval ptr */
	GG::GG_Parser::semantic_type *yylval = nullptr;
	/* location ptr */
	GG::GG_Parser::location_type *loc    = nullptr;
};

} /* end namespace GG */

#endif // _GG_SCANNER_H_

