
%skeleton "lalr1.cc"
%require  "3.0"
%debug 
%defines 
%define api.namespace {GG}
%define parser_class_name {GG_Parser}

%code requires{
#include <string>
#include "heading.h"
#include "compact-string.h"

namespace GG{
	class GG_Scanner;
}

using namespace std;

// The following definitions is missing when %locations isn't used
# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

}

%parse-param { GG_Scanner &scanner  }

%code{
#include <iostream>
#include <cstdlib>
#include <fstream>
#include "scanner.h"

#undef yylex
#define yylex scanner.yylex
}

%define api.value.type variant
%define parse.assert

%start init_symbol

%token <string> TOKEN_ID
%token <int64_t> TOKEN_INT
%token <string> TOKEN_STRING

%token KEYWORD_brave
%token KEYWORD_skeptical
%token KEYWORD_search
%token KEYWORD_enumerate
%token KEYWORD_triathlon
%token SYM_SHARP
%token KEYWORD_SATISFIABLE
%token KEYWORD_SAT
%token KEYWORD_ANSWER
%token KEYWORD_UNSATISFIABLE
%token KEYWORD_UNSAT
%token SYM_DOT
%type <gg_datatype_OutputSpec_base *> NT_OutputSpec
%type <gg_datatype_SearchResult_base *> NT_SearchResult
%type <gg_datatype_Argument_base *> NT_Argument
%type <vector<gg_datatype_SearchResult_base *>*> List_SearchResult
%type <vector<gg_datatype_Argument_base *>*> List_Argument


%locations

%%

init_symbol : NT_OutputSpec { $1->output_formatted(cout); }
NT_OutputSpec :
		  KEYWORD_brave NT_SearchResult[r]
		  { $$ = new gg_datatype_OutputSpec_type1($r); }
		| KEYWORD_skeptical NT_SearchResult[r]
		  { $$ = new gg_datatype_OutputSpec_type2($r); }
		| KEYWORD_search NT_SearchResult[r]
		  { $$ = new gg_datatype_OutputSpec_type3($r); }
		| KEYWORD_enumerate List_SearchResult[rs]
		  { $$ = new gg_datatype_OutputSpec_type4(*$rs); delete $rs; }
		| KEYWORD_triathlon List_SearchResult[gr_rs] SYM_SHARP List_SearchResult[st_rs] SYM_SHARP List_SearchResult[pr_rs]
		  { $$ = new gg_datatype_OutputSpec_type5(*$gr_rs, *$st_rs, *$pr_rs); delete $gr_rs; delete $st_rs; delete $pr_rs; }
		;
NT_SearchResult :
		  KEYWORD_SATISFIABLE KEYWORD_SAT KEYWORD_ANSWER List_Argument[args]
		  { $$ = new gg_datatype_SearchResult_type1(*$args); delete $args; }
		| KEYWORD_UNSATISFIABLE KEYWORD_UNSAT
		  { $$ = new gg_datatype_SearchResult_type2(); }
		| KEYWORD_UNSAT
		  { $$ = new gg_datatype_SearchResult_type3(); }
		;
NT_Argument :
		  TOKEN_ID[argId] SYM_DOT
		  { $$ = new gg_datatype_Argument_type1(compact_string::make_from($argId.c_str())); }
		| TOKEN_INT[argNo] SYM_DOT
		  { $$ = new gg_datatype_Argument_type2($argNo); }
		;

List_SearchResult :
		  /* empty */
		  { $$ = new vector<gg_datatype_SearchResult_base *>(); }
		| List_SearchResult[List] NT_SearchResult[Item]
		  { $List->push_back($Item); $$ = $List; }
		;

List_Argument :
		  /* empty */
		  { $$ = new vector<gg_datatype_Argument_base *>(); }
		| List_Argument[List] NT_Argument[Item]
		  { $List->push_back($Item); $$ = $List; }
		;

%%

void GG::GG_Parser::error(const location_type &l, const std::string &err_message)
{
	std::cerr << "Error: " << err_message << " at " << l << "\n";
}

