
%{
/* C++ string header, for string ops below */
#include <string>

/* Implementation of yyFlexScanner */
#include "scanner.h"

#undef  YY_DECL
#define YY_DECL int GG::GG_Scanner::yylex(GG::GG_Parser::semantic_type *const lval, GG::GG_Parser::location_type *loc)

/* typedef to make the returns for the tokens shorter */
using token = GG::GG_Parser::token;

/* update location on matching */
#define YY_USER_ACTION loc->step(); loc->columns(yyleng);

%}

%option debug
%option nodefault
%option yyclass="GG::GG_Scanner"
%option noyywrap
%option c++

alphabet [a-zA-Z]
digit		[0-9]
int_const	{digit}+
identifier [a-zA-Z_][a-zA-Z0-9_]*


%%
%{          /** Code executed at the beginning of yylex **/
            yylval = lval;
%}

"triathlon" { return token::KEYWORD_triathlon; }
"skeptical" { return token::KEYWORD_skeptical; }
"search" { return token::KEYWORD_search; }
"enumerate" { return token::KEYWORD_enumerate; }
"brave" { return token::KEYWORD_brave; }
"UNSATISFIABLE" { return token::KEYWORD_UNSATISFIABLE; }
"UNSAT" { return token::KEYWORD_UNSAT; }
"SATISFIABLE" { return token::KEYWORD_SATISFIABLE; }
"SAT" { return token::KEYWORD_SAT; }
"ANSWER" { return token::KEYWORD_ANSWER; }
"." { return token::SYM_DOT; }
"#" { return token::SYM_SHARP; }

{int_const}	{ yylval->build<int64_t>(atoi(yytext)); return token::TOKEN_INT; }
{identifier}	{ yylval->build<std::string>(yytext); return token::TOKEN_ID; }
\"(\\.|[^\\\"])*\"	{ yylval->build<std::string>(yytext); return token::TOKEN_STRING; }

[ \t]*		{}
[\n]		{ loc->lines();	}

.		{ std::cerr << "SCANNER "; YY_FATAL_ERROR(""); exit(1);	}

